/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.QRDecomposer;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.measurements.gnss.AmbiguityAcceptance;
import org.orekit.estimation.measurements.gnss.IntegerBootstrapping;
import org.orekit.estimation.measurements.gnss.IntegerLeastSquareSolution;
import org.orekit.estimation.measurements.gnss.IntegerLeastSquareSolver;
import org.orekit.utils.ParameterDriver;

public class AmbiguitySolver {
    private final List<ParameterDriver> ambiguityDrivers;
    private final IntegerLeastSquareSolver solver;
    private final AmbiguityAcceptance acceptance;

    public AmbiguitySolver(List<ParameterDriver> ambiguityDrivers, IntegerLeastSquareSolver solver, AmbiguityAcceptance acceptance) {
        this.ambiguityDrivers = ambiguityDrivers;
        this.solver = solver;
        this.acceptance = acceptance;
    }

    public List<ParameterDriver> getAllAmbiguityDrivers() {
        return Collections.unmodifiableList(this.ambiguityDrivers);
    }

    protected List<ParameterDriver> getFreeAmbiguityDrivers() {
        return this.ambiguityDrivers.stream().filter(d -> {
            if (d.isSelected()) {
                double near = FastMath.rint((double)d.getValue());
                double gapMin = near - d.getMinValue();
                double gapMax = d.getMaxValue() - near;
                return FastMath.max((double)FastMath.abs((double)gapMin), (double)FastMath.abs((double)gapMax)) > 1.0E-15;
            }
            return false;
        }).collect(Collectors.toList());
    }

    protected int[] getFreeAmbiguityIndirection(int startIndex, List<ParameterDriver> measurementsParametersDrivers) {
        List<ParameterDriver> freeDrivers = this.getFreeAmbiguityDrivers();
        int n = freeDrivers.size();
        int[] indirection = new int[n];
        for (int i = 0; i < n; ++i) {
            indirection[i] = -1;
            String name = freeDrivers.get(i).getName();
            for (int k = 0; k < measurementsParametersDrivers.size(); ++k) {
                if (!name.equals(measurementsParametersDrivers.get(k).getName())) continue;
                indirection[i] = startIndex + k;
                break;
            }
            if (indirection[i] >= 0) continue;
            StringBuilder builder = new StringBuilder();
            for (ParameterDriver driver : measurementsParametersDrivers) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(driver.getName());
            }
            throw new OrekitIllegalArgumentException(OrekitMessages.UNSUPPORTED_PARAMETER_NAME, name, builder.toString());
        }
        return indirection;
    }

    public void unFixAmbiguity(ParameterDriver ambiguityDriver) {
        ambiguityDriver.setMinValue(Double.NEGATIVE_INFINITY);
        ambiguityDriver.setMaxValue(Double.POSITIVE_INFINITY);
    }

    public List<ParameterDriver> fixIntegerAmbiguities(int startIndex, List<ParameterDriver> measurementsParametersDrivers, RealMatrix covariance) {
        List<ParameterDriver> ambiguities = this.getAllAmbiguityDrivers();
        double[] floatAmbiguities = ambiguities.stream().mapToDouble(d -> d.getValue()).toArray();
        int[] indirection = this.getFreeAmbiguityIndirection(startIndex, measurementsParametersDrivers);
        IntegerLeastSquareSolution[] candidates = this.solver.solveILS(this.acceptance.numberOfCandidates(), floatAmbiguities, indirection, covariance);
        if (this.solver instanceof IntegerBootstrapping && candidates.length == 0) {
            return Collections.emptyList();
        }
        if (candidates.length < this.acceptance.numberOfCandidates()) {
            return Collections.emptyList();
        }
        IntegerLeastSquareSolution bestCandidate = this.acceptance.accept(candidates);
        if (bestCandidate == null) {
            return Collections.emptyList();
        }
        long[] fixedAmbiguities = bestCandidate.getSolution();
        ArrayList<ParameterDriver> fixedDrivers = new ArrayList<ParameterDriver>(indirection.length);
        for (int i = 0; i < indirection.length; ++i) {
            ParameterDriver driver = measurementsParametersDrivers.get(indirection[i] - startIndex);
            driver.setMinValue(fixedAmbiguities[i]);
            driver.setMaxValue(fixedAmbiguities[i]);
            fixedDrivers.add(driver);
        }
        RealMatrix Qab = this.getCovMatrix(covariance, indirection);
        RealVector X = new QRDecomposer(1.0E-10).decompose(this.getAmbiguityMatrix(covariance, indirection)).solve(MatrixUtils.createRealVector((double[])floatAmbiguities).subtract(MatrixUtils.createRealVector((double[])this.toDoubleArray(fixedAmbiguities.length, fixedAmbiguities))));
        RealVector Y = Qab.preMultiply(X);
        for (int i = startIndex + 1; i < covariance.getColumnDimension(); ++i) {
            if (this.belongTo(indirection, i)) continue;
            ParameterDriver driver = measurementsParametersDrivers.get(i - startIndex);
            driver.setValue(driver.getValue() - Y.getEntry(i - startIndex));
        }
        return fixedDrivers;
    }

    private RealMatrix getCovMatrix(RealMatrix cov, int[] indirection) {
        RealMatrix Qab = MatrixUtils.createRealMatrix((int)indirection.length, (int)cov.getColumnDimension());
        int index = 0;
        for (int iter = 0; iter < indirection.length; ++iter) {
            for (int j = 0; j < cov.getColumnDimension(); ++j) {
                if (this.belongTo(indirection, j)) continue;
                Qab.setEntry(index, 0, cov.getEntry(index, 0));
            }
            ++index;
        }
        return Qab;
    }

    private RealMatrix getAmbiguityMatrix(RealMatrix cov, int[] indirection) {
        RealMatrix Qa = MatrixUtils.createRealMatrix((int)indirection.length, (int)indirection.length);
        for (int i = 0; i < indirection.length; ++i) {
            Qa.setEntry(i, i, cov.getEntry(indirection[i], indirection[i]));
            for (int j = 0; j < i; ++j) {
                Qa.setEntry(i, j, cov.getEntry(indirection[i], indirection[j]));
                Qa.setEntry(j, i, cov.getEntry(indirection[i], indirection[j]));
            }
        }
        return Qa;
    }

    private boolean belongTo(int[] indirection, int pos) {
        for (int j : indirection) {
            if (pos != j) continue;
            return true;
        }
        return false;
    }

    private double[] toDoubleArray(int size, long[] longArray) {
        double[] doubleArray = new double[size];
        for (int index = 0; index < size; ++index) {
            doubleArray[index] = longArray[index];
        }
        return doubleArray;
    }
}

