/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import org.hipparchus.util.FastMath;

class AlternatingSampler {
    private final double a;
    private final long offset;
    private final long sign;
    private long min;
    private long max;
    private long k1;
    private long k0;
    private long current;

    AlternatingSampler(double a, double r) {
        this.a = a;
        this.offset = (long)FastMath.rint((double)a);
        this.sign = (double)this.offset <= a ? 1L : -1L;
        this.setRadius(r);
        this.k1 = 0L;
        this.k0 = 0L;
        this.current = this.offset;
    }

    public void setRadius(double r) {
        this.min = (long)FastMath.ceil((double)(this.a - r));
        this.max = (long)FastMath.floor((double)(this.a + r));
    }

    public double getMidPoint() {
        return this.a;
    }

    public long getCurrent() {
        return this.current;
    }

    public boolean inRange() {
        return this.min <= this.current && this.current <= this.max;
    }

    public void generateNext() {
        long k2 = this.k1;
        this.k1 = this.k0;
        this.k0 = 1L - (this.k1 << 1) - k2;
        this.current = this.offset + this.sign * this.k0;
    }
}

