/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.errors;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.LocalizedException;

public class OrekitIOException
extends IOException
implements LocalizedException {
    private static final long serialVersionUID = 20180427L;
    private final Localizable specifier;
    private final Object[] parts;

    public OrekitIOException(Localizable specifier, Object ... parts) {
        this.specifier = specifier;
        this.parts = parts == null ? new Object[]{} : (Object[])parts.clone();
    }

    @Override
    public String getMessage(Locale locale) {
        return this.buildMessage(locale);
    }

    @Override
    public String getMessage() {
        return this.buildMessage(Locale.US);
    }

    @Override
    public String getLocalizedMessage() {
        return this.buildMessage(Locale.getDefault());
    }

    @Override
    public Localizable getSpecifier() {
        return this.specifier;
    }

    @Override
    public Object[] getParts() {
        return (Object[])this.parts.clone();
    }

    private String buildMessage(Locale locale) {
        return this.specifier == null ? "" : new MessageFormat(this.specifier.getLocalizedString(locale), locale).format(this.parts);
    }
}

