/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.BodiesElements;
import org.orekit.data.DataContext;
import org.orekit.data.FieldBodiesElements;
import org.orekit.data.PolynomialParser;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScalarFunction;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.utils.IERSConventions;

public class FundamentalNutationArguments
implements Serializable {
    private static final long serialVersionUID = 20131209L;
    private final IERSConventions conventions;
    private final TimeScale timeScale;
    private final transient TimeScalarFunction gmstFunction;
    private final transient TimeScalarFunction gmstRateFunction;
    private final double[] lCoefficients;
    private final double[] lPrimeCoefficients;
    private final double[] fCoefficients;
    private final double[] dCoefficients;
    private final double[] omegaCoefficients;
    private final double[] lMeCoefficients;
    private final double[] lVeCoefficients;
    private final double[] lECoefficients;
    private final double[] lMaCoefficients;
    private final double[] lJCoefficients;
    private final double[] lSaCoefficients;
    private final double[] lUCoefficients;
    private final double[] lNeCoefficients;
    private final double[] paCoefficients;
    private final transient TimeScales timeScales;

    @DefaultDataContext
    public FundamentalNutationArguments(IERSConventions conventions, TimeScale timeScale, InputStream stream, String name) {
        this(conventions, timeScale, stream, name, DataContext.getDefault().getTimeScales());
    }

    public FundamentalNutationArguments(IERSConventions conventions, TimeScale timeScale, InputStream stream, String name, TimeScales timeScales) {
        this(conventions, timeScale, FundamentalNutationArguments.parseCoefficients(stream, name), timeScales);
    }

    @DefaultDataContext
    public FundamentalNutationArguments(IERSConventions conventions, TimeScale timeScale, List<double[]> coefficients) {
        this(conventions, timeScale, coefficients, DataContext.getDefault().getTimeScales());
    }

    public FundamentalNutationArguments(IERSConventions conventions, TimeScale timeScale, List<double[]> coefficients, TimeScales timeScales) {
        this.conventions = conventions;
        this.timeScale = timeScale;
        this.timeScales = timeScales;
        this.gmstFunction = timeScale == null ? null : conventions.getGMSTFunction(timeScale, timeScales);
        this.gmstRateFunction = timeScale == null ? null : conventions.getGMSTRateFunction(timeScale, timeScales);
        this.lCoefficients = coefficients.get(0);
        this.lPrimeCoefficients = coefficients.get(1);
        this.fCoefficients = coefficients.get(2);
        this.dCoefficients = coefficients.get(3);
        this.omegaCoefficients = coefficients.get(4);
        this.lMeCoefficients = coefficients.get(5);
        this.lVeCoefficients = coefficients.get(6);
        this.lECoefficients = coefficients.get(7);
        this.lMaCoefficients = coefficients.get(8);
        this.lJCoefficients = coefficients.get(9);
        this.lSaCoefficients = coefficients.get(10);
        this.lUCoefficients = coefficients.get(11);
        this.lNeCoefficients = coefficients.get(12);
        this.paCoefficients = coefficients.get(13);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<double[]> parseCoefficients(InputStream stream, String name) {
        if (stream == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, name);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            DefinitionParser definitionParser = new DefinitionParser();
            int lineNumber = 0;
            int n = FundamentalName.values().length;
            HashMap<FundamentalName, double[]> polynomials = new HashMap<FundamentalName, double[]>(n);
            String line = reader.readLine();
            while (line != null) {
                if (definitionParser.parseDefinition(line, ++lineNumber, name)) {
                    polynomials.put(definitionParser.getParsedName(), definitionParser.getParsedPolynomial());
                }
                line = reader.readLine();
            }
            ArrayList<double[]> coefficients = new ArrayList<double[]>(n);
            coefficients.add(FundamentalNutationArguments.getCoefficients(FundamentalName.L, polynomials, name));
            coefficients.add(FundamentalNutationArguments.getCoefficients(FundamentalName.L_PRIME, polynomials, name));
            coefficients.add(FundamentalNutationArguments.getCoefficients(FundamentalName.F, polynomials, name));
            coefficients.add(FundamentalNutationArguments.getCoefficients(FundamentalName.D, polynomials, name));
            coefficients.add(FundamentalNutationArguments.getCoefficients(FundamentalName.OMEGA, polynomials, name));
            if (polynomials.containsKey((Object)FundamentalName.L_ME)) {
                coefficients.add(FundamentalNutationArguments.getCoefficients(FundamentalName.L_ME, polynomials, name));
                coefficients.add(FundamentalNutationArguments.getCoefficients(FundamentalName.L_VE, polynomials, name));
                coefficients.add(FundamentalNutationArguments.getCoefficients(FundamentalName.L_E, polynomials, name));
                coefficients.add(FundamentalNutationArguments.getCoefficients(FundamentalName.L_MA, polynomials, name));
                coefficients.add(FundamentalNutationArguments.getCoefficients(FundamentalName.L_J, polynomials, name));
                coefficients.add(FundamentalNutationArguments.getCoefficients(FundamentalName.L_SA, polynomials, name));
                coefficients.add(FundamentalNutationArguments.getCoefficients(FundamentalName.L_U, polynomials, name));
                coefficients.add(FundamentalNutationArguments.getCoefficients(FundamentalName.L_NE, polynomials, name));
                coefficients.add(FundamentalNutationArguments.getCoefficients(FundamentalName.PA, polynomials, name));
            } else {
                double[] zero = new double[]{0.0};
                while (coefficients.size() < n) {
                    coefficients.add(zero);
                }
            }
            ArrayList<double[]> arrayList = coefficients;
            return arrayList;
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    private static double[] getCoefficients(FundamentalName argument, Map<FundamentalName, double[]> polynomials, String fileName) {
        if (!polynomials.containsKey((Object)argument)) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_IERS_DATA_FILE, fileName);
        }
        return polynomials.get((Object)argument);
    }

    private double value(double tc, double[] coefficients) {
        double value = 0.0;
        for (int i = coefficients.length - 1; i >= 0; --i) {
            value = coefficients[i] + tc * value;
        }
        return value;
    }

    private double derivative(double tc, double[] coefficients) {
        double derivative = 0.0;
        for (int i = coefficients.length - 1; i > 0; --i) {
            derivative = (double)i * coefficients[i] + tc * derivative;
        }
        return derivative / 3.15576E9;
    }

    private <T extends CalculusFieldElement<T>> T value(T tc, double[] coefficients) {
        CalculusFieldElement value = (CalculusFieldElement)tc.getField().getZero();
        for (int i = coefficients.length - 1; i >= 0; --i) {
            value = (CalculusFieldElement)((CalculusFieldElement)tc.multiply((FieldElement)value)).add(coefficients[i]);
        }
        return (T)value;
    }

    private <T extends CalculusFieldElement<T>> T derivative(T tc, double[] coefficients) {
        CalculusFieldElement derivative = (CalculusFieldElement)tc.getField().getZero();
        for (int i = coefficients.length - 1; i > 0; --i) {
            derivative = (CalculusFieldElement)((CalculusFieldElement)tc.multiply((FieldElement)derivative)).add((double)i * coefficients[i]);
        }
        return (T)((CalculusFieldElement)derivative.divide(3.15576E9));
    }

    public BodiesElements evaluateAll(AbsoluteDate date) {
        double tc = this.conventions.evaluateTC(date, this.timeScales);
        double gamma = this.gmstFunction == null ? Double.NaN : this.gmstFunction.value(date) + Math.PI;
        double gammaDot = this.gmstRateFunction == null ? Double.NaN : this.gmstRateFunction.value(date);
        return new BodiesElements(date, tc, gamma, gammaDot, this.value(tc, this.lCoefficients), this.derivative(tc, this.lCoefficients), this.value(tc, this.lPrimeCoefficients), this.derivative(tc, this.lPrimeCoefficients), this.value(tc, this.fCoefficients), this.derivative(tc, this.fCoefficients), this.value(tc, this.dCoefficients), this.derivative(tc, this.dCoefficients), this.value(tc, this.omegaCoefficients), this.derivative(tc, this.omegaCoefficients), this.value(tc, this.lMeCoefficients), this.derivative(tc, this.lMeCoefficients), this.value(tc, this.lVeCoefficients), this.derivative(tc, this.lVeCoefficients), this.value(tc, this.lECoefficients), this.derivative(tc, this.lECoefficients), this.value(tc, this.lMaCoefficients), this.derivative(tc, this.lMaCoefficients), this.value(tc, this.lJCoefficients), this.derivative(tc, this.lJCoefficients), this.value(tc, this.lSaCoefficients), this.derivative(tc, this.lSaCoefficients), this.value(tc, this.lUCoefficients), this.derivative(tc, this.lUCoefficients), this.value(tc, this.lNeCoefficients), this.derivative(tc, this.lNeCoefficients), this.value(tc, this.paCoefficients), this.derivative(tc, this.paCoefficients));
    }

    public <T extends CalculusFieldElement<T>> FieldBodiesElements<T> evaluateAll(FieldAbsoluteDate<T> date) {
        T tc = this.conventions.evaluateTC(date, this.timeScales);
        CalculusFieldElement gamma = this.gmstFunction == null ? (CalculusFieldElement)((CalculusFieldElement)tc.getField().getZero()).add(Double.NaN) : (CalculusFieldElement)this.gmstFunction.value(date).add(tc.getPi());
        T gammaDot = this.gmstRateFunction == null ? (CalculusFieldElement)((CalculusFieldElement)tc.getField().getZero()).add(Double.NaN) : this.gmstRateFunction.value(date);
        return new FieldBodiesElements<CalculusFieldElement>((FieldAbsoluteDate<CalculusFieldElement>)date, (CalculusFieldElement)tc, gamma, (CalculusFieldElement)gammaDot, (CalculusFieldElement)this.value(tc, this.lCoefficients), (CalculusFieldElement)this.derivative(tc, this.lCoefficients), (CalculusFieldElement)this.value(tc, this.lPrimeCoefficients), (CalculusFieldElement)this.derivative(tc, this.lPrimeCoefficients), (CalculusFieldElement)this.value(tc, this.fCoefficients), (CalculusFieldElement)this.derivative(tc, this.fCoefficients), (CalculusFieldElement)this.value(tc, this.dCoefficients), (CalculusFieldElement)this.derivative(tc, this.dCoefficients), (CalculusFieldElement)this.value(tc, this.omegaCoefficients), (CalculusFieldElement)this.derivative(tc, this.omegaCoefficients), (CalculusFieldElement)this.value(tc, this.lMeCoefficients), (CalculusFieldElement)this.derivative(tc, this.lMeCoefficients), (CalculusFieldElement)this.value(tc, this.lVeCoefficients), (CalculusFieldElement)this.derivative(tc, this.lVeCoefficients), (CalculusFieldElement)this.value(tc, this.lECoefficients), (CalculusFieldElement)this.derivative(tc, this.lECoefficients), (CalculusFieldElement)this.value(tc, this.lMaCoefficients), (CalculusFieldElement)this.derivative(tc, this.lMaCoefficients), (CalculusFieldElement)this.value(tc, this.lJCoefficients), (CalculusFieldElement)this.derivative(tc, this.lJCoefficients), (CalculusFieldElement)this.value(tc, this.lSaCoefficients), (CalculusFieldElement)this.derivative(tc, this.lSaCoefficients), (CalculusFieldElement)this.value(tc, this.lUCoefficients), (CalculusFieldElement)this.derivative(tc, this.lUCoefficients), (CalculusFieldElement)this.value(tc, this.lNeCoefficients), (CalculusFieldElement)this.derivative(tc, this.lNeCoefficients), (CalculusFieldElement)this.value(tc, this.paCoefficients), (CalculusFieldElement)this.derivative(tc, this.paCoefficients));
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DataTransferObject(this.conventions, this.timeScale, Arrays.asList(this.lCoefficients, this.lPrimeCoefficients, this.fCoefficients, this.dCoefficients, this.omegaCoefficients, this.lMeCoefficients, this.lVeCoefficients, this.lECoefficients, this.lMaCoefficients, this.lJCoefficients, this.lSaCoefficients, this.lUCoefficients, this.lNeCoefficients, this.paCoefficients));
    }

    private static class DefinitionParser {
        private final Pattern pattern;
        private PolynomialParser polynomialParser;
        private FundamentalName parsedName;
        private double[] parsedPolynomial;

        DefinitionParser() {
            String unicodeIdenticalTo = "\u2261";
            StringBuilder builder = new StringBuilder();
            for (FundamentalName fn : FundamentalName.values()) {
                if (builder.length() > 0) {
                    builder.append('|');
                }
                builder.append(fn.getArgumentName());
            }
            String fundamentalName = "\\p{Space}*((?:" + builder.toString() + ")+)";
            this.pattern = Pattern.compile("\\p{Space}*F\\p{Digit}+\\p{Space}*\u2261" + fundamentalName + "\\p{Space}*=\\p{Space}*(.*)");
            this.polynomialParser = new PolynomialParser('t', PolynomialParser.Unit.NO_UNITS);
        }

        public boolean parseDefinition(String line, int lineNumber, String fileName) {
            this.parsedName = null;
            this.parsedPolynomial = null;
            Matcher matcher = this.pattern.matcher(line);
            if (matcher.matches()) {
                for (FundamentalName fn : FundamentalName.values()) {
                    if (!fn.getArgumentName().equals(matcher.group(1))) continue;
                    this.parsedName = fn;
                }
                this.parsedPolynomial = this.polynomialParser.parse(matcher.group(2));
                return true;
            }
            return false;
        }

        public FundamentalName getParsedName() {
            return this.parsedName;
        }

        public double[] getParsedPolynomial() {
            return (double[])this.parsedPolynomial.clone();
        }
    }

    private static enum FundamentalName {
        L{

            @Override
            public String getArgumentName() {
                return "l";
            }
        }
        ,
        L_PRIME{

            @Override
            public String getArgumentName() {
                return "l'";
            }
        }
        ,
        F{

            @Override
            public String getArgumentName() {
                return "F";
            }
        }
        ,
        D{

            @Override
            public String getArgumentName() {
                return "D";
            }
        }
        ,
        OMEGA{

            @Override
            public String getArgumentName() {
                return "\u03a9";
            }
        }
        ,
        L_ME{

            @Override
            public String getArgumentName() {
                return "LMe";
            }
        }
        ,
        L_VE{

            @Override
            public String getArgumentName() {
                return "LVe";
            }
        }
        ,
        L_E{

            @Override
            public String getArgumentName() {
                return "LE";
            }
        }
        ,
        L_MA{

            @Override
            public String getArgumentName() {
                return "LMa";
            }
        }
        ,
        L_J{

            @Override
            public String getArgumentName() {
                return "LJ";
            }
        }
        ,
        L_SA{

            @Override
            public String getArgumentName() {
                return "LSa";
            }
        }
        ,
        L_U{

            @Override
            public String getArgumentName() {
                return "LU";
            }
        }
        ,
        L_NE{

            @Override
            public String getArgumentName() {
                return "LNe";
            }
        }
        ,
        PA{

            @Override
            public String getArgumentName() {
                return "pA";
            }
        };


        public abstract String getArgumentName();
    }

    @DefaultDataContext
    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final IERSConventions conventions;
        private final TimeScale timeScale;
        private final List<double[]> coefficients;

        DataTransferObject(IERSConventions conventions, TimeScale timeScale, List<double[]> coefficients) {
            this.conventions = conventions;
            this.timeScale = timeScale;
            this.coefficients = coefficients;
        }

        private Object readResolve() {
            try {
                return new FundamentalNutationArguments(this.conventions, this.timeScale, this.coefficients);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

