/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import java.text.NumberFormat;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.CompositeFormat;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;

public class GeodeticPoint
implements Serializable {
    public static final GeodeticPoint NORTH_POLE = new GeodeticPoint(1.5707963267948966, 0.0, 0.0);
    public static final GeodeticPoint SOUTH_POLE = new GeodeticPoint(-1.5707963267948966, 0.0, 0.0);
    private static final long serialVersionUID = 7862466825590075399L;
    private final double latitude;
    private final double longitude;
    private final double altitude;
    private transient Vector3D zenith;
    private transient Vector3D nadir;
    private transient Vector3D north;
    private transient Vector3D south;
    private transient Vector3D east;
    private transient Vector3D west;

    public GeodeticPoint(double latitude, double longitude, double altitude) {
        double lat = MathUtils.normalizeAngle((double)latitude, (double)1.5707963267948966);
        double lon = MathUtils.normalizeAngle((double)longitude, (double)0.0);
        if (lat > 1.5707963267948966) {
            lat = Math.PI - lat;
            lon = MathUtils.normalizeAngle((double)(longitude + Math.PI), (double)0.0);
        }
        this.latitude = lat;
        this.longitude = lon;
        this.altitude = altitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public Vector3D getZenith() {
        if (this.zenith == null) {
            SinCos scLat = FastMath.sinCos((double)this.latitude);
            SinCos scLon = FastMath.sinCos((double)this.longitude);
            this.zenith = new Vector3D(scLon.cos() * scLat.cos(), scLon.sin() * scLat.cos(), scLat.sin());
        }
        return this.zenith;
    }

    public Vector3D getNadir() {
        if (this.nadir == null) {
            this.nadir = this.getZenith().negate();
        }
        return this.nadir;
    }

    public Vector3D getNorth() {
        if (this.north == null) {
            SinCos scLat = FastMath.sinCos((double)this.latitude);
            SinCos scLon = FastMath.sinCos((double)this.longitude);
            this.north = new Vector3D(-scLon.cos() * scLat.sin(), -scLon.sin() * scLat.sin(), scLat.cos());
        }
        return this.north;
    }

    public Vector3D getSouth() {
        if (this.south == null) {
            this.south = this.getNorth().negate();
        }
        return this.south;
    }

    public Vector3D getEast() {
        if (this.east == null) {
            SinCos scLon = FastMath.sinCos((double)this.longitude);
            this.east = new Vector3D(-scLon.sin(), scLon.cos(), 0.0);
        }
        return this.east;
    }

    public Vector3D getWest() {
        if (this.west == null) {
            this.west = this.getEast().negate();
        }
        return this.west;
    }

    public boolean equals(Object object) {
        if (object instanceof GeodeticPoint) {
            GeodeticPoint other = (GeodeticPoint)object;
            return this.getLatitude() == other.getLatitude() && this.getLongitude() == other.getLongitude() && this.getAltitude() == other.getAltitude();
        }
        return false;
    }

    public int hashCode() {
        return Double.valueOf(this.getLatitude()).hashCode() ^ Double.valueOf(this.getLongitude()).hashCode() ^ Double.valueOf(this.getAltitude()).hashCode();
    }

    public String toString() {
        NumberFormat format = CompositeFormat.getDefaultNumberFormat();
        return "{lat: " + format.format(FastMath.toDegrees((double)this.getLatitude())) + " deg, lon: " + format.format(FastMath.toDegrees((double)this.getLongitude())) + " deg, alt: " + format.format(this.getAltitude()) + "}";
    }
}

