/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeInterpolable;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;

public class FixedRate
implements AttitudeProvider {
    private final Attitude referenceAttitude;

    public FixedRate(Attitude referenceAttitude) {
        this.referenceAttitude = referenceAttitude;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        double timeShift = date.durationFrom(this.referenceAttitude.getDate());
        Attitude shifted = this.referenceAttitude.shiftedBy(timeShift);
        return shifted.withReferenceFrame(frame);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        Field<T> field = date.getField();
        T timeShift = date.durationFrom(this.referenceAttitude.getDate());
        FieldTimeInterpolable shifted = new FieldAttitude<T>(field, this.referenceAttitude).shiftedBy((CalculusFieldElement)timeShift);
        return ((FieldAttitude)shifted).withReferenceFrame(frame);
    }

    public Attitude getReferenceAttitude() {
        return this.referenceAttitude;
    }
}

