/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeBuilder;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldAngularCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class FixedFrameBuilder
implements AttitudeBuilder {
    private final Frame referenceFrame;

    public FixedFrameBuilder(Frame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    @Override
    public Attitude build(Frame frame, PVCoordinatesProvider pvProv, TimeStampedAngularCoordinates rawAttitude) {
        AbsoluteDate date = rawAttitude.getDate();
        Transform t = frame.getTransformTo(this.referenceFrame, date);
        TimeStampedAngularCoordinates frame2Ref = new TimeStampedAngularCoordinates(date, t.getRotation(), t.getRotationRate(), t.getRotationAcceleration());
        return new Attitude(frame, rawAttitude.addOffset(frame2Ref));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> build(Frame frame, FieldPVCoordinatesProvider<T> pvProv, TimeStampedFieldAngularCoordinates<T> rawAttitude) {
        FieldAbsoluteDate<T> date = rawAttitude.getDate();
        FieldTransform<T> t = frame.getTransformTo(this.referenceFrame, date);
        TimeStampedFieldAngularCoordinates<T> frame2Ref = new TimeStampedFieldAngularCoordinates<T>(date, t.getRotation(), t.getRotationRate(), t.getRotationAcceleration());
        return new FieldAttitude(frame, rawAttitude.addOffset((FieldAngularCoordinates)frame2Ref));
    }
}

