/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import java.io.Serializable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.moment.FourthMoment;
import org.hipparchus.stat.descriptive.moment.Variance;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class Kurtosis
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    protected final FourthMoment moment;
    protected final boolean incMoment;

    public Kurtosis() {
        this.moment = new FourthMoment();
        this.incMoment = true;
    }

    public Kurtosis(FourthMoment m4) {
        this.moment = m4;
        this.incMoment = false;
    }

    public Kurtosis(Kurtosis original) throws NullArgumentException {
        MathUtils.checkNotNull((Object)original);
        this.moment = original.moment.copy();
        this.incMoment = original.incMoment;
    }

    @Override
    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    @Override
    public double getResult() {
        double kurtosis = Double.NaN;
        if (this.moment.getN() > 3L) {
            double variance = this.moment.m2 / (double)(this.moment.n - 1L);
            if (this.moment.n <= 3L || variance < 1.0E-19) {
                kurtosis = 0.0;
            } else {
                double n = this.moment.n;
                kurtosis = (n * (n + 1.0) * this.moment.getResult() - 3.0 * this.moment.m2 * this.moment.m2 * (n - 1.0)) / ((n - 1.0) * (n - 2.0) * (n - 3.0) * variance * variance);
            }
        }
        return kurtosis;
    }

    @Override
    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    @Override
    public long getN() {
        return this.moment.getN();
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        double kurt = Double.NaN;
        if (MathArrays.verifyValues((double[])values, (int)begin, (int)length) && length > 3) {
            Variance variance = new Variance();
            variance.incrementAll(values, begin, length);
            double mean = variance.moment.m1;
            double stdDev = FastMath.sqrt((double)variance.getResult());
            double accum3 = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                accum3 += FastMath.pow((double)(values[i] - mean), (double)4.0);
            }
            double n0 = length;
            double coefficientOne = n0 * (n0 + 1.0) / ((n0 - 1.0) * (n0 - 2.0) * (n0 - 3.0));
            double termTwo = 3.0 * FastMath.pow((double)(n0 - 1.0), (double)2.0) / ((n0 - 2.0) * (n0 - 3.0));
            kurt = coefficientOne * (accum3 /= FastMath.pow((double)stdDev, (double)4.0)) - termTwo;
        }
        return kurt;
    }

    @Override
    public Kurtosis copy() {
        return new Kurtosis(this);
    }
}

