/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.partitioning;

import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BSPTreeVisitor;
import org.hipparchus.geometry.partitioning.BoundaryAttribute;
import org.hipparchus.geometry.partitioning.Characterization;
import org.hipparchus.geometry.partitioning.NodesSet;
import org.hipparchus.geometry.partitioning.SubHyperplane;

class BoundaryBuilder<S extends Space>
implements BSPTreeVisitor<S> {
    BoundaryBuilder() {
    }

    @Override
    public BSPTreeVisitor.Order visitOrder(BSPTree<S> node) {
        return BSPTreeVisitor.Order.PLUS_MINUS_SUB;
    }

    @Override
    public void visitInternalNode(BSPTree<S> node) {
        Characterization<S> minusChar;
        SubHyperplane<S> plusOutside = null;
        SubHyperplane<S> plusInside = null;
        NodesSet<S> splitters = null;
        Characterization<S> plusChar = new Characterization<S>(node.getPlus(), node.getCut().copySelf());
        if (plusChar.touchOutside() && (minusChar = new Characterization<S>(node.getMinus(), plusChar.outsideTouching())).touchInside()) {
            plusOutside = minusChar.insideTouching();
            splitters = new NodesSet<S>();
            splitters.addAll(minusChar.getInsideSplitters());
            splitters.addAll(plusChar.getOutsideSplitters());
        }
        if (plusChar.touchInside() && (minusChar = new Characterization<S>(node.getMinus(), plusChar.insideTouching())).touchOutside()) {
            plusInside = minusChar.outsideTouching();
            if (splitters == null) {
                splitters = new NodesSet();
            }
            splitters.addAll(minusChar.getOutsideSplitters());
            splitters.addAll(plusChar.getInsideSplitters());
        }
        if (splitters != null) {
            for (BSPTree<S> up = node.getParent(); up != null; up = up.getParent()) {
                splitters.add(up);
            }
        }
        node.setAttribute(new BoundaryAttribute(plusOutside, plusInside, splitters));
    }

    @Override
    public void visitLeafNode(BSPTree<S> node) {
    }
}

