/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.complex.Complex;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarN;
import org.hipparchus.special.elliptic.jacobi.FieldJacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.FieldJacobiTheta;
import org.hipparchus.special.elliptic.jacobi.FieldTheta;
import org.hipparchus.special.elliptic.legendre.LegendreEllipticIntegral;
import org.hipparchus.util.FastMath;

class ComplexParameter
extends FieldJacobiElliptic<Complex> {
    private final FieldJacobiTheta<Complex> jacobiTheta;
    private final Complex bigK;
    private final Complex iBigKPrime;
    private final double rK;
    private final double iK;
    private final double rKPrime;
    private final double iKPrime;
    private final FieldTheta<Complex> t0;
    private final Complex scaling;

    ComplexParameter(Complex m) {
        super(m);
        Complex q = LegendreEllipticIntegral.nome(m);
        this.bigK = LegendreEllipticIntegral.bigK(m);
        this.iBigKPrime = LegendreEllipticIntegral.bigKPrime(m).multiplyPlusI();
        double inverse = 0.25 / (this.bigK.getRealPart() * this.iBigKPrime.getImaginaryPart() - this.bigK.getImaginaryPart() * this.iBigKPrime.getRealPart());
        this.rK = this.iBigKPrime.getImaginaryPart() * inverse;
        this.iK = this.iBigKPrime.getRealPart() * -inverse;
        this.rKPrime = this.bigK.getImaginaryPart() * -inverse;
        this.iKPrime = this.bigK.getRealPart() * inverse;
        this.jacobiTheta = new FieldJacobiTheta<Complex>(q);
        this.t0 = this.jacobiTheta.values(m.getField().getZero());
        this.scaling = this.bigK.reciprocal().multiply(1.5707963267948966);
    }

    @Override
    public FieldCopolarN<Complex> valuesN(Complex u) {
        double cK = this.rK * u.getRealPart() + this.iK * u.getImaginaryPart();
        double cKPrime = this.rKPrime * u.getRealPart() + this.iKPrime * u.getImaginaryPart();
        Complex reducedU = u.linearCombination(1.0, u, -4.0 * FastMath.rint(cK), this.bigK, -4.0 * FastMath.rint(cKPrime), this.iBigKPrime);
        FieldTheta<Complex> tZ = this.jacobiTheta.values(reducedU.multiply(this.scaling));
        Complex sn = this.t0.theta3().multiply(tZ.theta1()).divide(this.t0.theta2().multiply(tZ.theta4()));
        Complex cn = this.t0.theta4().multiply(tZ.theta2()).divide(this.t0.theta2().multiply(tZ.theta4()));
        Complex dn = this.t0.theta4().multiply(tZ.theta3()).divide(this.t0.theta3().multiply(tZ.theta4()));
        return new FieldCopolarN<Complex>(sn, cn, dn);
    }
}

