/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.carlson;

import org.hipparchus.special.elliptic.carlson.RealDuplication;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

class RfRealDuplication
extends RealDuplication {
    static final int AGM_MAX = 32;
    static final double CONSTANT = 240240.0;
    static final double E2 = -24024.0;
    static final double E3 = 17160.0;
    static final double E2_E2 = 10010.0;
    static final double E2_E3 = -16380.0;
    static final double E3_E3 = 6930.0;
    static final double E2_E2_E2 = -5775.0;
    static final double DENOMINATOR = 240240.0;

    RfRealDuplication(double x, double y, double z) {
        super(x, y, z);
    }

    @Override
    protected void initialMeanPoint(double[] va) {
        va[3] = (va[0] + va[1] + va[2]) / 3.0;
    }

    @Override
    protected double convergenceCriterion(double r, double max) {
        return max / FastMath.sqrt(FastMath.sqrt(FastMath.sqrt(r * 3.0)));
    }

    @Override
    protected void update(int m, double[] vaM, double[] sqrtM, double fourM) {
        double lambdaA = sqrtM[0] * sqrtM[1];
        double lambdaB = sqrtM[0] * sqrtM[2];
        double lambdaC = sqrtM[1] * sqrtM[2];
        vaM[0] = MathArrays.linearCombination(0.25, vaM[0], 0.25, lambdaA, 0.25, lambdaB, 0.25, lambdaC);
        vaM[1] = MathArrays.linearCombination(0.25, vaM[1], 0.25, lambdaA, 0.25, lambdaB, 0.25, lambdaC);
        vaM[2] = MathArrays.linearCombination(0.25, vaM[2], 0.25, lambdaA, 0.25, lambdaB, 0.25, lambdaC);
        vaM[3] = MathArrays.linearCombination(0.25, vaM[3], 0.25, lambdaA, 0.25, lambdaB, 0.25, lambdaC);
    }

    @Override
    protected double evaluate(double[] va0, double aM, double fourM) {
        double inv = 1.0 / (aM * fourM);
        double bigX = (va0[3] - va0[0]) * inv;
        double bigY = (va0[3] - va0[1]) * inv;
        double bigZ = -(bigX + bigY);
        double e2 = bigX * bigY - bigZ * bigZ;
        double e3 = bigX * bigY * bigZ;
        double e2e2 = e2 * e2;
        double e2e3 = e2 * e3;
        double e3e3 = e3 * e3;
        double e2e2e2 = e2e2 * e2;
        double poly = (e2e2e2 * -5775.0 + e3e3 * 6930.0 + e2e3 * -16380.0 + e2e2 * 10010.0 + e3 * 17160.0 + e2 * -24024.0 + 240240.0) / 240240.0;
        return poly / FastMath.sqrt(aM);
    }

    @Override
    public double integral() {
        double x = this.getVi(0);
        double y = this.getVi(1);
        double z = this.getVi(2);
        if (x == 0.0) {
            return this.completeIntegral(y, z);
        }
        if (y == 0.0) {
            return this.completeIntegral(x, z);
        }
        if (z == 0.0) {
            return this.completeIntegral(x, y);
        }
        return super.integral();
    }

    private double completeIntegral(double x, double y) {
        double yM1;
        double xM1;
        double xM = FastMath.sqrt(x);
        double yM = FastMath.sqrt(y);
        for (int i = 1; i < 32 && !(FastMath.abs((xM = ((xM1 = xM) + (yM1 = yM)) * 0.5) - (yM = FastMath.sqrt(xM1 * yM1))) <= 4.0 * FastMath.ulp(xM)); ++i) {
        }
        return Math.PI / (xM + yM);
    }
}

