/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import org.hipparchus.analysis.function.Sqrt;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.AbstractRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.RealLinearOperator;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.MathArrays;

public class JacobiPreconditioner
implements RealLinearOperator {
    private final ArrayRealVector diag;

    public JacobiPreconditioner(double[] diag, boolean deep) {
        this.diag = new ArrayRealVector(diag, deep);
    }

    public static JacobiPreconditioner create(RealLinearOperator a) throws MathIllegalArgumentException {
        int n = a.getColumnDimension();
        if (a.getRowDimension() != n) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_OPERATOR, a.getRowDimension(), n);
        }
        double[] diag = new double[n];
        if (a instanceof AbstractRealMatrix) {
            AbstractRealMatrix m = (AbstractRealMatrix)a;
            for (int i = 0; i < n; ++i) {
                diag[i] = m.getEntry(i, i);
            }
        } else {
            ArrayRealVector x = new ArrayRealVector(n);
            for (int i = 0; i < n; ++i) {
                x.set(0.0);
                x.setEntry(i, 1.0);
                diag[i] = a.operate(x).getEntry(i);
            }
        }
        return new JacobiPreconditioner(diag, false);
    }

    @Override
    public int getColumnDimension() {
        return this.diag.getDimension();
    }

    @Override
    public int getRowDimension() {
        return this.diag.getDimension();
    }

    @Override
    public RealVector operate(RealVector x) {
        return new ArrayRealVector(MathArrays.ebeDivide(x.toArray(), this.diag.toArray()), false);
    }

    public RealLinearOperator sqrt() {
        final ArrayRealVector sqrtDiag = this.diag.map(new Sqrt());
        return new RealLinearOperator(){

            @Override
            public RealVector operate(RealVector x) {
                return new ArrayRealVector(MathArrays.ebeDivide(x.toArray(), sqrtDiag.toArray()), false);
            }

            @Override
            public int getRowDimension() {
                return sqrtDiag.getDimension();
            }

            @Override
            public int getColumnDimension() {
                return sqrtDiag.getDimension();
            }
        };
    }
}

