/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import org.hipparchus.linear.CholeskyDecomposition;
import org.hipparchus.linear.DecompositionSolver;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.RealMatrix;

public class CholeskyDecomposer
implements MatrixDecomposer {
    private final double relativeSymmetryThreshold;
    private final double absolutePositivityThreshold;

    public CholeskyDecomposer(double relativeSymmetryThreshold, double absolutePositivityThreshold) {
        this.relativeSymmetryThreshold = relativeSymmetryThreshold;
        this.absolutePositivityThreshold = absolutePositivityThreshold;
    }

    @Override
    public DecompositionSolver decompose(RealMatrix a) {
        return new CholeskyDecomposition(a, this.relativeSymmetryThreshold, this.absolutePositivityThreshold).getSolver();
    }
}

