/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class LaplaceDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20141003L;
    private final double mu;
    private final double beta;

    public LaplaceDistribution(double mu, double beta) throws MathIllegalArgumentException {
        if (beta <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NOT_POSITIVE_SCALE, beta);
        }
        this.mu = mu;
        this.beta = beta;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getScale() {
        return this.beta;
    }

    @Override
    public double density(double x) {
        return FastMath.exp(-FastMath.abs(x - this.mu) / this.beta) / (2.0 * this.beta);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= this.mu) {
            return FastMath.exp((x - this.mu) / this.beta) / 2.0;
        }
        return 1.0 - FastMath.exp((this.mu - x) / this.beta) / 2.0;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws MathIllegalArgumentException {
        MathUtils.checkRangeInclusive(p, 0.0, 1.0);
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double x = p > 0.5 ? -Math.log(2.0 - 2.0 * p) : Math.log(2.0 * p);
        return this.mu + this.beta * x;
    }

    @Override
    public double getNumericalMean() {
        return this.mu;
    }

    @Override
    public double getNumericalVariance() {
        return 2.0 * this.beta * this.beta;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

