/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class GumbelDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20141003L;
    private static final double EULER = 0.5778636748954609;
    private final double mu;
    private final double beta;

    public GumbelDistribution(double mu, double beta) throws MathIllegalArgumentException {
        if (beta <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SCALE, beta);
        }
        this.beta = beta;
        this.mu = mu;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getScale() {
        return this.beta;
    }

    @Override
    public double density(double x) {
        double z = (x - this.mu) / this.beta;
        double t = FastMath.exp(-z);
        return FastMath.exp(-z - t) / this.beta;
    }

    @Override
    public double cumulativeProbability(double x) {
        double z = (x - this.mu) / this.beta;
        return FastMath.exp(-FastMath.exp(-z));
    }

    @Override
    public double inverseCumulativeProbability(double p) throws MathIllegalArgumentException {
        MathUtils.checkRangeInclusive(p, 0.0, 1.0);
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mu - FastMath.log(-FastMath.log(p)) * this.beta;
    }

    @Override
    public double getNumericalMean() {
        return this.mu + 0.5778636748954609 * this.beta;
    }

    @Override
    public double getNumericalVariance() {
        return 1.6449340668482264 * (this.beta * this.beta);
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

