/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.complex;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.complex.FieldComplex;

public class FieldComplexField<T extends CalculusFieldElement<T>>
implements Field<FieldComplex<T>> {
    private static final Map<Field<?>, FieldComplexField<?>> CACHE = new HashMap();
    private final FieldComplex<T> zero;
    private final FieldComplex<T> one;

    private FieldComplexField(Field<T> field) {
        this.zero = FieldComplex.getZero(field);
        this.one = FieldComplex.getOne(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends CalculusFieldElement<T>> FieldComplexField<T> getField(Field<T> partsField) {
        FieldComplexField<Object> cachedField;
        Map<Field<?>, FieldComplexField<?>> map = CACHE;
        synchronized (map) {
            cachedField = CACHE.get(partsField);
            if (cachedField == null) {
                cachedField = new FieldComplexField<T>(partsField);
                CACHE.put(partsField, cachedField);
            }
        }
        FieldComplexField<?> tCached = cachedField;
        return tCached;
    }

    @Override
    public FieldComplex<T> getOne() {
        return this.one;
    }

    @Override
    public FieldComplex<T> getZero() {
        return this.zero;
    }

    @Override
    public Class<FieldComplex<T>> getRuntimeClass() {
        return this.getZero().getClass();
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return -748097016;
    }
}

