/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import org.hipparchus.analysis.integration.gauss.AbstractRuleFactory;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.Pair;

public class LegendreRuleFactory
extends AbstractRuleFactory {
    @Override
    protected Pair<double[], double[]> computeRule(int numberOfPoints) throws MathIllegalArgumentException {
        if (numberOfPoints == 1) {
            return new Pair<double[], double[]>(new double[]{0.0}, new double[]{2.0});
        }
        Legendre p = new Legendre(numberOfPoints);
        double[] points = this.findRoots(numberOfPoints, p::ratio);
        this.enforceSymmetry(points);
        double[] weights = new double[numberOfPoints];
        for (int i = 0; i <= numberOfPoints / 2; ++i) {
            double c = points[i];
            double[] pKpKm1 = p.pNpNm1(c);
            double d = (double)numberOfPoints * (pKpKm1[1] - c * pKpKm1[0]);
            weights[i] = 2.0 * (1.0 - c * c) / (d * d);
            int idx = numberOfPoints - i - 1;
            weights[idx] = weights[i];
        }
        return new Pair<double[], double[]>(points, weights);
    }

    private static class Legendre {
        private int degree;

        Legendre(int degree) {
            this.degree = degree;
        }

        public double ratio(double x) {
            double pm = 1.0;
            double p = x;
            double d = 1.0;
            for (int n = 1; n < this.degree; ++n) {
                double pp = (p * (x * (double)(2 * n + 1)) - pm * (double)n) / (double)(n + 1);
                d = p * (double)(n + 1) + d * x;
                pm = p;
                p = pp;
            }
            return p / d;
        }

        private double[] pNpNm1(double x) {
            double[] p = new double[]{x, 1.0};
            for (int n = 1; n < this.degree; ++n) {
                double pp = (p[0] * (x * (double)(2 * n + 1)) - p[1] * (double)n) / (double)(n + 1);
                p[1] = p[0];
                p[0] = pp;
            }
            return p;
        }
    }
}

