/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Pair;

public class GaussIntegrator {
    private final double[] points;
    private final double[] weights;

    public GaussIntegrator(double[] points, double[] weights) throws MathIllegalArgumentException {
        MathArrays.checkEqualLength(points, weights);
        MathArrays.checkOrder(points, MathArrays.OrderDirection.INCREASING, true, true);
        this.points = (double[])points.clone();
        this.weights = (double[])weights.clone();
    }

    public GaussIntegrator(Pair<double[], double[]> pointsAndWeights) throws MathIllegalArgumentException {
        this(pointsAndWeights.getFirst(), pointsAndWeights.getSecond());
    }

    public double integrate(UnivariateFunction f) {
        double s = 0.0;
        double c = 0.0;
        for (int i = 0; i < this.points.length; ++i) {
            double x = this.points[i];
            double w = this.weights[i];
            double y = w * f.value(x) - c;
            double t = s + y;
            c = t - s - y;
            s = t;
        }
        return s;
    }

    public int getNumberOfPoints() {
        return this.points.length;
    }

    public double getPoint(int index) {
        return this.points[index];
    }

    public double getWeight(int index) {
        return this.weights[index];
    }
}

