/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.integration.BaseAbstractFieldUnivariateIntegrator;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.FastMath;

public class FieldMidPointIntegrator<T extends CalculusFieldElement<T>>
extends BaseAbstractFieldUnivariateIntegrator<T> {
    public static final int MIDPOINT_MAX_ITERATIONS_COUNT = 64;

    public FieldMidPointIntegrator(Field<T> field, double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        super(field, relativeAccuracy, absoluteAccuracy, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 64) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, maximalIterationCount, 64);
        }
    }

    public FieldMidPointIntegrator(Field<T> field, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        super(field, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 64) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, maximalIterationCount, 64);
        }
    }

    public FieldMidPointIntegrator(Field<T> field) {
        super(field, 3, 64);
    }

    private T stage(int n, T previousStageResult, T min, T diffMaxMin) throws MathIllegalStateException {
        long np = 1L << n - 1;
        CalculusFieldElement sum = (CalculusFieldElement)this.getField().getZero();
        CalculusFieldElement spacing = (CalculusFieldElement)diffMaxMin.divide(np);
        CalculusFieldElement x = (CalculusFieldElement)min.add(spacing.multiply(0.5));
        for (long i = 0L; i < np; ++i) {
            sum = sum.add(this.computeObjectiveValue(x));
            x = x.add(spacing);
        }
        return (T)((CalculusFieldElement)previousStageResult.add((CalculusFieldElement)sum.multiply(spacing)).multiply(0.5));
    }

    @Override
    protected T doIntegrate() throws MathIllegalArgumentException, MathIllegalStateException {
        Object min = this.getMin();
        CalculusFieldElement diff = (CalculusFieldElement)this.getMax().subtract(min);
        CalculusFieldElement midPoint = (CalculusFieldElement)min.add(diff.multiply(0.5));
        CalculusFieldElement oldt = diff.multiply(this.computeObjectiveValue(midPoint));
        while (true) {
            double rLimit;
            double delta;
            this.iterations.increment();
            int i = this.iterations.getCount();
            CalculusFieldElement t = this.stage(i, oldt, min, diff);
            if (i >= this.getMinimalIterationCount() && ((delta = FastMath.abs(t.subtract(oldt)).getReal()) <= (rLimit = ((CalculusFieldElement)FastMath.abs(oldt).add(FastMath.abs(t)).multiply(0.5 * this.getRelativeAccuracy())).getReal()) || delta <= this.getAbsoluteAccuracy())) {
                return (T)t;
            }
            oldt = t;
        }
    }
}

