/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere.data;

import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.AbstractSelfFeedingLoader;
import org.orekit.data.DataContext;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.atmosphere.DTM2000InputParameters;
import org.orekit.models.earth.atmosphere.NRLMSISE00InputParameters;
import org.orekit.models.earth.atmosphere.data.CssiSpaceWeatherDataLoader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;
import org.orekit.utils.ImmutableTimeStampedCache;

public class CssiSpaceWeatherData
extends AbstractSelfFeedingLoader
implements DTM2000InputParameters,
NRLMSISE00InputParameters {
    public static final String DEFAULT_SUPPORTED_NAMES = "^S(?:pace)?W(?:eather)?-(?:All)?.*\\.txt$";
    private static final long serialVersionUID = 4249411710645968978L;
    private static final int N_NEIGHBORS = 2;
    private final transient ImmutableTimeStampedCache<TimeStamped> data;
    private final TimeScale utc;
    private final AbsoluteDate firstDate;
    private final AbsoluteDate lastObservedDate;
    private final AbsoluteDate lastDailyPredictedDate;
    private final AbsoluteDate lastDate;
    private CssiSpaceWeatherDataLoader.LineParameters previousParam;
    private CssiSpaceWeatherDataLoader.LineParameters nextParam;

    @DefaultDataContext
    public CssiSpaceWeatherData(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales().getUTC());
    }

    public CssiSpaceWeatherData(String supportedNames, DataProvidersManager dataProvidersManager, TimeScale utc) {
        super(supportedNames, dataProvidersManager);
        this.utc = utc;
        CssiSpaceWeatherDataLoader loader = new CssiSpaceWeatherDataLoader(utc);
        this.feed(loader);
        this.data = new ImmutableTimeStampedCache<TimeStamped>(2, loader.getDataSet());
        this.firstDate = loader.getMinDate();
        this.lastDate = loader.getMaxDate();
        this.lastObservedDate = loader.getLastObservedDate();
        this.lastDailyPredictedDate = loader.getLastDailyPredictedDate();
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.firstDate;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.lastDate;
    }

    private void bracketDate(AbsoluteDate date) {
        if (date.durationFrom(this.firstDate) < 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE_BEFORE, date, this.firstDate, this.lastDate, this.firstDate.durationFrom(date));
        }
        if (date.durationFrom(this.lastDate) > 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE_AFTER, date, this.firstDate, this.lastDate, date.durationFrom(this.lastDate));
        }
        if (this.previousParam != null && date.durationFrom(this.previousParam.getDate()) > 0.0 && date.durationFrom(this.nextParam.getDate()) <= 0.0) {
            return;
        }
        List neigbors = this.data.getNeighbors(date).collect(Collectors.toList());
        this.previousParam = (CssiSpaceWeatherDataLoader.LineParameters)neigbors.get(0);
        this.nextParam = (CssiSpaceWeatherDataLoader.LineParameters)neigbors.get(1);
        if (this.previousParam.getDate().compareTo(date) > 0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE, date, this.firstDate, this.lastDate);
        }
    }

    private double getLinearInterpolation(AbsoluteDate date, double previousValue, double nextValue) {
        AbsoluteDate previousDate = this.previousParam.getDate();
        AbsoluteDate currentDate = this.nextParam.getDate();
        double dt = currentDate.durationFrom(previousDate);
        double previousWeight = currentDate.durationFrom(date) / dt;
        double nextWeight = date.durationFrom(previousDate) / dt;
        return previousValue * previousWeight + nextValue * nextWeight;
    }

    @Override
    public double getInstantFlux(AbsoluteDate date) {
        this.bracketDate(date);
        return this.getLinearInterpolation(date, this.previousParam.getF107Obs(), this.nextParam.getF107Obs());
    }

    @Override
    public double getMeanFlux(AbsoluteDate date) {
        return this.getAverageFlux(date);
    }

    @Override
    public double getThreeHourlyKP(AbsoluteDate date) {
        if (date.compareTo(this.lastObservedDate) <= 0) {
            this.bracketDate(date);
            double hourOfDay = date.offsetFrom(this.previousParam.getDate(), this.utc) / 3600.0;
            int i_kp = (int)(hourOfDay / 3.0);
            if (i_kp >= 8) {
                i_kp = 7;
            }
            return this.previousParam.getThreeHourlyKp(i_kp);
        }
        return this.get24HoursKp(date);
    }

    @Override
    public double get24HoursKp(AbsoluteDate date) {
        if (date.compareTo(this.lastDailyPredictedDate) <= 0) {
            this.bracketDate(date);
            return this.previousParam.getKpSum() / 8.0;
        }
        this.bracketDate(date);
        return this.getLinearInterpolation(date, this.previousParam.getKpSum() / 8.0, this.nextParam.getKpSum() / 8.0);
    }

    @Override
    public double getDailyFlux(AbsoluteDate date) {
        return this.getDailyFluxOnDay(date.shiftedBy(-86400.0));
    }

    private double getDailyFluxOnDay(AbsoluteDate date) {
        if (date.compareTo(this.lastDailyPredictedDate) <= 0) {
            this.bracketDate(date);
            return this.previousParam.getF107Obs();
        }
        this.bracketDate(date);
        return this.getLinearInterpolation(date, this.previousParam.getF107Obs(), this.nextParam.getF107Obs());
    }

    @Override
    public double getAverageFlux(AbsoluteDate date) {
        if (date.compareTo(this.lastDailyPredictedDate) <= 0) {
            this.bracketDate(date);
            return this.previousParam.getCtr81Obs();
        }
        this.bracketDate(date);
        return this.getLinearInterpolation(date, this.previousParam.getCtr81Obs(), this.nextParam.getCtr81Obs());
    }

    @Override
    public double[] getAp(AbsoluteDate date) {
        double[] apArray = new double[]{this.getDailyAp(date), this.getThreeHourlyAp(date), this.getThreeHourlyAp(date.shiftedBy(-10800.0)), this.getThreeHourlyAp(date.shiftedBy(-21600.0)), this.getThreeHourlyAp(date.shiftedBy(-32400.0)), this.get24HoursAverageAp(date.shiftedBy(-43200.0)), this.get24HoursAverageAp(date.shiftedBy(-129600.0))};
        return apArray;
    }

    private double getThreeHourlyAp(AbsoluteDate date) {
        if (date.compareTo(this.lastObservedDate.shiftedBy(86400.0)) < 0) {
            this.bracketDate(date);
            double hourOfDay = date.offsetFrom(this.previousParam.getDate(), this.utc) / 3600.0;
            int i_ap = (int)(hourOfDay / 3.0);
            if (i_ap >= 8) {
                i_ap = 7;
            }
            return this.previousParam.getThreeHourlyAp(i_ap);
        }
        return this.getDailyAp(date);
    }

    private double get24HoursAverageAp(AbsoluteDate date) {
        if (date.compareTo(this.lastDailyPredictedDate) <= 0) {
            double apSum = 0.0;
            for (int i = 0; i < 8; ++i) {
                apSum += this.getThreeHourlyAp(date.shiftedBy(-10800.0 * (double)i));
            }
            return apSum / 8.0;
        }
        return this.getDailyAp(date);
    }

    private double getDailyAp(AbsoluteDate date) {
        if (date.compareTo(this.lastDailyPredictedDate) <= 0) {
            this.bracketDate(date);
            return this.previousParam.getApAvg();
        }
        this.bracketDate(date);
        return this.getLinearInterpolation(date, this.previousParam.getApAvg(), this.nextParam.getApAvg());
    }

    @Override
    public String getSupportedNames() {
        return super.getSupportedNames();
    }
}

