/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.integration.BaseAbstractFieldUnivariateIntegrator;
import org.hipparchus.analysis.integration.FieldTrapezoidIntegrator;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class FieldRombergIntegrator<T extends CalculusFieldElement<T>>
extends BaseAbstractFieldUnivariateIntegrator<T> {
    public static final int ROMBERG_MAX_ITERATIONS_COUNT = 32;

    public FieldRombergIntegrator(Field<T> field, double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        super(field, relativeAccuracy, absoluteAccuracy, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 32) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, maximalIterationCount, 32);
        }
    }

    public FieldRombergIntegrator(Field<T> field, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        super(field, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 32) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, maximalIterationCount, 32);
        }
    }

    public FieldRombergIntegrator(Field<T> field) {
        super(field, 3, 32);
    }

    @Override
    protected T doIntegrate() throws MathIllegalStateException {
        int m = this.iterations.getMaximalCount() + 1;
        CalculusFieldElement[] previousRow = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)m);
        CalculusFieldElement[] currentRow = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)m);
        FieldTrapezoidIntegrator qtrap = new FieldTrapezoidIntegrator(this.getField());
        currentRow[0] = qtrap.stage(this, 0);
        this.iterations.increment();
        CalculusFieldElement olds = currentRow[0];
        while (true) {
            double rLimit;
            double delta;
            int i = this.iterations.getCount();
            CalculusFieldElement[] tmpRow = previousRow;
            previousRow = currentRow;
            currentRow = tmpRow;
            currentRow[0] = qtrap.stage(this, i);
            this.iterations.increment();
            for (int j = 1; j <= i; ++j) {
                double r = (1L << 2 * j) - 1L;
                CalculusFieldElement tIJm1 = currentRow[j - 1];
                currentRow[j] = (CalculusFieldElement)tIJm1.add(tIJm1.subtract(previousRow[j - 1]).divide(r));
            }
            CalculusFieldElement s = currentRow[i];
            if (i >= this.getMinimalIterationCount() && ((delta = FastMath.abs(s.subtract(olds)).getReal()) <= (rLimit = ((CalculusFieldElement)FastMath.abs(olds).add(FastMath.abs(s)).multiply(0.5 * this.getRelativeAccuracy())).getReal()) || delta <= this.getAbsoluteAccuracy())) {
                return (T)s;
            }
            olds = s;
        }
    }
}

