/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.complex.Complex;
import org.hipparchus.special.elliptic.jacobi.Theta;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.Precision;

public class JacobiTheta {
    private static final int N_MAX = 100;
    private final double q;
    private final double qSquare;
    private final double qFourth;

    public JacobiTheta(double q) {
        this.q = q;
        this.qSquare = q * q;
        this.qFourth = FastMath.sqrt(FastMath.sqrt(q));
    }

    public double getQ() {
        return this.q;
    }

    public Theta values(Complex z) {
        FieldSinCos<Complex> sc1 = FastMath.sinCos(z);
        double sgn = 1.0;
        double qNN = 1.0;
        double qTwoN = 1.0;
        double qNNp1 = 1.0;
        FieldSinCos<Complex> sc2n1 = sc1;
        Complex sum1 = sc1.sin();
        Complex sum2 = sc1.cos();
        Complex sum3 = Complex.ZERO;
        Complex sum4 = Complex.ZERO;
        for (int n = 1; n < 100; ++n) {
            sgn = -sgn;
            qNN = qNN * qTwoN * this.q;
            sc2n1 = FieldSinCos.sum(sc2n1, sc1);
            sum3 = sum3.add(sc2n1.cos().multiply(qNN));
            sum4 = sum4.add(sc2n1.cos().multiply(sgn * qNN));
            sc2n1 = FieldSinCos.sum(sc2n1, sc1);
            sum1 = sum1.add(sc2n1.sin().multiply(sgn * (qNNp1 *= (qTwoN *= this.qSquare))));
            sum2 = sum2.add(sc2n1.cos().multiply(qNNp1));
            if (FastMath.abs(qNNp1) <= Precision.EPSILON) break;
        }
        return new Theta(sum1.multiply(2.0 * this.qFourth), sum2.multiply(2.0 * this.qFourth), sum3.multiply(2).add(1.0), sum4.multiply(2).add(1.0));
    }
}

