/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.analytical.KeplerianPropagator;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;

public class KeplerianPropagatorBuilder
extends AbstractPropagatorBuilder {
    public KeplerianPropagatorBuilder(Orbit templateOrbit, PositionAngle positionAngle, double positionScale) {
        this(templateOrbit, positionAngle, positionScale, InertialProvider.of(templateOrbit.getFrame()));
    }

    public KeplerianPropagatorBuilder(Orbit templateOrbit, PositionAngle positionAngle, double positionScale, AttitudeProvider attitudeProvider) {
        super(templateOrbit, positionAngle, positionScale, true, attitudeProvider);
    }

    @Override
    public Propagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        return new KeplerianPropagator(this.createInitialOrbit(), this.getAttitudeProvider());
    }
}

