/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.SphericalCoordinates;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.forces.AbstractForceModel;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.TideSystemProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class HolmesFeatherstoneAttractionModel
extends AbstractForceModel
implements TideSystemProvider {
    private static final int SCALING = 930;
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private final ParameterDriver gmParameterDriver;
    private final NormalizedSphericalHarmonicsProvider provider;
    private final Frame bodyFrame;
    private final double[] gnmOj;
    private final double[] hnmOj;
    private final double[] enm;
    private final double[] sectorial;

    public HolmesFeatherstoneAttractionModel(Frame centralBodyFrame, NormalizedSphericalHarmonicsProvider provider) {
        int m;
        this.gmParameterDriver = new ParameterDriver("central attraction coefficient", provider.getMu(), MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
        this.provider = provider;
        this.bodyFrame = centralBodyFrame;
        int degree = provider.getMaxDegree();
        int size = FastMath.max((int)0, (int)(degree * (degree + 1) / 2 - 1));
        this.gnmOj = new double[size];
        this.hnmOj = new double[size];
        this.enm = new double[size];
        int index = 0;
        for (m = degree; m >= 0; --m) {
            int j = m == 0 ? 2 : 1;
            for (int n = FastMath.max((int)2, (int)(m + 1)); n <= degree; ++n) {
                double f = (n - m) * (n + m + 1);
                this.gnmOj[index] = (double)(2 * (m + 1)) / FastMath.sqrt((double)((double)j * f));
                this.hnmOj[index] = FastMath.sqrt((double)((double)((n + m + 2) * (n - m - 1)) / ((double)j * f)));
                this.enm[index] = FastMath.sqrt((double)(f / (double)j));
                ++index;
            }
        }
        this.sectorial = new double[degree + 1];
        this.sectorial[0] = FastMath.scalb((double)1.0, (int)-930);
        this.sectorial[1] = FastMath.sqrt((double)3.0) * this.sectorial[0];
        for (m = 2; m < this.sectorial.length; ++m) {
            this.sectorial[m] = FastMath.sqrt((double)((double)(2 * m + 1) / (2.0 * (double)m))) * this.sectorial[m - 1];
        }
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return true;
    }

    @Override
    public TideSystem getTideSystem() {
        return this.provider.getTideSystem();
    }

    public double getMu() {
        return this.gmParameterDriver.getValue();
    }

    public double value(AbsoluteDate date, Vector3D position, double mu) {
        return mu / position.getNorm() + this.nonCentralPart(date, position, mu);
    }

    public double nonCentralPart(AbsoluteDate date, Vector3D position, double mu) {
        int degree = this.provider.getMaxDegree();
        int order = this.provider.getMaxOrder();
        NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        double[] pnm0Plus2 = new double[degree + 1];
        double[] pnm0Plus1 = new double[degree + 1];
        double[] pnm0 = new double[degree + 1];
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        double x2 = x * x;
        double y2 = y * y;
        double z2 = z * z;
        double r2 = x2 + y2 + z2;
        double r = FastMath.sqrt((double)r2);
        double rho = FastMath.sqrt((double)(x2 + y2));
        double t = z / r;
        double u = rho / r;
        double tOu = z / rho;
        double[] aOrN = this.createDistancePowersArray(this.provider.getAe() / r);
        double[][] cosSinLambda = this.createCosSinArrays(position.getX() / rho, position.getY() / rho);
        int index = 0;
        double value = 0.0;
        for (int m = degree; m >= 0; --m) {
            index = this.computeTesseral(m, degree, index, t, u, tOu, pnm0Plus2, pnm0Plus1, null, pnm0, null, null);
            if (m <= order) {
                double sumDegreeS = 0.0;
                double sumDegreeC = 0.0;
                for (int n = FastMath.max((int)2, (int)m); n <= degree; ++n) {
                    sumDegreeS += pnm0[n] * aOrN[n] * harmonics.getNormalizedSnm(n, m);
                    sumDegreeC += pnm0[n] * aOrN[n] * harmonics.getNormalizedCnm(n, m);
                }
                value = value * u + cosSinLambda[1][m] * sumDegreeS + cosSinLambda[0][m] * sumDegreeC;
            }
            double[] tmp = pnm0Plus2;
            pnm0Plus2 = pnm0Plus1;
            pnm0Plus1 = pnm0;
            pnm0 = tmp;
        }
        value = FastMath.scalb((double)value, (int)930);
        return mu * value / r;
    }

    public double[] gradient(AbsoluteDate date, Vector3D position, double mu) {
        int degree = this.provider.getMaxDegree();
        int order = this.provider.getMaxOrder();
        NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        double[] pnm0Plus2 = new double[degree + 1];
        double[] pnm0Plus1 = new double[degree + 1];
        double[] pnm0 = new double[degree + 1];
        double[] pnm1 = new double[degree + 1];
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        double x2 = x * x;
        double y2 = y * y;
        double z2 = z * z;
        double r2 = x2 + y2 + z2;
        double r = FastMath.sqrt((double)r2);
        double rho2 = x2 + y2;
        double rho = FastMath.sqrt((double)rho2);
        double t = z / r;
        double u = rho / r;
        double tOu = z / rho;
        double[] aOrN = this.createDistancePowersArray(this.provider.getAe() / r);
        double[][] cosSinLambda = this.createCosSinArrays(position.getX() / rho, position.getY() / rho);
        int index = 0;
        double value = 0.0;
        double[] gradient = new double[3];
        for (int m = degree; m >= 0; --m) {
            index = this.computeTesseral(m, degree, index, t, u, tOu, pnm0Plus2, pnm0Plus1, null, pnm0, pnm1, null);
            if (m <= order) {
                double sumDegreeS = 0.0;
                double sumDegreeC = 0.0;
                double dSumDegreeSdR = 0.0;
                double dSumDegreeCdR = 0.0;
                double dSumDegreeSdTheta = 0.0;
                double dSumDegreeCdTheta = 0.0;
                for (int n = FastMath.max((int)2, (int)m); n <= degree; ++n) {
                    double qSnm = aOrN[n] * harmonics.getNormalizedSnm(n, m);
                    double qCnm = aOrN[n] * harmonics.getNormalizedCnm(n, m);
                    double nOr = (double)n / r;
                    double s0 = pnm0[n] * qSnm;
                    double c0 = pnm0[n] * qCnm;
                    double s1 = pnm1[n] * qSnm;
                    double c1 = pnm1[n] * qCnm;
                    sumDegreeS += s0;
                    sumDegreeC += c0;
                    dSumDegreeSdR -= nOr * s0;
                    dSumDegreeCdR -= nOr * c0;
                    dSumDegreeSdTheta += s1;
                    dSumDegreeCdTheta += c1;
                }
                double sML = cosSinLambda[1][m];
                double cML = cosSinLambda[0][m];
                value = value * u + sML * sumDegreeS + cML * sumDegreeC;
                gradient[0] = gradient[0] * u + sML * dSumDegreeSdR + cML * dSumDegreeCdR;
                gradient[1] = gradient[1] * u + (double)m * (cML * sumDegreeS - sML * sumDegreeC);
                gradient[2] = gradient[2] * u + sML * dSumDegreeSdTheta + cML * dSumDegreeCdTheta;
            }
            double[] tmp = pnm0Plus2;
            pnm0Plus2 = pnm0Plus1;
            pnm0Plus1 = pnm0;
            pnm0 = tmp;
        }
        value = FastMath.scalb((double)value, (int)930);
        gradient[0] = FastMath.scalb((double)gradient[0], (int)930);
        gradient[1] = FastMath.scalb((double)gradient[1], (int)930);
        gradient[2] = FastMath.scalb((double)gradient[2], (int)930);
        double muOr = mu / r;
        gradient[0] = muOr * gradient[0] - (value *= muOr) / r;
        gradient[1] = gradient[1] * muOr;
        gradient[2] = gradient[2] * muOr;
        return new SphericalCoordinates(position).toCartesianGradient(gradient);
    }

    public <T extends CalculusFieldElement<T>> T[] gradient(FieldAbsoluteDate<T> date, FieldVector3D<T> position, T mu) {
        int degree = this.provider.getMaxDegree();
        int order = this.provider.getMaxOrder();
        NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics harmonics = this.provider.onDate(date.toAbsoluteDate());
        CalculusFieldElement zero = (CalculusFieldElement)date.getField().getZero();
        CalculusFieldElement[] pnm0Plus2 = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)(degree + 1));
        CalculusFieldElement[] pnm0Plus1 = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)(degree + 1));
        CalculusFieldElement[] pnm0 = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)(degree + 1));
        CalculusFieldElement[] pnm1 = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)(degree + 1));
        CalculusFieldElement x = position.getX();
        CalculusFieldElement y = position.getY();
        CalculusFieldElement z = position.getZ();
        CalculusFieldElement x2 = (CalculusFieldElement)x.multiply((FieldElement)x);
        CalculusFieldElement y2 = (CalculusFieldElement)y.multiply((FieldElement)y);
        CalculusFieldElement z2 = (CalculusFieldElement)z.multiply((FieldElement)z);
        CalculusFieldElement r2 = (CalculusFieldElement)((CalculusFieldElement)x2.add((FieldElement)y2)).add((FieldElement)z2);
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement rho2 = (CalculusFieldElement)x2.add((FieldElement)y2);
        CalculusFieldElement rho = (CalculusFieldElement)rho2.sqrt();
        CalculusFieldElement t = (CalculusFieldElement)z.divide((FieldElement)r);
        CalculusFieldElement u = (CalculusFieldElement)rho.divide((FieldElement)r);
        CalculusFieldElement tOu = (CalculusFieldElement)z.divide((FieldElement)rho);
        CalculusFieldElement[] aOrN = this.createDistancePowersArray((CalculusFieldElement)((CalculusFieldElement)r.reciprocal()).multiply(this.provider.getAe()));
        CalculusFieldElement[][] cosSinLambda = this.createCosSinArrays((CalculusFieldElement)((CalculusFieldElement)rho.reciprocal()).multiply((FieldElement)position.getX()), (CalculusFieldElement)((CalculusFieldElement)rho.reciprocal()).multiply((FieldElement)position.getY()));
        int index = 0;
        CalculusFieldElement value = zero;
        CalculusFieldElement[] gradient = (CalculusFieldElement[])MathArrays.buildArray((Field)zero.getField(), (int)3);
        for (int m = degree; m >= 0; --m) {
            index = this.computeTesseral(m, degree, index, t, u, tOu, pnm0Plus2, pnm0Plus1, null, pnm0, pnm1, null);
            if (m <= order) {
                CalculusFieldElement sumDegreeS = zero;
                CalculusFieldElement sumDegreeC = zero;
                CalculusFieldElement dSumDegreeSdR = zero;
                CalculusFieldElement dSumDegreeCdR = zero;
                CalculusFieldElement dSumDegreeSdTheta = zero;
                CalculusFieldElement dSumDegreeCdTheta = zero;
                for (int n = FastMath.max((int)2, (int)m); n <= degree; ++n) {
                    CalculusFieldElement qSnm = (CalculusFieldElement)aOrN[n].multiply(harmonics.getNormalizedSnm(n, m));
                    CalculusFieldElement qCnm = (CalculusFieldElement)aOrN[n].multiply(harmonics.getNormalizedCnm(n, m));
                    CalculusFieldElement nOr = (CalculusFieldElement)((CalculusFieldElement)r.reciprocal()).multiply(n);
                    CalculusFieldElement s0 = (CalculusFieldElement)pnm0[n].multiply((FieldElement)qSnm);
                    CalculusFieldElement c0 = (CalculusFieldElement)pnm0[n].multiply((FieldElement)qCnm);
                    CalculusFieldElement s1 = (CalculusFieldElement)pnm1[n].multiply((FieldElement)qSnm);
                    CalculusFieldElement c1 = (CalculusFieldElement)pnm1[n].multiply((FieldElement)qCnm);
                    sumDegreeS = (CalculusFieldElement)sumDegreeS.add((FieldElement)s0);
                    sumDegreeC = (CalculusFieldElement)sumDegreeC.add((FieldElement)c0);
                    dSumDegreeSdR = (CalculusFieldElement)dSumDegreeSdR.subtract(nOr.multiply((FieldElement)s0));
                    dSumDegreeCdR = (CalculusFieldElement)dSumDegreeCdR.subtract(nOr.multiply((FieldElement)c0));
                    dSumDegreeSdTheta = (CalculusFieldElement)dSumDegreeSdTheta.add((FieldElement)s1);
                    dSumDegreeCdTheta = (CalculusFieldElement)dSumDegreeCdTheta.add((FieldElement)c1);
                }
                CalculusFieldElement sML = cosSinLambda[1][m];
                CalculusFieldElement cML = cosSinLambda[0][m];
                value = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)value.multiply((FieldElement)u)).add(sML.multiply((FieldElement)sumDegreeS))).add(cML.multiply((FieldElement)sumDegreeC));
                gradient[0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)gradient[0].multiply((FieldElement)u)).add(sML.multiply((FieldElement)dSumDegreeSdR))).add(cML.multiply((FieldElement)dSumDegreeCdR));
                gradient[1] = (CalculusFieldElement)((CalculusFieldElement)gradient[1].multiply((FieldElement)u)).add(((CalculusFieldElement)((CalculusFieldElement)cML.multiply((FieldElement)sumDegreeS)).subtract(sML.multiply((FieldElement)sumDegreeC))).multiply(m));
                gradient[2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)gradient[2].multiply((FieldElement)u)).add(sML.multiply((FieldElement)dSumDegreeSdTheta))).add(cML.multiply((FieldElement)dSumDegreeCdTheta));
            }
            CalculusFieldElement[] tmp = pnm0Plus2;
            pnm0Plus2 = pnm0Plus1;
            pnm0Plus1 = pnm0;
            pnm0 = tmp;
        }
        value = (CalculusFieldElement)value.scalb(930);
        gradient[0] = (CalculusFieldElement)gradient[0].scalb(930);
        gradient[1] = (CalculusFieldElement)gradient[1].scalb(930);
        gradient[2] = (CalculusFieldElement)gradient[2].scalb(930);
        CalculusFieldElement muOr = (CalculusFieldElement)((CalculusFieldElement)r.reciprocal()).multiply(mu);
        value = (CalculusFieldElement)value.multiply((FieldElement)muOr);
        gradient[0] = (CalculusFieldElement)((CalculusFieldElement)muOr.multiply((FieldElement)gradient[0])).subtract(value.divide((FieldElement)r));
        gradient[1] = (CalculusFieldElement)gradient[1].multiply((FieldElement)muOr);
        gradient[2] = (CalculusFieldElement)gradient[2].multiply((FieldElement)muOr);
        CalculusFieldElement rPos = position.getNorm();
        CalculusFieldElement xPos = position.getX();
        CalculusFieldElement yPos = position.getY();
        CalculusFieldElement zPos = position.getZ();
        CalculusFieldElement rho2Pos = (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)x)).add(y.multiply((FieldElement)y));
        CalculusFieldElement rhoPos = (CalculusFieldElement)rho2.sqrt();
        CalculusFieldElement r2Pos = (CalculusFieldElement)rho2.add(z.multiply((FieldElement)z));
        CalculusFieldElement[][] jacobianPos = (CalculusFieldElement[][])MathArrays.buildArray((Field)zero.getField(), (int)3, (int)3);
        jacobianPos[0][0] = (CalculusFieldElement)xPos.divide((FieldElement)rPos);
        jacobianPos[0][1] = (CalculusFieldElement)yPos.divide((FieldElement)rPos);
        jacobianPos[0][2] = (CalculusFieldElement)zPos.divide((FieldElement)rPos);
        jacobianPos[1][0] = (CalculusFieldElement)((CalculusFieldElement)yPos.negate()).divide((FieldElement)rho2Pos);
        jacobianPos[1][1] = (CalculusFieldElement)xPos.divide((FieldElement)rho2Pos);
        jacobianPos[2][0] = (CalculusFieldElement)((CalculusFieldElement)xPos.multiply((FieldElement)zPos)).divide(rhoPos.multiply((FieldElement)r2Pos));
        jacobianPos[2][1] = (CalculusFieldElement)((CalculusFieldElement)yPos.multiply((FieldElement)zPos)).divide(rhoPos.multiply((FieldElement)r2Pos));
        jacobianPos[2][2] = (CalculusFieldElement)((CalculusFieldElement)rhoPos.negate()).divide((FieldElement)r2Pos);
        CalculusFieldElement[] cartGradPos = (CalculusFieldElement[])MathArrays.buildArray((Field)zero.getField(), (int)3);
        cartGradPos[0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)gradient[0].multiply((FieldElement)jacobianPos[0][0])).add(gradient[1].multiply((FieldElement)jacobianPos[1][0]))).add(gradient[2].multiply((FieldElement)jacobianPos[2][0]));
        cartGradPos[1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)gradient[0].multiply((FieldElement)jacobianPos[0][1])).add(gradient[1].multiply((FieldElement)jacobianPos[1][1]))).add(gradient[2].multiply((FieldElement)jacobianPos[2][1]));
        cartGradPos[2] = (CalculusFieldElement)((CalculusFieldElement)gradient[0].multiply((FieldElement)jacobianPos[0][2])).add(gradient[2].multiply((FieldElement)jacobianPos[2][2]));
        return cartGradPos;
    }

    private GradientHessian gradientHessian(AbsoluteDate date, Vector3D position, double mu) {
        int degree = this.provider.getMaxDegree();
        int order = this.provider.getMaxOrder();
        NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        double[] pnm0Plus2 = new double[degree + 1];
        double[] pnm0Plus1 = new double[degree + 1];
        double[] pnm0 = new double[degree + 1];
        double[] pnm1Plus1 = new double[degree + 1];
        double[] pnm1 = new double[degree + 1];
        double[] pnm2 = new double[degree + 1];
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        double x2 = x * x;
        double y2 = y * y;
        double z2 = z * z;
        double r2 = x2 + y2 + z2;
        double r = FastMath.sqrt((double)r2);
        double rho2 = x2 + y2;
        double rho = FastMath.sqrt((double)rho2);
        double t = z / r;
        double u = rho / r;
        double tOu = z / rho;
        double[] aOrN = this.createDistancePowersArray(this.provider.getAe() / r);
        double[][] cosSinLambda = this.createCosSinArrays(position.getX() / rho, position.getY() / rho);
        int index = 0;
        double value = 0.0;
        double[] gradient = new double[3];
        double[][] hessian = new double[3][3];
        for (int m = degree; m >= 0; --m) {
            index = this.computeTesseral(m, degree, index, t, u, tOu, pnm0Plus2, pnm0Plus1, pnm1Plus1, pnm0, pnm1, pnm2);
            if (m <= order) {
                double sumDegreeS = 0.0;
                double sumDegreeC = 0.0;
                double dSumDegreeSdR = 0.0;
                double dSumDegreeCdR = 0.0;
                double dSumDegreeSdTheta = 0.0;
                double dSumDegreeCdTheta = 0.0;
                double d2SumDegreeSdRdR = 0.0;
                double d2SumDegreeSdRdTheta = 0.0;
                double d2SumDegreeSdThetadTheta = 0.0;
                double d2SumDegreeCdRdR = 0.0;
                double d2SumDegreeCdRdTheta = 0.0;
                double d2SumDegreeCdThetadTheta = 0.0;
                for (int n = FastMath.max((int)2, (int)m); n <= degree; ++n) {
                    double qSnm = aOrN[n] * harmonics.getNormalizedSnm(n, m);
                    double qCnm = aOrN[n] * harmonics.getNormalizedCnm(n, m);
                    double nOr = (double)n / r;
                    double nnP1Or2 = nOr * (double)(n + 1) / r;
                    double s0 = pnm0[n] * qSnm;
                    double c0 = pnm0[n] * qCnm;
                    double s1 = pnm1[n] * qSnm;
                    double c1 = pnm1[n] * qCnm;
                    double s2 = pnm2[n] * qSnm;
                    double c2 = pnm2[n] * qCnm;
                    sumDegreeS += s0;
                    sumDegreeC += c0;
                    dSumDegreeSdR -= nOr * s0;
                    dSumDegreeCdR -= nOr * c0;
                    dSumDegreeSdTheta += s1;
                    dSumDegreeCdTheta += c1;
                    d2SumDegreeSdRdR += nnP1Or2 * s0;
                    d2SumDegreeSdRdTheta -= nOr * s1;
                    d2SumDegreeSdThetadTheta += s2;
                    d2SumDegreeCdRdR += nnP1Or2 * c0;
                    d2SumDegreeCdRdTheta -= nOr * c1;
                    d2SumDegreeCdThetadTheta += c2;
                }
                double sML = cosSinLambda[1][m];
                double cML = cosSinLambda[0][m];
                value = value * u + sML * sumDegreeS + cML * sumDegreeC;
                gradient[0] = gradient[0] * u + sML * dSumDegreeSdR + cML * dSumDegreeCdR;
                gradient[1] = gradient[1] * u + (double)m * (cML * sumDegreeS - sML * sumDegreeC);
                gradient[2] = gradient[2] * u + sML * dSumDegreeSdTheta + cML * dSumDegreeCdTheta;
                hessian[0][0] = hessian[0][0] * u + sML * d2SumDegreeSdRdR + cML * d2SumDegreeCdRdR;
                hessian[1][0] = hessian[1][0] * u + (double)m * (cML * dSumDegreeSdR - sML * dSumDegreeCdR);
                hessian[2][0] = hessian[2][0] * u + sML * d2SumDegreeSdRdTheta + cML * d2SumDegreeCdRdTheta;
                hessian[1][1] = hessian[1][1] * u - (double)(m * m) * (sML * sumDegreeS + cML * sumDegreeC);
                hessian[2][1] = hessian[2][1] * u + (double)m * (cML * dSumDegreeSdTheta - sML * dSumDegreeCdTheta);
                hessian[2][2] = hessian[2][2] * u + sML * d2SumDegreeSdThetadTheta + cML * d2SumDegreeCdThetadTheta;
            }
            double[] tmp0 = pnm0Plus2;
            pnm0Plus2 = pnm0Plus1;
            pnm0Plus1 = pnm0;
            pnm0 = tmp0;
            double[] tmp1 = pnm1Plus1;
            pnm1Plus1 = pnm1;
            pnm1 = tmp1;
        }
        value = FastMath.scalb((double)value, (int)930);
        for (int i = 0; i < 3; ++i) {
            gradient[i] = FastMath.scalb((double)gradient[i], (int)930);
            for (int j = 0; j <= i; ++j) {
                hessian[i][j] = FastMath.scalb((double)hessian[i][j], (int)930);
            }
        }
        double muOr = mu / r;
        gradient[0] = muOr * gradient[0] - (value *= muOr) / r;
        gradient[1] = gradient[1] * muOr;
        gradient[2] = gradient[2] * muOr;
        hessian[0][0] = muOr * hessian[0][0] - 2.0 * gradient[0] / r;
        hessian[1][0] = muOr * hessian[1][0] - gradient[1] / r;
        hessian[2][0] = muOr * hessian[2][0] - gradient[2] / r;
        double[] dArray = hessian[1];
        dArray[1] = dArray[1] * muOr;
        double[] dArray2 = hessian[2];
        dArray2[1] = dArray2[1] * muOr;
        double[] dArray3 = hessian[2];
        dArray3[2] = dArray3[2] * muOr;
        SphericalCoordinates sc = new SphericalCoordinates(position);
        return new GradientHessian(sc.toCartesianGradient(gradient), sc.toCartesianHessian(hessian, gradient));
    }

    private double[] createDistancePowersArray(double aOr) {
        double[] aOrN = new double[this.provider.getMaxDegree() + 1];
        aOrN[0] = 1.0;
        aOrN[1] = aOr;
        for (int n = 2; n < aOrN.length; ++n) {
            int p = n / 2;
            int q = n - p;
            aOrN[n] = aOrN[p] * aOrN[q];
        }
        return aOrN;
    }

    private <T extends CalculusFieldElement<T>> T[] createDistancePowersArray(T aOr) {
        CalculusFieldElement[] aOrN = (CalculusFieldElement[])MathArrays.buildArray((Field)aOr.getField(), (int)(this.provider.getMaxDegree() + 1));
        aOrN[0] = (CalculusFieldElement)aOr.getField().getOne();
        aOrN[1] = aOr;
        for (int n = 2; n < aOrN.length; ++n) {
            int p = n / 2;
            int q = n - p;
            aOrN[n] = (CalculusFieldElement)aOrN[p].multiply((FieldElement)aOrN[q]);
        }
        return aOrN;
    }

    private double[][] createCosSinArrays(double cosLambda, double sinLambda) {
        double[][] cosSin = new double[2][this.provider.getMaxOrder() + 1];
        cosSin[0][0] = 1.0;
        cosSin[1][0] = 0.0;
        if (this.provider.getMaxOrder() > 0) {
            cosSin[0][1] = cosLambda;
            cosSin[1][1] = sinLambda;
            for (int m = 2; m < cosSin[0].length; ++m) {
                int p = m / 2;
                int q = m - p;
                cosSin[0][m] = cosSin[0][p] * cosSin[0][q] - cosSin[1][p] * cosSin[1][q];
                cosSin[1][m] = cosSin[1][p] * cosSin[0][q] + cosSin[0][p] * cosSin[1][q];
            }
        }
        return cosSin;
    }

    private <T extends CalculusFieldElement<T>> T[][] createCosSinArrays(T cosLambda, T sinLambda) {
        CalculusFieldElement one = (CalculusFieldElement)cosLambda.getField().getOne();
        CalculusFieldElement zero = (CalculusFieldElement)cosLambda.getField().getZero();
        CalculusFieldElement[][] cosSin = (CalculusFieldElement[][])MathArrays.buildArray((Field)one.getField(), (int)2, (int)(this.provider.getMaxOrder() + 1));
        cosSin[0][0] = one;
        cosSin[1][0] = zero;
        if (this.provider.getMaxOrder() > 0) {
            cosSin[0][1] = cosLambda;
            cosSin[1][1] = sinLambda;
            for (int m = 2; m < cosSin[0].length; ++m) {
                int p = m / 2;
                int q = m - p;
                cosSin[0][m] = (CalculusFieldElement)((CalculusFieldElement)cosSin[0][p].multiply((FieldElement)cosSin[0][q])).subtract(cosSin[1][p].multiply((FieldElement)cosSin[1][q]));
                cosSin[1][m] = (CalculusFieldElement)((CalculusFieldElement)cosSin[1][p].multiply((FieldElement)cosSin[0][q])).add(cosSin[0][p].multiply((FieldElement)cosSin[1][q]));
            }
        }
        return cosSin;
    }

    private int computeTesseral(int m, int degree, int index, double t, double u, double tOu, double[] pnm0Plus2, double[] pnm0Plus1, double[] pnm1Plus1, double[] pnm0, double[] pnm1, double[] pnm2) {
        double u2 = u * u;
        int n = FastMath.max((int)2, (int)m);
        if (n == m) {
            pnm0[n] = this.sectorial[n];
            ++n;
        }
        int localIndex = index;
        while (n <= degree) {
            pnm0[n] = this.gnmOj[localIndex] * t * pnm0Plus1[n] - this.hnmOj[localIndex] * u2 * pnm0Plus2[n];
            ++localIndex;
            ++n;
        }
        if (pnm1 != null) {
            n = FastMath.max((int)2, (int)m);
            if (n == m) {
                pnm1[n] = (double)m * tOu * pnm0[n];
                ++n;
            }
            localIndex = index;
            while (n <= degree) {
                pnm1[n] = (double)m * tOu * pnm0[n] - this.enm[localIndex] * u * pnm0Plus1[n];
                ++localIndex;
                ++n;
            }
            if (pnm2 != null) {
                n = FastMath.max((int)2, (int)m);
                if (n == m) {
                    pnm2[n] = (double)m * (tOu * pnm1[n] - pnm0[n] / u2);
                    ++n;
                }
                localIndex = index;
                while (n <= degree) {
                    pnm2[n] = (double)m * (tOu * pnm1[n] - pnm0[n] / u2) - this.enm[localIndex] * u * pnm1Plus1[n];
                    ++localIndex;
                    ++n;
                }
            }
        }
        return localIndex;
    }

    private <T extends CalculusFieldElement<T>> int computeTesseral(int m, int degree, int index, T t, T u, T tOu, T[] pnm0Plus2, T[] pnm0Plus1, T[] pnm1Plus1, T[] pnm0, T[] pnm1, T[] pnm2) {
        CalculusFieldElement u2 = (CalculusFieldElement)u.multiply(u);
        CalculusFieldElement zero = (CalculusFieldElement)u.getField().getZero();
        int n = FastMath.max((int)2, (int)m);
        if (n == m) {
            pnm0[n] = (CalculusFieldElement)zero.add(this.sectorial[n]);
            ++n;
        }
        int localIndex = index;
        while (n <= degree) {
            pnm0[n] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)t.multiply(this.gnmOj[localIndex])).multiply(pnm0Plus1[n])).subtract(((CalculusFieldElement)u2.multiply(pnm0Plus2[n])).multiply(this.hnmOj[localIndex]));
            ++localIndex;
            ++n;
        }
        if (pnm1 != null) {
            n = FastMath.max((int)2, (int)m);
            if (n == m) {
                pnm1[n] = (CalculusFieldElement)((CalculusFieldElement)tOu.multiply(m)).multiply(pnm0[n]);
                ++n;
            }
            localIndex = index;
            while (n <= degree) {
                pnm1[n] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)tOu.multiply(m)).multiply(pnm0[n])).subtract(((CalculusFieldElement)u.multiply(this.enm[localIndex])).multiply(pnm0Plus1[n]));
                ++localIndex;
                ++n;
            }
            if (pnm2 != null) {
                n = FastMath.max((int)2, (int)m);
                if (n == m) {
                    pnm2[n] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)tOu.multiply(pnm1[n])).subtract(pnm0[n].divide((FieldElement)u2))).multiply(m);
                    ++n;
                }
                localIndex = index;
                while (n <= degree) {
                    pnm2[n] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)tOu.multiply(pnm1[n])).subtract(pnm0[n].divide((FieldElement)u2))).multiply(m)).subtract(((CalculusFieldElement)u.multiply(pnm1Plus1[n])).multiply(this.enm[localIndex]));
                    ++localIndex;
                    ++n;
                }
            }
        }
        return localIndex;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        double mu = parameters[0];
        AbsoluteDate date = s.getDate();
        Transform fromBodyFrame = this.bodyFrame.getTransformTo(s.getFrame(), date);
        Transform toBodyFrame = fromBodyFrame.getInverse();
        Vector3D position = toBodyFrame.transformPosition(s.getPVCoordinates().getPosition());
        return fromBodyFrame.transformVector(new Vector3D(this.gradient(date, position, mu)));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        T mu = parameters[0];
        if (this.isGradientStateDerivative(s)) {
            FieldVector3D p = s.getPVCoordinates().getPosition();
            FieldVector3D<Gradient> a = this.accelerationWrtState(s.getDate().toAbsoluteDate(), s.getFrame(), p, (Gradient)mu);
            return a;
        }
        if (this.isDSStateDerivative(s)) {
            FieldVector3D p = s.getPVCoordinates().getPosition();
            FieldVector3D<DerivativeStructure> a = this.accelerationWrtState(s.getDate().toAbsoluteDate(), s.getFrame(), p, (DerivativeStructure)mu);
            return a;
        }
        FieldAbsoluteDate<T> date = s.getDate();
        Transform fromBodyFrame = this.bodyFrame.getTransformTo(s.getFrame(), date.toAbsoluteDate());
        Transform toBodyFrame = fromBodyFrame.getInverse();
        FieldVector3D position = toBodyFrame.transformPosition(s.getPVCoordinates().getPosition());
        return fromBodyFrame.transformVector(new FieldVector3D(this.gradient(date, position, (CalculusFieldElement)mu)));
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }

    private <T extends CalculusFieldElement<T>> boolean isDSStateDerivative(FieldSpacecraftState<T> state) {
        try {
            DerivativeStructure dsMass = (DerivativeStructure)state.getMass();
            int o = dsMass.getOrder();
            int p = dsMass.getFreeParameters();
            if (o != 1 || p < 3) {
                return false;
            }
            TimeStampedFieldPVCoordinates<T> pv = state.getPVCoordinates();
            return this.isVariable((DerivativeStructure)pv.getPosition().getX(), 0) && this.isVariable((DerivativeStructure)pv.getPosition().getY(), 1) && this.isVariable((DerivativeStructure)pv.getPosition().getZ(), 2);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    private <T extends CalculusFieldElement<T>> boolean isGradientStateDerivative(FieldSpacecraftState<T> state) {
        try {
            Gradient gMass = (Gradient)state.getMass();
            int p = gMass.getFreeParameters();
            if (p < 3) {
                return false;
            }
            TimeStampedFieldPVCoordinates<T> pv = state.getPVCoordinates();
            return this.isVariable((Gradient)pv.getPosition().getX(), 0) && this.isVariable((Gradient)pv.getPosition().getY(), 1) && this.isVariable((Gradient)pv.getPosition().getZ(), 2);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    private boolean isVariable(DerivativeStructure ds, int index) {
        double[] derivatives = ds.getAllDerivatives();
        boolean check = true;
        for (int i = 1; i < derivatives.length; ++i) {
            check &= derivatives[i] == (index + 1 == i ? 1.0 : 0.0);
        }
        return check;
    }

    private boolean isVariable(Gradient g, int index) {
        double[] derivatives = g.getGradient();
        boolean check = true;
        for (int i = 0; i < derivatives.length; ++i) {
            check &= derivatives[i] == (index == i ? 1.0 : 0.0);
        }
        return check;
    }

    private FieldVector3D<DerivativeStructure> accelerationWrtState(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, DerivativeStructure mu) {
        int freeParameters = mu.getFreeParameters();
        Transform fromBodyFrame = this.bodyFrame.getTransformTo(frame, date);
        Transform toBodyFrame = fromBodyFrame.getInverse();
        Vector3D positionBody = toBodyFrame.transformPosition(position.toVector3D());
        GradientHessian gh = this.gradientHessian(date, positionBody, mu.getReal());
        double[] gInertial = fromBodyFrame.transformVector(new Vector3D(gh.getGradient())).toArray();
        Array2DRowRealMatrix hBody = new Array2DRowRealMatrix(gh.getHessian(), false);
        Array2DRowRealMatrix rot = new Array2DRowRealMatrix(toBodyFrame.getRotation().getMatrix());
        RealMatrix hInertial = rot.transpose().multiply((RealMatrix)hBody).multiply((RealMatrix)rot);
        double[] derivatives = new double[freeParameters + 1];
        DerivativeStructure[] accDer = new DerivativeStructure[3];
        for (int i = 0; i < 3; ++i) {
            derivatives[0] = gInertial[i];
            derivatives[1] = hInertial.getEntry(i, 0);
            derivatives[2] = hInertial.getEntry(i, 1);
            derivatives[3] = hInertial.getEntry(i, 2);
            if (derivatives.length > 4 && this.isVariable(mu, 3)) {
                derivatives[4] = gInertial[i] / mu.getReal();
            }
            accDer[i] = ((DerivativeStructure)position.getX()).getFactory().build(derivatives);
        }
        return new FieldVector3D((CalculusFieldElement[])accDer);
    }

    private FieldVector3D<Gradient> accelerationWrtState(AbsoluteDate date, Frame frame, FieldVector3D<Gradient> position, Gradient mu) {
        int freeParameters = mu.getFreeParameters();
        Transform fromBodyFrame = this.bodyFrame.getTransformTo(frame, date);
        Transform toBodyFrame = fromBodyFrame.getInverse();
        Vector3D positionBody = toBodyFrame.transformPosition(position.toVector3D());
        GradientHessian gh = this.gradientHessian(date, positionBody, mu.getReal());
        double[] gInertial = fromBodyFrame.transformVector(new Vector3D(gh.getGradient())).toArray();
        Array2DRowRealMatrix hBody = new Array2DRowRealMatrix(gh.getHessian(), false);
        Array2DRowRealMatrix rot = new Array2DRowRealMatrix(toBodyFrame.getRotation().getMatrix());
        RealMatrix hInertial = rot.transpose().multiply((RealMatrix)hBody).multiply((RealMatrix)rot);
        double[] derivatives = new double[freeParameters];
        Gradient[] accDer = new Gradient[3];
        for (int i = 0; i < 3; ++i) {
            derivatives[0] = hInertial.getEntry(i, 0);
            derivatives[1] = hInertial.getEntry(i, 1);
            derivatives[2] = hInertial.getEntry(i, 2);
            if (derivatives.length > 3 && this.isVariable(mu, 3)) {
                derivatives[3] = gInertial[i] / mu.getReal();
            }
            accDer[i] = new Gradient(gInertial[i], derivatives);
        }
        return new FieldVector3D((CalculusFieldElement[])accDer);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.gmParameterDriver);
    }

    private static class GradientHessian {
        private final double[] gradient;
        private final double[][] hessian;

        GradientHessian(double[] gradient, double[][] hessian) {
            this.gradient = gradient;
            this.hessian = hessian;
        }

        public double[] getGradient() {
            return this.gradient;
        }

        public double[][] getHessian() {
            return this.hessian;
        }
    }
}

