/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.nonlinear.vector.leastsquares;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.CholeskyDecomposition;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.QRDecomposer;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.ConvergenceChecker;
import org.hipparchus.optim.LocalizedOptimFormats;
import org.hipparchus.optim.nonlinear.vector.leastsquares.AbstractEvaluation;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresOptimizer;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.util.Incrementor;
import org.hipparchus.util.Pair;

public class SequentialGaussNewtonOptimizer
implements LeastSquaresOptimizer {
    private static final double SINGULARITY_THRESHOLD = 1.0E-11;
    private final MatrixDecomposer decomposer;
    private final boolean formNormalEquations;
    private final LeastSquaresProblem.Evaluation oldEvaluation;
    private final RealMatrix oldLhs;
    private final RealVector oldRhs;

    public SequentialGaussNewtonOptimizer() {
        this((MatrixDecomposer)new QRDecomposer(1.0E-11), false, null);
    }

    public SequentialGaussNewtonOptimizer(MatrixDecomposer decomposer, boolean formNormalEquations, LeastSquaresProblem.Evaluation evaluation) {
        this.decomposer = decomposer;
        this.formNormalEquations = formNormalEquations;
        this.oldEvaluation = evaluation;
        if (evaluation == null) {
            this.oldLhs = null;
            this.oldRhs = null;
        } else if (formNormalEquations) {
            Pair<RealMatrix, RealVector> normalEquation = SequentialGaussNewtonOptimizer.computeNormalMatrix(evaluation.getJacobian(), evaluation.getResiduals());
            this.oldLhs = (RealMatrix)normalEquation.getFirst();
            this.oldRhs = (RealVector)normalEquation.getSecond();
        } else {
            this.oldLhs = evaluation.getJacobian();
            this.oldRhs = evaluation.getResiduals();
        }
    }

    public MatrixDecomposer getDecomposer() {
        return this.decomposer;
    }

    public SequentialGaussNewtonOptimizer withDecomposer(MatrixDecomposer newDecomposer) {
        return new SequentialGaussNewtonOptimizer(newDecomposer, this.isFormNormalEquations(), this.getOldEvaluation());
    }

    public boolean isFormNormalEquations() {
        return this.formNormalEquations;
    }

    public SequentialGaussNewtonOptimizer withFormNormalEquations(boolean newFormNormalEquations) {
        return new SequentialGaussNewtonOptimizer(this.getDecomposer(), newFormNormalEquations, this.getOldEvaluation());
    }

    public LeastSquaresProblem.Evaluation getOldEvaluation() {
        return this.oldEvaluation;
    }

    public SequentialGaussNewtonOptimizer withEvaluation(LeastSquaresProblem.Evaluation previousEvaluation) {
        return new SequentialGaussNewtonOptimizer(this.getDecomposer(), this.isFormNormalEquations(), previousEvaluation);
    }

    public SequentialGaussNewtonOptimizer withAPrioriData(final RealVector aPrioriState, RealMatrix aPrioriCovariance) {
        RealMatrix jTj = this.getDecomposer().decompose(aPrioriCovariance).getInverse();
        final RealMatrix weightedJacobian = new CholeskyDecomposition(jTj).getLT();
        final RealVector residuals = MatrixUtils.createRealVector((int)aPrioriState.getDimension());
        AbstractEvaluation fakeEvaluation = new AbstractEvaluation(aPrioriState.getDimension()){

            @Override
            public RealVector getResiduals() {
                return residuals;
            }

            @Override
            public RealVector getPoint() {
                return aPrioriState;
            }

            @Override
            public RealMatrix getJacobian() {
                return weightedJacobian;
            }
        };
        return this.withEvaluation(fakeEvaluation);
    }

    @Override
    public LeastSquaresOptimizer.Optimum optimize(LeastSquaresProblem lsp) {
        Incrementor evaluationCounter = lsp.getEvaluationCounter();
        Incrementor iterationCounter = lsp.getIterationCounter();
        ConvergenceChecker<LeastSquaresProblem.Evaluation> checker = lsp.getConvergenceChecker();
        if (checker == null) {
            throw new NullArgumentException();
        }
        RealVector currentPoint = lsp.getStart();
        if (this.oldEvaluation != null && currentPoint.getDimension() != this.oldEvaluation.getPoint().getDimension()) {
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{currentPoint.getDimension(), this.oldEvaluation.getPoint().getDimension()});
        }
        LeastSquaresProblem.Evaluation current = null;
        while (true) {
            RealVector dX;
            RealVector rhs;
            RealMatrix lhs;
            iterationCounter.increment();
            LeastSquaresProblem.Evaluation previous = current;
            evaluationCounter.increment();
            current = lsp.evaluate(currentPoint);
            RealVector currentResiduals = current.getResiduals();
            RealMatrix weightedJacobian = current.getJacobian();
            currentPoint = current.getPoint();
            if (previous != null && checker.converged(iterationCounter.getCount(), previous, current)) {
                LeastSquaresProblem.Evaluation combinedEvaluation = this.oldEvaluation == null ? current : new CombinedEvaluation(this.oldEvaluation, current);
                return LeastSquaresOptimizer.Optimum.of(combinedEvaluation, evaluationCounter.getCount(), iterationCounter.getCount());
            }
            if (this.formNormalEquations) {
                Pair<RealMatrix, RealVector> normalEquation = SequentialGaussNewtonOptimizer.computeNormalMatrix(weightedJacobian, currentResiduals);
                lhs = this.oldLhs == null ? (RealMatrix)normalEquation.getFirst() : ((RealMatrix)normalEquation.getFirst()).add(this.oldLhs);
                rhs = this.oldRhs == null ? (RealVector)normalEquation.getSecond() : ((RealVector)normalEquation.getSecond()).add(this.oldRhs);
            } else {
                lhs = this.oldLhs == null ? weightedJacobian : SequentialGaussNewtonOptimizer.combineJacobians(this.oldLhs, weightedJacobian);
                rhs = this.oldRhs == null ? currentResiduals : SequentialGaussNewtonOptimizer.combineResiduals(this.oldRhs, currentResiduals);
            }
            try {
                dX = this.decomposer.decompose(lhs).solve(rhs);
            }
            catch (MathIllegalArgumentException e) {
                throw new MathIllegalStateException((Localizable)LocalizedOptimFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, new Object[]{e});
            }
            currentPoint = currentPoint.add(dX);
        }
    }

    public String toString() {
        return "SequentialGaussNewtonOptimizer{decomposer=" + this.decomposer + '}';
    }

    private static Pair<RealMatrix, RealVector> computeNormalMatrix(RealMatrix jacobian, RealVector residuals) {
        int j;
        int i;
        int nR = jacobian.getRowDimension();
        int nC = jacobian.getColumnDimension();
        RealMatrix normal = MatrixUtils.createRealMatrix((int)nC, (int)nC);
        ArrayRealVector jTr = new ArrayRealVector(nC);
        for (i = 0; i < nR; ++i) {
            for (j = 0; j < nC; ++j) {
                jTr.setEntry(j, jTr.getEntry(j) + residuals.getEntry(i) * jacobian.getEntry(i, j));
            }
            for (int k = 0; k < nC; ++k) {
                for (int l = k; l < nC; ++l) {
                    normal.setEntry(k, l, normal.getEntry(k, l) + jacobian.getEntry(i, k) * jacobian.getEntry(i, l));
                }
            }
        }
        for (i = 0; i < nC; ++i) {
            for (j = 0; j < i; ++j) {
                normal.setEntry(i, j, normal.getEntry(j, i));
            }
        }
        return new Pair((Object)normal, (Object)jTr);
    }

    private static RealMatrix combineJacobians(RealMatrix oldJacobian, RealMatrix newJacobian) {
        int oldRowDimension = oldJacobian.getRowDimension();
        int oldColumnDimension = oldJacobian.getColumnDimension();
        RealMatrix jacobian = MatrixUtils.createRealMatrix((int)(oldRowDimension + newJacobian.getRowDimension()), (int)oldColumnDimension);
        jacobian.setSubMatrix(oldJacobian.getData(), 0, 0);
        jacobian.setSubMatrix(newJacobian.getData(), oldRowDimension, 0);
        return jacobian;
    }

    private static RealVector combineResiduals(RealVector oldResiduals, RealVector newResiduals) {
        return oldResiduals.append(newResiduals);
    }

    private static class CombinedEvaluation
    extends AbstractEvaluation {
        private final RealVector point;
        private final RealMatrix jacobian;
        private final RealVector residuals;

        private CombinedEvaluation(LeastSquaresProblem.Evaluation oldEvaluation, LeastSquaresProblem.Evaluation newEvaluation) {
            super(oldEvaluation.getResiduals().getDimension() + newEvaluation.getResiduals().getDimension());
            this.point = newEvaluation.getPoint();
            this.jacobian = SequentialGaussNewtonOptimizer.combineJacobians(oldEvaluation.getJacobian(), newEvaluation.getJacobian());
            this.residuals = SequentialGaussNewtonOptimizer.combineResiduals(oldEvaluation.getResiduals(), newEvaluation.getResiduals());
        }

        @Override
        public RealMatrix getJacobian() {
            return this.jacobian;
        }

        @Override
        public RealVector getPoint() {
            return this.point;
        }

        @Override
        public RealVector getResiduals() {
            return this.residuals;
        }
    }
}

