/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.carlson;

import org.hipparchus.util.FastMath;

abstract class RealDuplication {
    private static final int M_MAX = 16;
    private final double[] initialVA;
    private final double q;

    RealDuplication(double ... v) {
        int n = v.length;
        this.initialVA = new double[n + 1];
        System.arraycopy(v, 0, this.initialVA, 0, n);
        this.initialMeanPoint(this.initialVA);
        double max = 0.0;
        double a0 = this.initialVA[n];
        for (double vi : v) {
            max = FastMath.max(max, FastMath.abs(a0 - vi));
        }
        this.q = this.convergenceCriterion(FastMath.ulp(1.0), max);
    }

    protected double getVi(int i) {
        return this.initialVA[i];
    }

    protected abstract void initialMeanPoint(double[] var1);

    protected abstract double convergenceCriterion(double var1, double var3);

    protected abstract void update(int var1, double[] var2, double[] var3, double var4);

    protected abstract double evaluate(double[] var1, double var2, double var4);

    public double integral() {
        int n = this.initialVA.length - 1;
        double[] vaM = (double[])this.initialVA.clone();
        double[] sqrtM = new double[n];
        double fourM = 1.0;
        for (int m = 0; !(m >= 16 || m > 0 && this.q < fourM * FastMath.abs(vaM[n])); ++m) {
            for (int i = 0; i < n; ++i) {
                sqrtM[i] = FastMath.sqrt(vaM[i]);
            }
            this.update(m, vaM, sqrtM, fourM);
            fourM *= 4.0;
        }
        return this.evaluate(this.initialVA, vaM[n], fourM);
    }
}

