/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Pair;

public class FieldGaussIntegrator<T extends CalculusFieldElement<T>> {
    private final T[] points;
    private final T[] weights;

    public FieldGaussIntegrator(T[] points, T[] weights) throws MathIllegalArgumentException {
        MathArrays.checkEqualLength(points, weights);
        MathArrays.checkOrder(points, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)true, (boolean)true);
        this.points = (CalculusFieldElement[])points.clone();
        this.weights = (CalculusFieldElement[])weights.clone();
    }

    public FieldGaussIntegrator(Pair<T[], T[]> pointsAndWeights) throws MathIllegalArgumentException {
        this((CalculusFieldElement[])pointsAndWeights.getFirst(), (CalculusFieldElement[])pointsAndWeights.getSecond());
    }

    public T integrate(CalculusFieldUnivariateFunction<T> f) {
        CalculusFieldElement s;
        CalculusFieldElement c = s = (CalculusFieldElement)this.points[0].getField().getZero();
        for (int i = 0; i < this.points.length; ++i) {
            T x = this.points[i];
            T w = this.weights[i];
            CalculusFieldElement y = ((CalculusFieldElement)w.multiply(f.value(x))).subtract(c);
            CalculusFieldElement t = s.add(y);
            c = t.subtract(s).subtract(y);
            s = t;
        }
        return (T)s;
    }

    public int getNumberOfPoints() {
        return this.points.length;
    }

    public T getPoint(int index) {
        return this.points[index];
    }

    public T getWeight(int index) {
        return this.weights[index];
    }
}

