/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.Collection;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldAdditionalStateProvider;
import org.orekit.propagation.FieldEphemerisGenerator;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.sampling.FieldOrekitFixedStepHandler;
import org.orekit.propagation.sampling.FieldOrekitStepHandler;
import org.orekit.propagation.sampling.FieldStepHandlerMultiplexer;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;

public interface FieldPropagator<T extends CalculusFieldElement<T>>
extends FieldPVCoordinatesProvider<T> {
    public static final double DEFAULT_MASS = 1000.0;

    public FieldStepHandlerMultiplexer<T> getMultiplexer();

    default public void clearStepHandlers() {
        this.getMultiplexer().clear();
    }

    default public void setStepHandler(T h, FieldOrekitFixedStepHandler<T> handler) {
        this.getMultiplexer().clear();
        this.getMultiplexer().add(h, handler);
    }

    default public void setStepHandler(FieldOrekitStepHandler<T> handler) {
        this.getMultiplexer().clear();
        this.getMultiplexer().add(handler);
    }

    public FieldEphemerisGenerator<T> getEphemerisGenerator();

    public FieldSpacecraftState<T> getInitialState();

    public void resetInitialState(FieldSpacecraftState<T> var1);

    public void addAdditionalStateProvider(FieldAdditionalStateProvider<T> var1);

    public List<FieldAdditionalStateProvider<T>> getAdditionalStateProviders();

    public boolean isAdditionalStateManaged(String var1);

    public String[] getManagedAdditionalStates();

    public <D extends FieldEventDetector<T>> void addEventDetector(D var1);

    public Collection<FieldEventDetector<T>> getEventsDetectors();

    public void clearEventsDetectors();

    public AttitudeProvider getAttitudeProvider();

    public void setAttitudeProvider(AttitudeProvider var1);

    public Frame getFrame();

    public FieldSpacecraftState<T> propagate(FieldAbsoluteDate<T> var1);

    public FieldSpacecraftState<T> propagate(FieldAbsoluteDate<T> var1, FieldAbsoluteDate<T> var2);
}

