/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class MariniMurrayModel
implements DiscreteTroposphericModel {
    private double T0;
    private double P0;
    private double e0;
    private double lambda;

    public MariniMurrayModel(double t0, double p0, double rh, double lambda) {
        this.T0 = t0;
        this.P0 = p0;
        this.e0 = this.getWaterVapor(rh);
        this.lambda = lambda * 0.001;
    }

    public static MariniMurrayModel getStandardModel(double lambda) {
        return new MariniMurrayModel(293.15, 1013.25, 0.5, lambda);
    }

    @Override
    public double pathDelay(double elevation, GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        double A = 0.002357 * this.P0 + 1.41E-4 * this.e0;
        double K = 1.163 - 0.00968 * FastMath.cos((double)(2.0 * point.getLatitude())) - 0.00104 * this.T0 + 1.435E-5 * this.P0;
        double B = 1.0840000000000001E-8 * this.P0 * this.T0 * K + 4.734E-8 * this.P0 * (this.P0 / this.T0) * (2.0 * K) / (3.0 * K - 1.0);
        double flambda = this.getLaserFrequencyParameter();
        double fsite = this.getSiteFunctionValue(point);
        double sinE = FastMath.sin((double)elevation);
        double dR = flambda / fsite * (A + B) / (sinE + B / ((A + B) * (sinE + 0.01)));
        return dR;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T pathDelay(T elevation, FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        double A = 0.002357 * this.P0 + 1.41E-4 * this.e0;
        CalculusFieldElement K = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.cos((CalculusFieldElement)((CalculusFieldElement)point.getLatitude().multiply(2.0))).multiply(0.00968)).negate()).add(1.163)).subtract(0.00104 * this.T0)).add(1.435E-5 * this.P0);
        CalculusFieldElement B = (CalculusFieldElement)((CalculusFieldElement)K.multiply(1.0840000000000001E-8 * this.P0 * this.T0)).add(((CalculusFieldElement)((CalculusFieldElement)K.multiply(2.0)).multiply(4.734E-8 * this.P0 * (this.P0 / this.T0))).divide(((CalculusFieldElement)K.multiply(3.0)).subtract(1.0)));
        double flambda = this.getLaserFrequencyParameter();
        T fsite = this.getSiteFunctionValue(point);
        CalculusFieldElement sinE = FastMath.sin(elevation);
        CalculusFieldElement dR = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fsite.divide(flambda)).reciprocal()).multiply(B.add(A))).divide(sinE.add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinE.add(0.01)).multiply(B.add(A))).divide((FieldElement)B)).reciprocal()));
        return (T)dR;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private double getLaserFrequencyParameter() {
        return 0.965 + 0.0164 * FastMath.pow((double)this.lambda, (int)-2) + 2.28E-4 * FastMath.pow((double)this.lambda, (int)-4);
    }

    private double getSiteFunctionValue(GeodeticPoint point) {
        return 1.0 - 0.0026 * FastMath.cos((double)(2.0 * point.getLatitude())) - 3.1E-7 * point.getAltitude();
    }

    private <T extends CalculusFieldElement<T>> T getSiteFunctionValue(FieldGeodeticPoint<T> point) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.cos((CalculusFieldElement)((CalculusFieldElement)point.getLatitude().multiply(2))).multiply(0.0026)).add(((CalculusFieldElement)point.getAltitude().multiply(0.001)).multiply(3.1E-4))).negate()).add(1.0));
    }

    private double getWaterVapor(double rh) {
        double es = 0.01 * FastMath.exp((double)(1.2378847000000001E-5 * this.T0 * this.T0 - 0.019121316 * this.T0 + 33.93711047 - 6343.164500000001 / this.T0));
        double fw = 1.00062 + 3.14E-6 * this.P0 + 5.599999999999999E-7 * FastMath.pow((double)(this.T0 - 273.15), (int)2);
        double e = rh * fw * es;
        return e;
    }
}

