/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.ConstantSphericalHarmonics;
import org.orekit.forces.gravity.potential.LazyLoadedGravityFields;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.Normalizer;
import org.orekit.forces.gravity.potential.OceanLoadDeformationCoefficients;
import org.orekit.forces.gravity.potential.OceanTidesReader;
import org.orekit.forces.gravity.potential.OceanTidesWave;
import org.orekit.forces.gravity.potential.PotentialCoefficientsReader;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.Unnormalizer;
import org.orekit.forces.gravity.potential.WrappingNormalizedProvider;
import org.orekit.forces.gravity.potential.WrappingUnnormalizedProvider;

public class GravityFieldFactory {
    public static final String ICGEM_FILENAME = "^(.*\\.gfc)|(g(\\d)+_eigen[-_](\\w)+_coef)$";
    public static final String SHM_FILENAME = "^eigen[-_](\\w)+_coef$";
    public static final String EGM_FILENAME = "^egm\\d\\d_to\\d.*$";
    public static final String GRGS_FILENAME = "^grim\\d_.*$";
    public static final String FES_CNM_SNM_FILENAME = "^fes(\\d)+_Cnm-Snm.dat$";
    public static final String FES_CHAT_EPSILON_FILENAME = "^fes(\\d)+.dat$";
    public static final String FES_HF_FILENAME = "^hf-fes(\\d)+.dat$";

    private GravityFieldFactory() {
    }

    @DefaultDataContext
    public static LazyLoadedGravityFields getGravityFields() {
        return DataContext.getDefault().getGravityFields();
    }

    @DefaultDataContext
    public static void addPotentialCoefficientsReader(PotentialCoefficientsReader reader) {
        GravityFieldFactory.getGravityFields().addPotentialCoefficientsReader(reader);
    }

    @DefaultDataContext
    public static void addDefaultPotentialCoefficientsReaders() {
        GravityFieldFactory.getGravityFields().addDefaultPotentialCoefficientsReaders();
    }

    @DefaultDataContext
    public static void clearPotentialCoefficientsReaders() {
        GravityFieldFactory.getGravityFields().clearPotentialCoefficientsReaders();
    }

    @DefaultDataContext
    public static void addOceanTidesReader(OceanTidesReader reader) {
        GravityFieldFactory.getGravityFields().addOceanTidesReader(reader);
    }

    @DefaultDataContext
    public static void configureOceanLoadDeformationCoefficients(OceanLoadDeformationCoefficients oldc) {
        GravityFieldFactory.getGravityFields().configureOceanLoadDeformationCoefficients(oldc);
    }

    @DefaultDataContext
    public static OceanLoadDeformationCoefficients getOceanLoadDeformationCoefficients() {
        return GravityFieldFactory.getGravityFields().getOceanLoadDeformationCoefficients();
    }

    @DefaultDataContext
    public static void addDefaultOceanTidesReaders() {
        GravityFieldFactory.getGravityFields().addDefaultOceanTidesReaders();
    }

    @DefaultDataContext
    public static void clearOceanTidesReaders() {
        GravityFieldFactory.getGravityFields().clearOceanTidesReaders();
    }

    @DefaultDataContext
    public static NormalizedSphericalHarmonicsProvider getConstantNormalizedProvider(int degree, int order) {
        return GravityFieldFactory.getGravityFields().getConstantNormalizedProvider(degree, order);
    }

    @DefaultDataContext
    public static NormalizedSphericalHarmonicsProvider getNormalizedProvider(int degree, int order) {
        return GravityFieldFactory.getGravityFields().getNormalizedProvider(degree, order);
    }

    @DefaultDataContext
    public static UnnormalizedSphericalHarmonicsProvider getConstantUnnormalizedProvider(int degree, int order) {
        return GravityFieldFactory.getGravityFields().getConstantUnnormalizedProvider(degree, order);
    }

    @DefaultDataContext
    public static UnnormalizedSphericalHarmonicsProvider getUnnormalizedProvider(int degree, int order) {
        return GravityFieldFactory.getGravityFields().getUnnormalizedProvider(degree, order);
    }

    @DefaultDataContext
    public static PotentialCoefficientsReader readGravityField(int maxParseDegree, int maxParseOrder) {
        return GravityFieldFactory.getGravityFields().readGravityField(maxParseDegree, maxParseOrder);
    }

    @DefaultDataContext
    public static List<OceanTidesWave> getOceanTidesWaves(int degree, int order) {
        return GravityFieldFactory.getGravityFields().getOceanTidesWaves(degree, order);
    }

    public static NormalizedSphericalHarmonicsProvider getNormalizedProvider(double ae, double mu, TideSystem tideSystem, double[][] normalizedC, double[][] normalizedS) {
        return new WrappingNormalizedProvider(new ConstantSphericalHarmonics(ae, mu, tideSystem, normalizedC, normalizedS));
    }

    public static NormalizedSphericalHarmonicsProvider getNormalizedProvider(UnnormalizedSphericalHarmonicsProvider unnormalized) {
        return new Normalizer(unnormalized);
    }

    public static UnnormalizedSphericalHarmonicsProvider getUnnormalizedProvider(double ae, double mu, TideSystem tideSystem, double[][] unnormalizedC, double[][] unnormalizedS) {
        return new WrappingUnnormalizedProvider(new ConstantSphericalHarmonics(ae, mu, tideSystem, unnormalizedC, unnormalizedS));
    }

    public static UnnormalizedSphericalHarmonicsProvider getUnnormalizedProvider(NormalizedSphericalHarmonicsProvider normalized) {
        return new Unnormalizer(normalized);
    }

    public static double[][] getUnnormalizationFactors(int degree, int order) {
        int rows = degree + 1;
        double[][] factor = new double[rows][];
        factor[0] = new double[]{1.0};
        for (int n = 1; n <= degree; ++n) {
            double[] row = new double[FastMath.min((int)n, (int)order) + 1];
            row[0] = FastMath.sqrt((double)(2 * n + 1));
            double coeff = 2.0 * (double)(2 * n + 1);
            for (int m = 1; m < row.length; ++m) {
                row[m] = FastMath.sqrt((double)(coeff /= (double)((n - m + 1) * (n + m))));
                if (!(row[m] < Precision.SAFE_MIN)) continue;
                throw new OrekitException((Localizable)OrekitMessages.GRAVITY_FIELD_NORMALIZATION_UNDERFLOW, n, m);
            }
            factor[n] = row;
        }
        return factor;
    }
}

