import java.lang
import java.util
import org.orekit.data
import org.orekit.files.ccsds.ndm
import org.orekit.files.ccsds.ndm.odm
import org.orekit.files.ccsds.ndm.odm.omm.class-use
import org.orekit.files.ccsds.section
import org.orekit.files.ccsds.utils
import org.orekit.files.ccsds.utils.generation
import org.orekit.files.ccsds.utils.lexical
import org.orekit.orbits
import org.orekit.propagation
import org.orekit.propagation.analytical.tle
import org.orekit.time
import org.orekit.utils
import typing



class Omm(org.orekit.files.ccsds.ndm.NdmConstituent[org.orekit.files.ccsds.section.Header, org.orekit.files.ccsds.section.Segment['OmmMetadata', 'OmmData']], org.orekit.time.TimeStamped):
    """
    public class Omm extends :class:`~org.orekit.files.ccsds.ndm.NdmConstituent`<:class:`~org.orekit.files.ccsds.section.Header`,:class:`~org.orekit.files.ccsds.section.Segment`<:class:`~org.orekit.files.ccsds.ndm.odm.omm.OmmMetadata`,:class:`~org.orekit.files.ccsds.ndm.odm.omm.OmmData`>> implements :class:`~org.orekit.time.TimeStamped`
    
        This class gathers the informations present in the Orbital Mean-Elements Message (OMM).
    
        Since:
            6.1
    """
    ROOT: typing.ClassVar[str] = ...
    """
    public static final :class:`~org.orekit.files.ccsds.ndm.odm.omm.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is` ROOT
    
        Root element for XML files.
    
        Also see:
            :meth:`~constant`
    
    
    """
    FORMAT_VERSION_KEY: typing.ClassVar[str] = ...
    """
    public static final :class:`~org.orekit.files.ccsds.ndm.odm.omm.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is` FORMAT_VERSION_KEY
    
        Key for format version.
    
        Also see:
            :meth:`~constant`
    
    
    """
    def __init__(self, header: org.orekit.files.ccsds.section.Header, list: java.util.List[org.orekit.files.ccsds.section.Segment['OmmMetadata', 'OmmData']], iERSConventions: org.orekit.utils.IERSConventions, dataContext: org.orekit.data.DataContext): ...
    def generateKeplerianOrbit(self) -> org.orekit.orbits.KeplerianOrbit:
        """
            Generate a keplerian orbit.
        
            Returns:
                generated orbit
        
        
        """
        ...
    def generateSpacecraftState(self) -> org.orekit.propagation.SpacecraftState:
        """
            Generate spacecraft state from the :class:`~org.orekit.orbits.CartesianOrbit` generated by generateCartesianOrbit.
            Raises an exception if OPM doesn't contain spacecraft mass information.
        
            Returns:
                the spacecraft state of the OPM
        
        
        """
        ...
    def generateTLE(self) -> org.orekit.propagation.analytical.tle.TLE:
        """
            Generate TLE from OMM file. Launch Year, Launch Day and Launch Piece are not present in the OMM file, they have to be
            set manually by the user with the AdditionalData static class.
        
            Returns:
                the tle
        
        
        """
        ...
    def getData(self) -> 'OmmData':
        """
            Get the file data.
        
            Returns:
                file data
        
        
        """
        ...
    def getDate(self) -> org.orekit.time.AbsoluteDate:
        """
            Get the date.
        
            Specified by:
                :meth:`~org.orekit.time.TimeStamped.getDate` in interface :class:`~org.orekit.time.TimeStamped`
        
            Returns:
                date attached to the object
        
        
        """
        ...
    def getMetadata(self) -> 'OmmMetadata':
        """
            Get the file metadata.
        
            Returns:
                file metadata
        
        
        """
        ...

class OmmData(org.orekit.files.ccsds.section.Data):
    """
    public class OmmData extends :class:`~org.orekit.files.ccsds.ndm.odm.omm.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object?is` implements :class:`~org.orekit.files.ccsds.section.Data`
    
        Container for Orbit Mean-elements Message data.
    
        Since:
            11.0
    """
    def __init__(self, keplerianElements: org.orekit.files.ccsds.ndm.odm.KeplerianElements, spacecraftParameters: org.orekit.files.ccsds.ndm.odm.SpacecraftParameters, ommTle: 'OmmTle', cartesianCovariance: org.orekit.files.ccsds.ndm.odm.CartesianCovariance, userDefined: org.orekit.files.ccsds.ndm.odm.UserDefined, double: float): ...
    def getCovarianceBlock(self) -> org.orekit.files.ccsds.ndm.odm.CartesianCovariance:
        """
            Get the covariance matrix logical block.
        
            Returns:
                covariance matrix block (may be null)
        
        
        """
        ...
    def getKeplerianElementsBlock(self) -> org.orekit.files.ccsds.ndm.odm.KeplerianElements:
        """
            Get the Keplerian elements logical block.
        
            Returns:
                Keplerian elements block
        
        
        """
        ...
    def getMass(self) -> float:
        """
            Get the mass.
        
            Returns:
                mass
        
        
        """
        ...
    def getSpacecraftParametersBlock(self) -> org.orekit.files.ccsds.ndm.odm.SpacecraftParameters:
        """
            Get the spacecraft parameters logical block.
        
            Returns:
                spacecraft parameters block (may be null)
        
        
        """
        ...
    def getTLEBlock(self) -> 'OmmTle':
        """
            Get the TLE logical block.
        
            Returns:
                TLE block
        
        
        """
        ...
    def getUserDefinedBlock(self) -> org.orekit.files.ccsds.ndm.odm.UserDefined:
        """
            Get the user defined parameters logical block.
        
            Returns:
                user defined parameters block (may be null)
        
        
        """
        ...
    def validate(self, double: float) -> None:
        """
            Check is all mandatory entries have been initialized.
        
            This method should throw an exception if some mandatory entries are missing or not compatible with version number.
        
            Specified by:
                :meth:`~org.orekit.files.ccsds.section.Section.validate` in interface :class:`~org.orekit.files.ccsds.section.Section`
        
            Parameters:
                version (double): format version
        
        
        """
        ...

class OmmMetadata(org.orekit.files.ccsds.ndm.odm.CommonMetadata):
    """
    public class OmmMetadata extends :class:`~org.orekit.files.ccsds.ndm.odm.CommonMetadata`
    """
    SGP_SGP4_THEORY: typing.ClassVar[str] = ...
    """
    public static final :class:`~org.orekit.files.ccsds.ndm.odm.omm.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is` SGP_SGP4_THEORY
    
        Constant for SGP/SGP4 mean elements theory.
    
        Also see:
            :meth:`~constant`
    
    
    """
    DSST_THEORY: typing.ClassVar[str] = ...
    """
    public static final :class:`~org.orekit.files.ccsds.ndm.odm.omm.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is` DSST_THEORY
    
        Constant for DSST mean elements theory.
    
        Also see:
            :meth:`~constant`
    
    
    """
    def __init__(self): ...
    def getMeanElementTheory(self) -> str:
        """
            Get the description of the Mean Element Theory.
        
            Returns:
                the mean element theory
        
        
        """
        ...
    def setMeanElementTheory(self, string: str) -> None:
        """
            Set the description of the Mean Element Theory.
        
            Parameters:
                meanElementTheory (:class:`~org.orekit.files.ccsds.ndm.odm.omm.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is`): the mean element theory to be set
        
        
        """
        ...
    def theoryIsSgpSdp(self) -> bool:
        """
            Check if mean element theory in SGP or SDP.
        
            Returns:
                true if mean element theory in SGP or SDP
        
        
        """
        ...

class OmmMetadataKey(java.lang.Enum['OmmMetadataKey']):
    """
    public enum OmmMetadataKey extends :class:`~org.orekit.files.ccsds.ndm.odm.omm.https:.docs.oracle.com.javase.8.docs.api.java.lang.Enum?is`<:class:`~org.orekit.files.ccsds.ndm.odm.omm.OmmMetadataKey`>
    
        Keys for :class:`~org.orekit.files.ccsds.ndm.odm.omm.OmmMetadata` entries.
    
        Since:
            11.0
    """
    MEAN_ELEMENT_THEORY: typing.ClassVar['OmmMetadataKey'] = ...
    def process(self, parseToken: org.orekit.files.ccsds.utils.lexical.ParseToken, contextBinding: org.orekit.files.ccsds.utils.ContextBinding, ommMetadata: OmmMetadata) -> bool:
        """
            Process one token.
        
            Parameters:
                token (:class:`~org.orekit.files.ccsds.utils.lexical.ParseToken`): token to process
                context (:class:`~org.orekit.files.ccsds.utils.ContextBinding`): context binding
                container (:class:`~org.orekit.files.ccsds.ndm.odm.omm.OmmMetadata`): container to fill
        
            Returns:
                true of token was accepted
        
        
        """
        ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'OmmMetadataKey':
        """
            Returns the enum constant of this type with the specified name. The string must match *exactly* an identifier used to
            declare an enum constant in this type. (Extraneous whitespace characters are not permitted.)
        
            Parameters:
                name (:class:`~org.orekit.files.ccsds.ndm.odm.omm.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is`): the name of the enum constant to be returned.
        
            Returns:
                the enum constant with the specified name
        
            Raises:
                :class:`~org.orekit.files.ccsds.ndm.odm.omm.https:.docs.oracle.com.javase.8.docs.api.java.lang.IllegalArgumentException?is`: if this enum type has no constant with the specified name
                :class:`~org.orekit.files.ccsds.ndm.odm.omm.https:.docs.oracle.com.javase.8.docs.api.java.lang.NullPointerException?is`: if the argument is null
        
        
        """
        ...
    @staticmethod
    def values() -> typing.List['OmmMetadataKey']:
        """
            Returns an array containing the constants of this enum type, in the order they are declared. This method may be used to
            iterate over the constants as follows:
        
            .. code-block: java
            
            for (OmmMetadataKey c : OmmMetadataKey.values())
                System.out.println(c);
            
        
            Returns:
                an array containing the constants of this enum type, in the order they are declared
        
        
        """
        ...

class OmmParser(org.orekit.files.ccsds.ndm.odm.OdmParser[Omm, 'OmmParser']):
    """
    public class OmmParser extends :class:`~org.orekit.files.ccsds.ndm.odm.OdmParser`<:class:`~org.orekit.files.ccsds.ndm.odm.omm.Omm`,:class:`~org.orekit.files.ccsds.ndm.odm.omm.OmmParser`>
    
        A parser for the CCSDS OMM (Orbiter Mean-Elements Message).
    
        Note than starting with Orekit 11.0, CCSDS message parsers are mutable objects that gather the data being parsed, until
        the message is complete and the :meth:`~org.orekit.files.ccsds.utils.parsing.AbstractMessageParser.parseMessage` method
        has returned. This implies that parsers should *not* be used in a multi-thread context. The recommended way to use
        parsers is to either dedicate one parser for each message and drop it afterwards, or to use a single-thread loop.
    
        Since:
            6.1
    """
    def __init__(self, iERSConventions: org.orekit.utils.IERSConventions, boolean: bool, dataContext: org.orekit.data.DataContext, absoluteDate: org.orekit.time.AbsoluteDate, double: float, double2: float, parsedUnitsBehavior: org.orekit.files.ccsds.ndm.ParsedUnitsBehavior): ...
    def build(self) -> Omm:
        """
            Build the file from parsed entries.
        
            Returns:
                parsed file
        
        
        """
        ...
    def finalizeData(self) -> bool:
        """
            Finalize data after parsing.
        
            Specified by:
                :meth:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser.finalizeData` in
                class :class:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser`
        
            Returns:
                true if parser was able to perform the action
        
        
        """
        ...
    def finalizeHeader(self) -> bool:
        """
            Finalize header after parsing.
        
            Specified by:
                :meth:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser.finalizeHeader` in
                class :class:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser`
        
            Returns:
                true if parser was able to perform the action
        
        
        """
        ...
    def finalizeMetadata(self) -> bool:
        """
            Finalize metadata after parsing.
        
            Specified by:
                :meth:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser.finalizeMetadata` in
                class :class:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser`
        
            Returns:
                true if parser was able to perform the action
        
        
        """
        ...
    def getHeader(self) -> org.orekit.files.ccsds.section.Header:
        """
            Get file header to fill.
        
            Specified by:
                :meth:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser.getHeader` in
                class :class:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser`
        
            Returns:
                file header to fill
        
        
        """
        ...
    def getSpecialXmlElementsBuilders(self) -> java.util.Map[str, org.orekit.files.ccsds.utils.lexical.XmlTokenBuilder]: ...
    def inData(self) -> bool:
        """
            Acknowledge data parsing has started.
        
            Specified by:
                :meth:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser.inData` in
                class :class:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser`
        
            Returns:
                true if parser was able to perform the action
        
        
        """
        ...
    def inHeader(self) -> bool:
        """
            Acknowledge header parsing has started.
        
            Specified by:
                :meth:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser.inHeader` in
                class :class:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser`
        
            Returns:
                true if parser was able to perform the action
        
        
        """
        ...
    def inMetadata(self) -> bool:
        """
            Acknowledge metada parsing has started.
        
            Specified by:
                :meth:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser.inMetadata` in
                class :class:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser`
        
            Returns:
                true if parser was able to perform the action
        
        
        """
        ...
    def prepareData(self) -> bool:
        """
            Prepare data for parsing.
        
            Specified by:
                :meth:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser.prepareData` in
                class :class:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser`
        
            Returns:
                true if parser was able to perform the action
        
        
        """
        ...
    def prepareHeader(self) -> bool:
        """
            Prepare header for parsing.
        
            Specified by:
                :meth:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser.prepareHeader` in
                class :class:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser`
        
            Returns:
                true if parser was able to perform the action
        
        
        """
        ...
    def prepareMetadata(self) -> bool:
        """
            Prepare metadata for parsing.
        
            Specified by:
                :meth:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser.prepareMetadata` in
                class :class:`~org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser`
        
            Returns:
                true if parser was able to perform the action
        
        
        """
        ...
    def reset(self, fileFormat: org.orekit.files.ccsds.utils.FileFormat) -> None:
        """
            Reset parser to initial state before parsing.
        
            Parameters:
                fileFormat (:class:`~org.orekit.files.ccsds.utils.FileFormat`): format of the file ready to be parsed
        
        
        """
        ...

class OmmTle(org.orekit.files.ccsds.section.CommentsContainer):
    """
    public class OmmTle extends :class:`~org.orekit.files.ccsds.section.CommentsContainer`
    
        Container for TLE data.
    
        Since:
            6.1
    """
    def __init__(self): ...
    def getBStar(self) -> float:
        """
            Get the SGP/SGP4 drag-like coefficient.
        
            Returns:
                the SGP/SGP4 drag-like coefficient
        
        
        """
        ...
    def getClassificationType(self) -> str:
        """
            Get the classification type.
        
            Returns:
                the classificationType
        
        
        """
        ...
    def getElementSetNumber(self) -> int:
        """
            Get the element set number for this satellite.
        
            Returns:
                the element set number for this satellite
        
        
        """
        ...
    def getEphemerisType(self) -> int:
        """
            Get the ephemeris type.
        
            Returns:
                the ephemerisType
        
        
        """
        ...
    def getMeanMotionDot(self) -> float:
        """
            Get the first time derivative of the mean motion.
        
            Returns:
                the first time derivative of the mean motion
        
        
        """
        ...
    def getMeanMotionDotDot(self) -> float:
        """
            Get the second time derivative of the mean motion.
        
            Returns:
                the second time derivative of the mean motion
        
        
        """
        ...
    def getNoradID(self) -> int:
        """
            Get the NORAD Catalog Number ("Satellite Number").
        
            Returns:
                the NORAD Catalog Number
        
        
        """
        ...
    def getRevAtEpoch(self) -> int:
        """
            Get the revolution rumber.
        
            Returns:
                the revolution rumber
        
        
        """
        ...
    def setBStar(self, double: float) -> None:
        """
            Set the SGP/SGP4 drag-like coefficient.
        
            Parameters:
                bstar (double): the SGP/SGP4 drag-like coefficient to be set
        
        
        """
        ...
    def setClassificationType(self, char: str) -> None:
        """
            Set the classification type.
        
            Parameters:
                classificationType (char): the classification type to be set
        
        
        """
        ...
    def setElementSetNo(self, int: int) -> None:
        """
            Set the element set number for this satellite.
        
            Parameters:
                elementSetNo (int): the element set number to be set
        
        
        """
        ...
    def setEphemerisType(self, int: int) -> None:
        """
            Set the ephemeris type.
        
            Parameters:
                ephemerisType (int): the ephemeris type to be set
        
        
        """
        ...
    def setMeanMotionDot(self, double: float) -> None:
        """
            Set the first time derivative of the mean motion.
        
            Parameters:
                meanMotionDot (double): the first time derivative of the mean motion to be set
        
        
        """
        ...
    def setMeanMotionDotDot(self, double: float) -> None:
        """
            Set the second time derivative of the mean motion.
        
            Parameters:
                meanMotionDotDot (double): the second time derivative of the mean motion to be set
        
        
        """
        ...
    def setNoradID(self, int: int) -> None:
        """
            Set the NORAD Catalog Number ("Satellite Number").
        
            Parameters:
                noradID (int): the element set number to be set
        
        
        """
        ...
    def setRevAtEpoch(self, int: int) -> None:
        """
            Set the revolution rumber.
        
            Parameters:
                revAtEpoch (int): the Revolution Number to be set
        
        
        """
        ...
    def validate(self, double: float) -> None:
        """
            Check is all mandatory entries have been initialized.
        
            This method should throw an exception if some mandatory entries are missing or not compatible with version number.
        
            Specified by:
                :meth:`~org.orekit.files.ccsds.section.Section.validate` in interface :class:`~org.orekit.files.ccsds.section.Section`
        
            Overrides:
                :meth:`~org.orekit.files.ccsds.section.CommentsContainer.validate` in
                class :class:`~org.orekit.files.ccsds.section.CommentsContainer`
        
            Parameters:
                version (double): format version
        
        
        """
        ...

class OmmTleKey(java.lang.Enum['OmmTleKey']):
    """
    public enum OmmTleKey extends :class:`~org.orekit.files.ccsds.ndm.odm.omm.https:.docs.oracle.com.javase.8.docs.api.java.lang.Enum?is`<:class:`~org.orekit.files.ccsds.ndm.odm.omm.OmmTleKey`>
    
        Keys for :class:`~org.orekit.files.ccsds.ndm.odm.omm.OmmTle` entries.
    
        Since:
            11.0
    """
    EPHEMERIS_TYPE: typing.ClassVar['OmmTleKey'] = ...
    CLASSIFICATION_TYPE: typing.ClassVar['OmmTleKey'] = ...
    NORAD_CAT_ID: typing.ClassVar['OmmTleKey'] = ...
    ELEMENT_SET_NO: typing.ClassVar['OmmTleKey'] = ...
    REV_AT_EPOCH: typing.ClassVar['OmmTleKey'] = ...
    BSTAR: typing.ClassVar['OmmTleKey'] = ...
    MEAN_MOTION_DOT: typing.ClassVar['OmmTleKey'] = ...
    MEAN_MOTION_DDOT: typing.ClassVar['OmmTleKey'] = ...
    def process(self, parseToken: org.orekit.files.ccsds.utils.lexical.ParseToken, contextBinding: org.orekit.files.ccsds.utils.ContextBinding, ommTle: OmmTle) -> bool:
        """
            Process one token.
        
            Parameters:
                token (:class:`~org.orekit.files.ccsds.utils.lexical.ParseToken`): token to process
                context (:class:`~org.orekit.files.ccsds.utils.ContextBinding`): context binding
                container (:class:`~org.orekit.files.ccsds.ndm.odm.omm.OmmTle`): container to fill
        
            Returns:
                true of token was accepted
        
        
        """
        ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'OmmTleKey':
        """
            Returns the enum constant of this type with the specified name. The string must match *exactly* an identifier used to
            declare an enum constant in this type. (Extraneous whitespace characters are not permitted.)
        
            Parameters:
                name (:class:`~org.orekit.files.ccsds.ndm.odm.omm.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is`): the name of the enum constant to be returned.
        
            Returns:
                the enum constant with the specified name
        
            Raises:
                :class:`~org.orekit.files.ccsds.ndm.odm.omm.https:.docs.oracle.com.javase.8.docs.api.java.lang.IllegalArgumentException?is`: if this enum type has no constant with the specified name
                :class:`~org.orekit.files.ccsds.ndm.odm.omm.https:.docs.oracle.com.javase.8.docs.api.java.lang.NullPointerException?is`: if the argument is null
        
        
        """
        ...
    @staticmethod
    def values() -> typing.List['OmmTleKey']:
        """
            Returns an array containing the constants of this enum type, in the order they are declared. This method may be used to
            iterate over the constants as follows:
        
            .. code-block: java
            
            for (OmmTleKey c : OmmTleKey.values())
                System.out.println(c);
            
        
            Returns:
                an array containing the constants of this enum type, in the order they are declared
        
        
        """
        ...

class OmmWriter(org.orekit.files.ccsds.utils.generation.AbstractMessageWriter[org.orekit.files.ccsds.section.Header, org.orekit.files.ccsds.section.Segment[OmmMetadata, OmmData], Omm]):
    """
    public class OmmWriter extends :class:`~org.orekit.files.ccsds.utils.generation.AbstractMessageWriter`<:class:`~org.orekit.files.ccsds.section.Header`,:class:`~org.orekit.files.ccsds.section.Segment`<:class:`~org.orekit.files.ccsds.ndm.odm.omm.OmmMetadata`,:class:`~org.orekit.files.ccsds.ndm.odm.omm.OmmData`>,:class:`~org.orekit.files.ccsds.ndm.odm.omm.Omm`>
    
        Writer for CCSDS Orbit Mean Mean-Elements Message.
    
        Since:
            11.0
    """
    CCSDS_OMM_VERS: typing.ClassVar[float] = ...
    """
    public static final double CCSDS_OMM_VERS
    
        Version number implemented.
    
        Also see:
            :meth:`~constant`
    
    
    """
    KVN_PADDING_WIDTH: typing.ClassVar[int] = ...
    """
    public static final int KVN_PADDING_WIDTH
    
        Padding width for aligning the '=' sign.
    
        Also see:
            :meth:`~constant`
    
    
    """
    def __init__(self, iERSConventions: org.orekit.utils.IERSConventions, dataContext: org.orekit.data.DataContext, absoluteDate: org.orekit.time.AbsoluteDate): ...
    def writeSegmentContent(self, generator: org.orekit.files.ccsds.utils.generation.Generator, double: float, segment: org.orekit.files.ccsds.section.Segment[OmmMetadata, OmmData]) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.orekit.files.ccsds.ndm.odm.omm")``.

    Omm: typing.Type[Omm]
    OmmData: typing.Type[OmmData]
    OmmMetadata: typing.Type[OmmMetadata]
    OmmMetadataKey: typing.Type[OmmMetadataKey]
    OmmParser: typing.Type[OmmParser]
    OmmTle: typing.Type[OmmTle]
    OmmTleKey: typing.Type[OmmTleKey]
    OmmWriter: typing.Type[OmmWriter]
    class-use: org.orekit.files.ccsds.ndm.odm.omm.class-use.__module_protocol__
