/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.DecompositionSolver;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;

public class CholeskyDecomposition {
    public static final double DEFAULT_RELATIVE_SYMMETRY_THRESHOLD = 1.0E-15;
    public static final double DEFAULT_ABSOLUTE_POSITIVITY_THRESHOLD = 1.0E-10;
    private final double[][] lTData;
    private RealMatrix cachedL;
    private RealMatrix cachedLT;

    public CholeskyDecomposition(RealMatrix matrix) {
        this(matrix, 1.0E-15, 1.0E-10);
    }

    public CholeskyDecomposition(RealMatrix matrix, double relativeSymmetryThreshold, double absolutePositivityThreshold) {
        int i;
        if (!matrix.isSquare()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_MATRIX, matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int order = matrix.getRowDimension();
        this.lTData = matrix.getData();
        this.cachedL = null;
        this.cachedLT = null;
        for (i = 0; i < order; ++i) {
            double[] lI = this.lTData[i];
            for (int j = i + 1; j < order; ++j) {
                double[] lJ = this.lTData[j];
                double lIJ = lI[j];
                double lJI = lJ[i];
                double maxDelta = relativeSymmetryThreshold * FastMath.max(FastMath.abs(lIJ), FastMath.abs(lJI));
                if (FastMath.abs(lIJ - lJI) > maxDelta) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SYMMETRIC_MATRIX, i, j, relativeSymmetryThreshold);
                }
                lJ[i] = 0.0;
            }
        }
        for (i = 0; i < order; ++i) {
            double[] ltI = this.lTData[i];
            if (ltI[i] <= absolutePositivityThreshold) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.NOT_POSITIVE_DEFINITE_MATRIX, new Object[0]);
            }
            ltI[i] = FastMath.sqrt(ltI[i]);
            double inverse = 1.0 / ltI[i];
            for (int q = order - 1; q > i; --q) {
                int n = q;
                ltI[n] = ltI[n] * inverse;
                double[] ltQ = this.lTData[q];
                for (int p = q; p < order; ++p) {
                    int n2 = p;
                    ltQ[n2] = ltQ[n2] - ltI[q] * ltI[p];
                }
            }
        }
    }

    public RealMatrix getL() {
        if (this.cachedL == null) {
            this.cachedL = this.getLT().transpose();
        }
        return this.cachedL;
    }

    public RealMatrix getLT() {
        if (this.cachedLT == null) {
            this.cachedLT = MatrixUtils.createRealMatrix(this.lTData);
        }
        return this.cachedLT;
    }

    public double getDeterminant() {
        double determinant = 1.0;
        for (int i = 0; i < this.lTData.length; ++i) {
            double lTii = this.lTData[i][i];
            determinant *= lTii * lTii;
        }
        return determinant;
    }

    public DecompositionSolver getSolver() {
        return new Solver();
    }

    private class Solver
    implements DecompositionSolver {
        private Solver() {
        }

        @Override
        public boolean isNonSingular() {
            return true;
        }

        @Override
        public RealVector solve(RealVector b) {
            int j;
            int m = CholeskyDecomposition.this.lTData.length;
            if (b.getDimension() != m) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, b.getDimension(), m);
            }
            double[] x = b.toArray();
            for (j = 0; j < m; ++j) {
                double[] lJ = CholeskyDecomposition.this.lTData[j];
                int n = j;
                x[n] = x[n] / lJ[j];
                double xJ = x[j];
                for (int i = j + 1; i < m; ++i) {
                    int n2 = i;
                    x[n2] = x[n2] - xJ * lJ[i];
                }
            }
            for (j = m - 1; j >= 0; --j) {
                int n = j;
                x[n] = x[n] / CholeskyDecomposition.this.lTData[j][j];
                double xJ = x[j];
                for (int i = 0; i < j; ++i) {
                    int n3 = i;
                    x[n3] = x[n3] - xJ * CholeskyDecomposition.this.lTData[i][j];
                }
            }
            return new ArrayRealVector(x, false);
        }

        @Override
        public RealMatrix solve(RealMatrix b) {
            int j;
            int m = CholeskyDecomposition.this.lTData.length;
            if (b.getRowDimension() != m) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, b.getRowDimension(), m);
            }
            int nColB = b.getColumnDimension();
            double[][] x = b.getData();
            for (j = 0; j < m; ++j) {
                double[] lJ = CholeskyDecomposition.this.lTData[j];
                double lJJ = lJ[j];
                double[] xJ = x[j];
                int k = 0;
                while (k < nColB) {
                    int n = k++;
                    xJ[n] = xJ[n] / lJJ;
                }
                for (int i = j + 1; i < m; ++i) {
                    double[] xI = x[i];
                    double lJI = lJ[i];
                    for (int k2 = 0; k2 < nColB; ++k2) {
                        int n = k2;
                        xI[n] = xI[n] - xJ[k2] * lJI;
                    }
                }
            }
            for (j = m - 1; j >= 0; --j) {
                double lJJ = CholeskyDecomposition.this.lTData[j][j];
                double[] xJ = x[j];
                int k = 0;
                while (k < nColB) {
                    int n = k++;
                    xJ[n] = xJ[n] / lJJ;
                }
                for (int i = 0; i < j; ++i) {
                    double[] xI = x[i];
                    double lIJ = CholeskyDecomposition.this.lTData[i][j];
                    for (int k3 = 0; k3 < nColB; ++k3) {
                        int n = k3;
                        xI[n] = xI[n] - xJ[k3] * lIJ;
                    }
                }
            }
            return new Array2DRowRealMatrix(x);
        }

        @Override
        public RealMatrix getInverse() {
            return this.solve(MatrixUtils.createRealIdentityMatrix(CholeskyDecomposition.this.lTData.length));
        }

        @Override
        public int getRowDimension() {
            return CholeskyDecomposition.this.lTData.length;
        }

        @Override
        public int getColumnDimension() {
            return CholeskyDecomposition.this.lTData[0].length;
        }
    }
}

