/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitIllegalStateException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.TimeStampedCacheException;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.GenericTimeStampedCache;
import org.orekit.utils.TimeStampedCache;
import org.orekit.utils.TimeStampedGenerator;

public class GenericTimeStampedCache<T extends TimeStamped>
implements TimeStampedCache<T> {
    public static final int DEFAULT_CACHED_SLOTS_NUMBER = 10;
    private static final double QUANTUM_STEP = 1.0E-6;
    private final AtomicReference<AbsoluteDate> reference;
    private final int maxSlots;
    private final double maxSpan;
    private final long newSlotQuantumGap;
    private final TimeStampedGenerator<T> generator;
    private final int neighborsSize;
    private final List<Slot> slots;
    private final AtomicInteger getNeighborsCalls;
    private final AtomicInteger generateCalls;
    private final AtomicInteger evictions;
    private final ReadWriteLock lock;

    public GenericTimeStampedCache(int neighborsSize, int maxSlots, double maxSpan, double newSlotInterval, TimeStampedGenerator<T> generator) {
        if (maxSlots < 1) {
            throw new OrekitIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL, maxSlots, 1);
        }
        if (neighborsSize < 2) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NOT_ENOUGH_CACHED_NEIGHBORS, neighborsSize, 2);
        }
        this.reference = new AtomicReference();
        this.maxSlots = maxSlots;
        this.maxSpan = maxSpan;
        this.newSlotQuantumGap = FastMath.round((double)(newSlotInterval / 1.0E-6));
        this.generator = generator;
        this.neighborsSize = neighborsSize;
        this.slots = new ArrayList<Slot>(maxSlots);
        this.getNeighborsCalls = new AtomicInteger(0);
        this.generateCalls = new AtomicInteger(0);
        this.evictions = new AtomicInteger(0);
        this.lock = new ReentrantReadWriteLock();
    }

    public TimeStampedGenerator<T> getGenerator() {
        return this.generator;
    }

    public int getMaxSlots() {
        return this.maxSlots;
    }

    public double getMaxSpan() {
        return this.maxSpan;
    }

    public double getNewSlotQuantumGap() {
        return (double)this.newSlotQuantumGap * 1.0E-6;
    }

    public int getGetNeighborsCalls() {
        return this.getNeighborsCalls.get();
    }

    public int getGenerateCalls() {
        return this.generateCalls.get();
    }

    public int getSlotsEvictions() {
        return this.evictions.get();
    }

    public int getSlots() {
        this.lock.readLock().lock();
        try {
            int n = this.slots.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntries() {
        this.lock.readLock().lock();
        try {
            int entries = 0;
            for (Slot slot : this.slots) {
                entries += slot.getEntries();
            }
            int n = entries;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T getEarliest() throws IllegalStateException {
        this.lock.readLock().lock();
        try {
            if (this.slots.isEmpty()) {
                throw new OrekitIllegalStateException(OrekitMessages.NO_CACHED_ENTRIES, new Object[0]);
            }
            Object t = this.slots.get(0).getEarliest();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T getLatest() throws IllegalStateException {
        this.lock.readLock().lock();
        try {
            if (this.slots.isEmpty()) {
                throw new OrekitIllegalStateException(OrekitMessages.NO_CACHED_ENTRIES, new Object[0]);
            }
            Object t = this.slots.get(this.slots.size() - 1).getLatest();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int getNeighborsSize() {
        return this.neighborsSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<T> getNeighbors(AbsoluteDate central) {
        this.lock.readLock().lock();
        try {
            this.getNeighborsCalls.incrementAndGet();
            long dateQuantum = this.quantum(central);
            Stream stream = this.selectSlot(central, dateQuantum).getNeighbors(central, dateQuantum);
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private long quantum(AbsoluteDate date) {
        this.reference.compareAndSet(null, date);
        return FastMath.round((double)(date.durationFrom(this.reference.get()) / 1.0E-6));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Slot selectSlot(AbsoluteDate date, long dateQuantum) {
        int index;
        Slot selected = null;
        int n = index = this.slots.isEmpty() ? 0 : this.slotIndex(dateQuantum);
        if (this.slots.isEmpty() || this.slots.get(index).getEarliestQuantum() > dateQuantum + this.newSlotQuantumGap || this.slots.get(index).getLatestQuantum() < dateQuantum - this.newSlotQuantumGap) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                int n2 = index = this.slots.isEmpty() ? 0 : this.slotIndex(dateQuantum);
                if (this.slots.isEmpty() || this.slots.get(index).getEarliestQuantum() > dateQuantum + this.newSlotQuantumGap || this.slots.get(index).getLatestQuantum() < dateQuantum - this.newSlotQuantumGap) {
                    if (!this.slots.isEmpty() && this.slots.get(index).getLatestQuantum() < dateQuantum - this.newSlotQuantumGap) {
                        ++index;
                    }
                    if (this.slots.size() >= this.maxSlots) {
                        int evict = 0;
                        for (int i = 0; i < this.slots.size(); ++i) {
                            if (this.slots.get(i).getLastAccess() >= this.slots.get(evict).getLastAccess()) continue;
                            evict = i;
                        }
                        this.evictions.incrementAndGet();
                        this.slots.remove(evict);
                        if (evict < index) {
                            --index;
                        }
                    }
                    this.slots.add(index, new Slot(date));
                }
            }
            finally {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
        selected = this.slots.get(index);
        return selected;
    }

    private int slotIndex(long dateQuantum) {
        int iInf = 0;
        long qInf = this.slots.get(iInf).getEarliestQuantum();
        int iSup = this.slots.size() - 1;
        long qSup = this.slots.get(iSup).getLatestQuantum();
        while (iSup - iInf > 0) {
            int iInterp = (int)(((long)iInf * (qSup - dateQuantum) + (long)iSup * (dateQuantum - qInf)) / (qSup - qInf));
            int iMed = FastMath.max((int)iInf, (int)FastMath.min((int)iInterp, (int)iSup));
            Slot slot = this.slots.get(iMed);
            if (dateQuantum < slot.getEarliestQuantum()) {
                iSup = iMed - 1;
                continue;
            }
            if (dateQuantum > slot.getLatestQuantum()) {
                iInf = FastMath.min((int)iSup, (int)(iMed + 1));
                continue;
            }
            return iMed;
        }
        return iInf;
    }

    private final class Slot {
        private final List<org.orekit.utils.GenericTimeStampedCache$Slot.Entry> cache = new ArrayList<org.orekit.utils.GenericTimeStampedCache$Slot.Entry>();
        private AtomicLong earliestQuantum;
        private AtomicLong latestQuantum;
        private AtomicInteger guessedIndex;
        private AtomicLong lastAccess;

        Slot(AbsoluteDate date) {
            AbsoluteDate generationDate = date;
            GenericTimeStampedCache.this.generateCalls.incrementAndGet();
            for (TimeStamped entry : this.generateAndCheck(null, generationDate)) {
                this.cache.add((org.orekit.utils.GenericTimeStampedCache$Slot.Entry)new Entry(this, entry, GenericTimeStampedCache.this.quantum(entry.getDate())));
            }
            this.earliestQuantum = new AtomicLong(((Entry)this.cache.get(0)).getQuantum());
            this.latestQuantum = new AtomicLong(((Entry)this.cache.get(this.cache.size() - 1)).getQuantum());
            while (this.cache.size() < GenericTimeStampedCache.this.neighborsSize) {
                AbsoluteDate existingDate;
                AbsoluteDate entry0 = ((Entry)this.cache.get(0)).getData().getDate();
                AbsoluteDate entryN = ((Entry)this.cache.get(this.cache.size() - 1)).getData().getDate();
                GenericTimeStampedCache.this.generateCalls.incrementAndGet();
                if (entryN.getDate().durationFrom(date) <= date.durationFrom(entry0.getDate())) {
                    existingDate = entryN;
                    generationDate = entryN.getDate().shiftedBy(this.getMeanStep() * (double)(GenericTimeStampedCache.this.neighborsSize - this.cache.size()));
                    this.appendAtEnd(this.generateAndCheck(existingDate, generationDate), date);
                    continue;
                }
                existingDate = entry0;
                generationDate = entry0.getDate().shiftedBy(-this.getMeanStep() * (double)(GenericTimeStampedCache.this.neighborsSize - this.cache.size()));
                this.insertAtStart(this.generateAndCheck(existingDate, generationDate), date);
            }
            this.guessedIndex = new AtomicInteger(this.cache.size() / 2);
            this.lastAccess = new AtomicLong(System.currentTimeMillis());
        }

        public T getEarliest() {
            return ((Entry)this.cache.get(0)).getData();
        }

        public long getEarliestQuantum() {
            return this.earliestQuantum.get();
        }

        public T getLatest() {
            return ((Entry)this.cache.get(this.cache.size() - 1)).getData();
        }

        public long getLatestQuantum() {
            return this.latestQuantum.get();
        }

        public int getEntries() {
            return this.cache.size();
        }

        private double getMeanStep() {
            if (this.cache.size() < 2) {
                return 1.0;
            }
            AbsoluteDate t0 = ((Entry)this.cache.get(0)).getData().getDate();
            AbsoluteDate tn = ((Entry)this.cache.get(this.cache.size() - 1)).getData().getDate();
            return tn.durationFrom(t0) / (double)(this.cache.size() - 1);
        }

        public long getLastAccess() {
            return this.lastAccess.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Stream<T> getNeighbors(AbsoluteDate central, long dateQuantum) {
            int index = this.entryIndex(central, dateQuantum);
            int firstNeighbor = index - (GenericTimeStampedCache.this.neighborsSize - 1) / 2;
            if (firstNeighbor < 0 || firstNeighbor + GenericTimeStampedCache.this.neighborsSize > this.cache.size()) {
                GenericTimeStampedCache.this.lock.readLock().unlock();
                GenericTimeStampedCache.this.lock.writeLock().lock();
                try {
                    boolean loop = true;
                    while (loop) {
                        index = this.entryIndex(central, dateQuantum);
                        firstNeighbor = index - (GenericTimeStampedCache.this.neighborsSize - 1) / 2;
                        if (firstNeighbor < 0 || firstNeighbor + GenericTimeStampedCache.this.neighborsSize > this.cache.size()) {
                            boolean simplyRebalance;
                            AbsoluteDate generationDate;
                            AbsoluteDate existingDate;
                            double step = this.getMeanStep();
                            if (firstNeighbor < 0) {
                                existingDate = ((Entry)this.cache.get(0)).getData().getDate();
                                generationDate = existingDate.getDate().shiftedBy(step * (double)firstNeighbor);
                                simplyRebalance = existingDate.getDate().compareTo(central) <= 0;
                            } else {
                                existingDate = ((Entry)this.cache.get(this.cache.size() - 1)).getData().getDate();
                                generationDate = existingDate.getDate().shiftedBy(step * (double)(firstNeighbor + GenericTimeStampedCache.this.neighborsSize - this.cache.size()));
                                simplyRebalance = existingDate.getDate().compareTo(central) >= 0;
                            }
                            GenericTimeStampedCache.this.generateCalls.incrementAndGet();
                            try {
                                if (firstNeighbor < 0) {
                                    this.insertAtStart(this.generateAndCheck(existingDate, generationDate), central);
                                    continue;
                                }
                                this.appendAtEnd(this.generateAndCheck(existingDate, generationDate), central);
                                continue;
                            }
                            catch (TimeStampedCacheException tce) {
                                if (simplyRebalance) {
                                    loop = false;
                                    continue;
                                }
                                throw tce;
                            }
                        }
                        loop = false;
                    }
                }
                finally {
                    GenericTimeStampedCache.this.lock.readLock().lock();
                    GenericTimeStampedCache.this.lock.writeLock().unlock();
                }
            }
            if (firstNeighbor + GenericTimeStampedCache.this.neighborsSize > this.cache.size()) {
                firstNeighbor = this.cache.size() - GenericTimeStampedCache.this.neighborsSize;
            }
            if (firstNeighbor < 0) {
                firstNeighbor = 0;
            }
            Stream.Builder builder = Stream.builder();
            for (int i = 0; i < GenericTimeStampedCache.this.neighborsSize; ++i) {
                builder.accept(((Entry)this.cache.get(firstNeighbor + i)).getData());
            }
            return builder.build();
        }

        private int entryIndex(AbsoluteDate date, long dateQuantum) {
            int guess = this.guessedIndex.get();
            if (guess > 0 && guess < this.cache.size()) {
                if (((Entry)this.cache.get(guess)).getQuantum() <= dateQuantum) {
                    if (guess + 1 < this.cache.size() && ((Entry)this.cache.get(guess + 1)).getQuantum() > dateQuantum) {
                        return guess;
                    }
                    if (guess + 2 < this.cache.size() && ((Entry)this.cache.get(guess + 2)).getQuantum() > dateQuantum) {
                        this.guessedIndex.set(guess + 1);
                        return guess + 1;
                    }
                } else if (guess > 1 && ((Entry)this.cache.get(guess - 1)).getQuantum() <= dateQuantum) {
                    this.guessedIndex.set(guess - 1);
                    return guess - 1;
                }
            }
            if (dateQuantum < this.getEarliestQuantum()) {
                return -1;
            }
            if (dateQuantum > this.getLatestQuantum()) {
                return this.cache.size();
            }
            int iInf = 0;
            long qInf = ((Entry)this.cache.get(iInf)).getQuantum();
            int iSup = this.cache.size() - 1;
            long qSup = ((Entry)this.cache.get(iSup)).getQuantum();
            while (iSup - iInf > 0) {
                int iInterp = (int)(((long)iInf * (qSup - dateQuantum) + (long)iSup * (dateQuantum - qInf)) / (qSup - qInf));
                int iMed = FastMath.max((int)(iInf + 1), (int)FastMath.min((int)iInterp, (int)iSup));
                Entry entry = (Entry)this.cache.get(iMed);
                if (dateQuantum < entry.getQuantum()) {
                    iSup = iMed - 1;
                    continue;
                }
                if (dateQuantum > entry.getQuantum()) {
                    iInf = iMed;
                    continue;
                }
                this.guessedIndex.set(iMed);
                return iMed;
            }
            this.guessedIndex.set(iInf);
            return iInf;
        }

        private void insertAtStart(List<T> data, AbsoluteDate requestedDate) {
            long quantum;
            boolean inserted = false;
            long q0 = this.earliestQuantum.get();
            for (int i = 0; i < data.size() && (quantum = GenericTimeStampedCache.this.quantum(((TimeStamped)data.get(i)).getDate())) < q0; ++i) {
                this.cache.add(i, (org.orekit.utils.GenericTimeStampedCache$Slot.Entry)new Entry(this, (TimeStamped)data.get(i), quantum));
                inserted = true;
            }
            if (!inserted) {
                AbsoluteDate earliest = ((Entry)this.cache.get(0)).getData().getDate();
                throw new TimeStampedCacheException((Localizable)OrekitMessages.UNABLE_TO_GENERATE_NEW_DATA_BEFORE, earliest, requestedDate, earliest.durationFrom(requestedDate));
            }
            AbsoluteDate t0 = ((Entry)this.cache.get(0)).getData().getDate();
            while (this.cache.size() > GenericTimeStampedCache.this.neighborsSize && ((Entry)this.cache.get(this.cache.size() - 1)).getData().getDate().durationFrom(t0) > GenericTimeStampedCache.this.maxSpan) {
                this.cache.remove(this.cache.size() - 1);
            }
            this.earliestQuantum.set(((Entry)this.cache.get(0)).getQuantum());
            this.latestQuantum.set(((Entry)this.cache.get(this.cache.size() - 1)).getQuantum());
        }

        private void appendAtEnd(List<T> data, AbsoluteDate requestedDate) {
            long quantum;
            boolean appended = false;
            long qn = this.latestQuantum.get();
            int n = this.cache.size();
            for (int i = data.size() - 1; i >= 0 && (quantum = GenericTimeStampedCache.this.quantum(((TimeStamped)data.get(i)).getDate())) > qn; --i) {
                this.cache.add(n, (org.orekit.utils.GenericTimeStampedCache$Slot.Entry)new Entry(this, (TimeStamped)data.get(i), quantum));
                appended = true;
            }
            if (!appended) {
                AbsoluteDate latest = ((Entry)this.cache.get(this.cache.size() - 1)).getData().getDate();
                throw new TimeStampedCacheException((Localizable)OrekitMessages.UNABLE_TO_GENERATE_NEW_DATA_AFTER, latest, requestedDate, requestedDate.durationFrom(latest));
            }
            AbsoluteDate tn = ((Entry)this.cache.get(this.cache.size() - 1)).getData().getDate();
            while (this.cache.size() > GenericTimeStampedCache.this.neighborsSize && tn.durationFrom(((Entry)this.cache.get(0)).getData().getDate()) > GenericTimeStampedCache.this.maxSpan) {
                this.cache.remove(0);
            }
            this.earliestQuantum.set(((Entry)this.cache.get(0)).getQuantum());
            this.latestQuantum.set(((Entry)this.cache.get(this.cache.size() - 1)).getQuantum());
        }

        private List<T> generateAndCheck(AbsoluteDate existingDate, AbsoluteDate date) {
            List entries = GenericTimeStampedCache.this.generator.generate(existingDate, date);
            if (entries.isEmpty()) {
                throw new TimeStampedCacheException((Localizable)OrekitMessages.NO_DATA_GENERATED, date);
            }
            for (int i = 1; i < entries.size(); ++i) {
                AbsoluteDate previous = ((TimeStamped)entries.get(i - 1)).getDate();
                AbsoluteDate current = ((TimeStamped)entries.get(i)).getDate();
                if (current.compareTo(previous) >= 0) continue;
                throw new TimeStampedCacheException((Localizable)OrekitMessages.NON_CHRONOLOGICALLY_SORTED_ENTRIES, previous, current, previous.durationFrom(current));
            }
            return entries;
        }

        private class Entry {
            private final T data;
            private final long quantum;
            final /* synthetic */ Slot this$1;

            /*
             * WARNING - Possible parameter corruption
             * WARNING - void declaration
             */
            Entry(T quantum, long l2) {
                void data;
                this.this$1 = (Slot)l;
                this.quantum = (long)quantum;
                this.data = data;
            }

            public long getQuantum() {
                return this.quantum;
            }

            public T getData() {
                return this.data;
            }
        }
    }
}

