/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AbstractGradientConverter;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

class DSSTGradientConverter
extends AbstractGradientConverter {
    private static final int FREE_STATE_PARAMETERS = 6;
    private final List<FieldSpacecraftState<Gradient>> gStates;

    DSSTGradientConverter(SpacecraftState state, AttitudeProvider provider) {
        super(6);
        Gradient sma = Gradient.variable((int)6, (int)0, (double)state.getA());
        Gradient ex = Gradient.variable((int)6, (int)1, (double)state.getEquinoctialEx());
        Gradient ey = Gradient.variable((int)6, (int)2, (double)state.getEquinoctialEy());
        Gradient hx = Gradient.variable((int)6, (int)3, (double)state.getHx());
        Gradient hy = Gradient.variable((int)6, (int)4, (double)state.getHy());
        Gradient l = Gradient.variable((int)6, (int)5, (double)state.getLM());
        Gradient gMu = Gradient.constant((int)6, (double)state.getMu());
        AbsoluteDate date = state.getDate();
        FieldAbsoluteDate dateField = new FieldAbsoluteDate(sma.getField(), date);
        Gradient gM = Gradient.constant((int)6, (double)state.getMass());
        FieldEquinoctialOrbit<Gradient> gOrbit = new FieldEquinoctialOrbit<Gradient>(sma, ex, ey, hx, hy, l, PositionAngle.MEAN, state.getFrame(), dateField, gMu);
        FieldAttitude<Gradient> gAttitude = provider.getAttitude(gOrbit, gOrbit.getDate(), gOrbit.getFrame());
        this.gStates = new ArrayList<FieldSpacecraftState<Gradient>>();
        this.gStates.add(new FieldSpacecraftState<Gradient>(gOrbit, gAttitude, gM));
    }

    public FieldSpacecraftState<Gradient> getState(DSSTForceModel forceModel) {
        int nbParams = 0;
        for (ParameterDriver driver : forceModel.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            ++nbParams;
        }
        while (this.gStates.size() < nbParams + 1) {
            this.gStates.add(null);
        }
        if (this.gStates.get(nbParams) == null) {
            int freeParameters = 6 + nbParams;
            FieldSpacecraftState<Gradient> s0 = this.gStates.get(0);
            FieldAbsoluteDate date = new FieldAbsoluteDate(GradientField.getField((int)freeParameters), s0.getDate().toAbsoluteDate());
            FieldEquinoctialOrbit<Gradient> gOrbit = new FieldEquinoctialOrbit<Gradient>(this.extend(s0.getA(), freeParameters), this.extend(s0.getEquinoctialEx(), freeParameters), this.extend(s0.getEquinoctialEy(), freeParameters), this.extend(s0.getHx(), freeParameters), this.extend(s0.getHy(), freeParameters), this.extend(s0.getLM(), freeParameters), PositionAngle.MEAN, s0.getFrame(), date, this.extend(s0.getMu(), freeParameters));
            TimeStampedFieldAngularCoordinates<Gradient> ac0 = s0.getAttitude().getOrientation();
            FieldAttitude<Gradient> gAttitude = new FieldAttitude<Gradient>(s0.getAttitude().getReferenceFrame(), new TimeStampedFieldAngularCoordinates<Gradient>(gOrbit.getDate(), this.extend(ac0.getRotation(), freeParameters), this.extend(ac0.getRotationRate(), freeParameters), this.extend(ac0.getRotationAcceleration(), freeParameters)));
            Gradient gM = this.extend(s0.getMass(), freeParameters);
            this.gStates.set(nbParams, new FieldSpacecraftState<Gradient>(gOrbit, gAttitude, gM));
        }
        return this.gStates.get(nbParams);
    }

    public Gradient[] getParameters(FieldSpacecraftState<Gradient> state, DSSTForceModel forceModel) {
        int freeParameters = state.getA().getFreeParameters();
        List<ParameterDriver> drivers = forceModel.getParametersDrivers();
        Gradient[] parameters = new Gradient[drivers.size()];
        int index = 6;
        int i = 0;
        for (ParameterDriver driver : drivers) {
            parameters[i++] = driver.isSelected() ? Gradient.variable((int)freeParameters, (int)index++, (double)driver.getValue()) : Gradient.constant((int)freeParameters, (double)driver.getValue());
        }
        return parameters;
    }
}

