/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.FieldTLE;
import org.orekit.propagation.analytical.tle.FieldTLEPropagator;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.propagation.integration.AbstractGradientConverter;
import org.orekit.time.TimeScale;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

class TLEGradientConverter
extends AbstractGradientConverter {
    public static final int FREE_STATE_PARAMETERS = 6;
    private final TLE tle;
    private final TimeScale utc;
    private final Frame teme;
    private final AttitudeProvider provider;
    private final List<FieldSpacecraftState<Gradient>> gStates;

    TLEGradientConverter(TLEPropagator propagator) {
        super(6);
        this.tle = propagator.getTLE();
        this.teme = propagator.getFrame();
        this.utc = this.tle.getUtc();
        this.provider = propagator.getAttitudeProvider();
        SpacecraftState state = propagator.getInitialState();
        Vector3D pos = state.getPVCoordinates().getPosition();
        FieldVector3D posG = new FieldVector3D((CalculusFieldElement)Gradient.variable((int)6, (int)0, (double)pos.getX()), (CalculusFieldElement)Gradient.variable((int)6, (int)1, (double)pos.getY()), (CalculusFieldElement)Gradient.variable((int)6, (int)2, (double)pos.getZ()));
        Vector3D vel = state.getPVCoordinates().getVelocity();
        FieldVector3D velG = new FieldVector3D((CalculusFieldElement)Gradient.variable((int)6, (int)3, (double)vel.getX()), (CalculusFieldElement)Gradient.variable((int)6, (int)4, (double)vel.getY()), (CalculusFieldElement)Gradient.variable((int)6, (int)5, (double)vel.getZ()));
        Vector3D acc = state.getPVCoordinates().getAcceleration();
        FieldVector3D accG = new FieldVector3D((CalculusFieldElement)Gradient.constant((int)6, (double)acc.getX()), (CalculusFieldElement)Gradient.constant((int)6, (double)acc.getY()), (CalculusFieldElement)Gradient.constant((int)6, (double)acc.getZ()));
        Gradient gM = Gradient.constant((int)6, (double)state.getMass());
        Gradient gMu = Gradient.constant((int)6, (double)TLEPropagator.getMU());
        FieldCartesianOrbit<Gradient> gOrbit = new FieldCartesianOrbit<Gradient>(new TimeStampedFieldPVCoordinates(state.getDate(), posG, velG, accG), state.getFrame(), gMu);
        FieldAttitude<Gradient> gAttitude = this.provider.getAttitude(gOrbit, gOrbit.getDate(), gOrbit.getFrame());
        this.gStates = new ArrayList<FieldSpacecraftState<Gradient>>();
        this.gStates.add(new FieldSpacecraftState<Gradient>(gOrbit, gAttitude, gM));
    }

    public FieldSpacecraftState<Gradient> getState() {
        int nbParams = 0;
        for (ParameterDriver driver : this.tle.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            ++nbParams;
        }
        while (this.gStates.size() < nbParams + 1) {
            this.gStates.add(null);
        }
        if (this.gStates.get(nbParams) == null) {
            int freeParameters = 6 + nbParams;
            FieldSpacecraftState<Gradient> s0 = this.gStates.get(0);
            TimeStampedFieldPVCoordinates<Gradient> pv0 = s0.getPVCoordinates();
            FieldCartesianOrbit<Gradient> gOrbit = new FieldCartesianOrbit<Gradient>(new TimeStampedFieldPVCoordinates<Gradient>(s0.getDate().toAbsoluteDate(), this.extend(pv0.getPosition(), freeParameters), this.extend(pv0.getVelocity(), freeParameters), this.extend(pv0.getAcceleration(), freeParameters)), s0.getFrame(), this.extend(s0.getMu(), freeParameters));
            TimeStampedFieldAngularCoordinates<Gradient> ac0 = s0.getAttitude().getOrientation();
            FieldAttitude<Gradient> gAttitude = new FieldAttitude<Gradient>(s0.getAttitude().getReferenceFrame(), new TimeStampedFieldAngularCoordinates<Gradient>(gOrbit.getDate(), this.extend(ac0.getRotation(), freeParameters), this.extend(ac0.getRotationRate(), freeParameters), this.extend(ac0.getRotationAcceleration(), freeParameters)));
            Gradient gM = this.extend(s0.getMass(), freeParameters);
            this.gStates.set(nbParams, new FieldSpacecraftState<Gradient>(gOrbit, gAttitude, gM));
        }
        return this.gStates.get(nbParams);
    }

    public Gradient[] getParameters(FieldSpacecraftState<Gradient> state) {
        int freeParameters = state.getMass().getFreeParameters();
        List<ParameterDriver> drivers = this.tle.getParametersDrivers();
        Gradient[] parameters = new Gradient[drivers.size()];
        int index = 6;
        int i = 0;
        for (ParameterDriver driver : drivers) {
            parameters[i++] = driver.isSelected() ? Gradient.variable((int)freeParameters, (int)index++, (double)driver.getValue()) : Gradient.constant((int)freeParameters, (double)driver.getValue());
        }
        return parameters;
    }

    public FieldTLEPropagator<Gradient> getPropagator(FieldSpacecraftState<Gradient> state, Gradient[] parameters) {
        Gradient zero = state.getA().getField().getZero();
        int satelliteNumber = this.tle.getSatelliteNumber();
        char classification = this.tle.getClassification();
        int launchYear = this.tle.getLaunchYear();
        int launchNumber = this.tle.getLaunchNumber();
        String launchPiece = this.tle.getLaunchPiece();
        int ephemerisType = this.tle.getEphemerisType();
        int elementNumber = this.tle.getElementNumber();
        int revolutionNumberAtEpoch = this.tle.getRevolutionNumberAtEpoch();
        double bStar = this.tle.getBStar();
        FieldTLE<Gradient> templateTLE = new FieldTLE<Gradient>(satelliteNumber, classification, launchYear, launchNumber, launchPiece, ephemerisType, elementNumber, state.getDate(), zero, zero, zero, zero, zero, zero, zero, zero, revolutionNumberAtEpoch, bStar, this.utc);
        FieldTLE<Gradient> gTLE = FieldTLE.stateToTLE(state, templateTLE, this.utc, this.teme);
        return FieldTLEPropagator.selectExtrapolator(gTLE, (AttitudeProvider)this.provider, (CalculusFieldElement)state.getMass(), (Frame)this.teme, (CalculusFieldElement[])parameters);
    }
}

