/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.MultiSatStepHandler;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public class PropagatorsParallelizer {
    private static long MAX_WAIT = 10L;
    private final List<Propagator> propagators;
    private final MultiSatStepHandler globalHandler;

    public PropagatorsParallelizer(List<Propagator> propagators, MultiSatStepHandler globalHandler) {
        this.propagators = propagators;
        this.globalHandler = globalHandler;
    }

    public List<Propagator> getPropagators() {
        return Collections.unmodifiableList(this.propagators);
    }

    public List<SpacecraftState> propagate(AbsoluteDate start, AbsoluteDate target) {
        if (this.propagators.size() == 1) {
            this.propagators.get(0).setStepHandler(new SinglePropagatorHandler(this.globalHandler));
            return Collections.singletonList(this.propagators.get(0).propagate(start, target));
        }
        double sign = FastMath.copySign((double)1.0, (double)target.durationFrom(start));
        ExecutorService executorService = Executors.newFixedThreadPool(this.propagators.size());
        ArrayList<PropagatorMonitoring> monitors = new ArrayList<PropagatorMonitoring>(this.propagators.size());
        for (Propagator propagator : this.propagators) {
            PropagatorMonitoring monitor = new PropagatorMonitoring(propagator, start, target, executorService);
            monitor.waitFirstStepCompletion();
            monitors.add(monitor);
        }
        AbsoluteDate previousDate = start;
        this.globalHandler.init(monitors.stream().map(m -> ((PropagatorMonitoring)m).parameters.initialState).collect(Collectors.toList()), target);
        boolean isLast = false;
        while (!isLast) {
            PropagatorMonitoring selected = null;
            AbsoluteDate selectedStepEnd = null;
            for (PropagatorMonitoring monitor : monitors) {
                AbsoluteDate stepEnd = monitor.parameters.interpolator.getCurrentState().getDate();
                if (selected != null && !(sign * selectedStepEnd.durationFrom(stepEnd) > 0.0)) continue;
                selected = monitor;
                selectedStepEnd = stepEnd;
            }
            for (PropagatorMonitoring monitor : monitors) {
                OrekitStepInterpolator interpolator = monitor.parameters.interpolator;
                SpacecraftState previousState = interpolator.getInterpolatedState(previousDate);
                SpacecraftState currentState = interpolator.getInterpolatedState(selectedStepEnd);
                monitor.restricted = interpolator.restrictStep(previousState, currentState);
            }
            this.globalHandler.handleStep(monitors.stream().map(m -> ((PropagatorMonitoring)m).restricted).collect(Collectors.toList()));
            if (selected.parameters.finalState == null) {
                selected.retrieveNextParameters();
            } else {
                isLast = true;
            }
            previousDate = selectedStepEnd;
        }
        executorService.shutdownNow();
        ArrayList<SpacecraftState> finalStates = new ArrayList<SpacecraftState>(monitors.size());
        for (PropagatorMonitoring monitor : monitors) {
            try {
                finalStates.add((SpacecraftState)monitor.future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                monitor.manageException(e);
                finalStates.add(monitor.parameters.interpolator.getInterpolatedState(previousDate));
            }
        }
        this.globalHandler.finish(finalStates);
        return finalStates;
    }

    private static class PropagatorMonitoring {
        private final SynchronousQueue<ParametersContainer> queue = new SynchronousQueue();
        private final Future<SpacecraftState> future;
        private ParametersContainer parameters;
        private OrekitStepInterpolator restricted;

        PropagatorMonitoring(Propagator propagator, AbsoluteDate start, AbsoluteDate target, ExecutorService executorService) {
            propagator.setStepHandler(new MultiplePropagatorsHandler(this.queue));
            this.future = executorService.submit(() -> propagator.propagate(start, target));
        }

        public void waitFirstStepCompletion() {
            while (this.parameters == null || this.parameters.initialState == null || this.parameters.interpolator == null) {
                this.retrieveNextParameters();
            }
        }

        public void retrieveNextParameters() {
            try {
                ParametersContainer params = null;
                while (params == null && !this.future.isDone()) {
                    params = this.queue.poll(MAX_WAIT, TimeUnit.MILLISECONDS);
                }
                if (params == null) {
                    this.future.get();
                }
                this.parameters = params;
            }
            catch (InterruptedException | ExecutionException e) {
                this.manageException(e);
                this.parameters = null;
            }
        }

        private void manageException(Exception exception) {
            if (exception.getCause() instanceof PropagatorStoppingException) {
                return;
            }
            if (exception.getCause() instanceof OrekitException) {
                throw (OrekitException)exception.getCause();
            }
            throw new OrekitException(exception.getCause(), (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, exception.getLocalizedMessage());
        }
    }

    private static class ParametersContainer {
        private final SpacecraftState initialState;
        private final OrekitStepInterpolator interpolator;
        private final SpacecraftState finalState;

        ParametersContainer(SpacecraftState initialState, OrekitStepInterpolator interpolator, SpacecraftState finalState) {
            this.initialState = initialState;
            this.interpolator = interpolator;
            this.finalState = finalState;
        }
    }

    private static class MultiplePropagatorsHandler
    implements OrekitStepHandler {
        private ParametersContainer previous = new ParametersContainer(null, null, null);
        private final SynchronousQueue<ParametersContainer> queue;

        MultiplePropagatorsHandler(SynchronousQueue<ParametersContainer> queue) {
            this.queue = queue;
        }

        private void handOff(ParametersContainer container) {
            try {
                this.previous = container;
                this.queue.put(this.previous);
            }
            catch (InterruptedException ie) {
                throw new PropagatorStoppingException(ie);
            }
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t) {
            this.handOff(new ParametersContainer(s0, null, null));
        }

        @Override
        public void handleStep(OrekitStepInterpolator interpolator) {
            this.handOff(new ParametersContainer(this.previous.initialState, interpolator, null));
        }

        @Override
        public void finish(SpacecraftState finalState) {
            this.handOff(new ParametersContainer(this.previous.initialState, this.previous.interpolator, finalState));
        }
    }

    private static class SinglePropagatorHandler
    implements OrekitStepHandler {
        private final MultiSatStepHandler globalHandler;

        SinglePropagatorHandler(MultiSatStepHandler globalHandler) {
            this.globalHandler = globalHandler;
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t) {
            this.globalHandler.init(Collections.singletonList(s0), t);
        }

        @Override
        public void handleStep(OrekitStepInterpolator interpolator) {
            this.globalHandler.handleStep(Collections.singletonList(interpolator));
        }

        @Override
        public void finish(SpacecraftState finalState) {
            this.globalHandler.finish(Collections.singletonList(finalState));
        }
    }

    private static class PropagatorStoppingException
    extends OrekitException {
        private static final long serialVersionUID = 20170629L;

        PropagatorStoppingException(InterruptedException ie) {
            super(ie, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, ie.getLocalizedMessage());
        }
    }
}

