/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.Arrays;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldCartesianOrbit<T extends CalculusFieldElement<T>>
extends FieldOrbit<T> {
    private final transient boolean hasNonKeplerianAcceleration;
    private transient FieldEquinoctialOrbit<T> equinoctial;
    private final Field<T> field;
    private final T zero;
    private final T one;

    public FieldCartesianOrbit(TimeStampedFieldPVCoordinates<T> pvaCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        super(pvaCoordinates, frame, mu);
        this.hasNonKeplerianAcceleration = FieldCartesianOrbit.hasNonKeplerianAcceleration(pvaCoordinates, mu);
        this.equinoctial = null;
        this.field = pvaCoordinates.getPosition().getX().getField();
        this.zero = (CalculusFieldElement)this.field.getZero();
        this.one = (CalculusFieldElement)this.field.getOne();
    }

    public FieldCartesianOrbit(FieldPVCoordinates<T> pvaCoordinates, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, pvaCoordinates), frame, mu);
    }

    public FieldCartesianOrbit(FieldOrbit<T> op) {
        super(op.getPVCoordinates(), op.getFrame(), op.getMu());
        this.hasNonKeplerianAcceleration = op.hasDerivatives();
        this.equinoctial = op instanceof FieldEquinoctialOrbit ? (FieldEquinoctialOrbit)op : (op instanceof FieldCartesianOrbit ? ((FieldCartesianOrbit)op).equinoctial : null);
        this.field = op.getA().getField();
        this.zero = (CalculusFieldElement)this.field.getZero();
        this.one = (CalculusFieldElement)this.field.getOne();
    }

    @Override
    public OrbitType getType() {
        return OrbitType.CARTESIAN;
    }

    private void initEquinoctial() {
        if (this.equinoctial == null) {
            this.equinoctial = this.hasDerivatives() ? new FieldEquinoctialOrbit(this.getPVCoordinates(), this.getFrame(), this.getDate(), this.getMu()) : new FieldEquinoctialOrbit(new FieldPVCoordinates(this.getPVCoordinates().getPosition(), this.getPVCoordinates().getVelocity()), this.getFrame(), this.getDate(), this.getMu());
        }
    }

    private FieldPVCoordinates<FieldUnivariateDerivative2<T>> getPVDerivatives() {
        TimeStampedFieldPVCoordinates pva = this.getPVCoordinates();
        FieldVector3D p = pva.getPosition();
        FieldVector3D v = pva.getVelocity();
        FieldVector3D a = pva.getAcceleration();
        FieldVector3D pG = new FieldVector3D((CalculusFieldElement)new FieldUnivariateDerivative2(p.getX(), v.getX(), a.getX()), (CalculusFieldElement)new FieldUnivariateDerivative2(p.getY(), v.getY(), a.getY()), (CalculusFieldElement)new FieldUnivariateDerivative2(p.getZ(), v.getZ(), a.getZ()));
        FieldVector3D vG = new FieldVector3D((CalculusFieldElement)new FieldUnivariateDerivative2(v.getX(), a.getX(), this.zero), (CalculusFieldElement)new FieldUnivariateDerivative2(v.getY(), a.getY(), this.zero), (CalculusFieldElement)new FieldUnivariateDerivative2(v.getZ(), a.getZ(), this.zero));
        return new FieldPVCoordinates<FieldUnivariateDerivative2<T>>(pG, vG);
    }

    @Override
    public T getA() {
        CalculusFieldElement r = this.getPVCoordinates().getPosition().getNorm();
        CalculusFieldElement V2 = this.getPVCoordinates().getVelocity().getNormSq();
        return (T)((CalculusFieldElement)r.divide(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.negate()).multiply((FieldElement)V2)).divide(this.getMu())).add(2.0)));
    }

    @Override
    public T getADot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldUnivariateDerivative2 r = (FieldUnivariateDerivative2)pv.getPosition().getNorm();
            FieldUnivariateDerivative2 V2 = (FieldUnivariateDerivative2)pv.getVelocity().getNormSq();
            FieldUnivariateDerivative2 a = r.divide(r.multiply(V2).divide(this.getMu()).subtract(2.0).negate());
            return (T)a.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getE() {
        CalculusFieldElement muA = (CalculusFieldElement)this.getA().multiply(this.getMu());
        if (muA.getReal() > 0.0) {
            FieldVector3D pvP = this.getPVCoordinates().getPosition();
            FieldVector3D pvV = this.getPVCoordinates().getVelocity();
            CalculusFieldElement rV2OnMu = (CalculusFieldElement)((CalculusFieldElement)pvP.getNorm().multiply((FieldElement)pvV.getNormSq())).divide(this.getMu());
            CalculusFieldElement eSE = (CalculusFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(muA.sqrt());
            CalculusFieldElement eCE = (CalculusFieldElement)rV2OnMu.subtract(1.0);
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eCE.multiply((FieldElement)eCE)).add(eSE.multiply((FieldElement)eSE))).sqrt());
        }
        FieldVector3D pvM = this.getPVCoordinates().getMomentum();
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)pvM.getNormSq().divide((FieldElement)muA)).negate()).add(1.0)).sqrt());
    }

    @Override
    public T getEDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldUnivariateDerivative2 r = (FieldUnivariateDerivative2)pv.getPosition().getNorm();
            FieldUnivariateDerivative2 V2 = (FieldUnivariateDerivative2)pv.getVelocity().getNormSq();
            FieldUnivariateDerivative2 rV2OnMu = r.multiply(V2).divide(this.getMu());
            FieldUnivariateDerivative2 a = r.divide(rV2OnMu.negate().add(2.0));
            FieldUnivariateDerivative2 eSE = ((FieldUnivariateDerivative2)FieldVector3D.dotProduct(pv.getPosition(), pv.getVelocity())).divide(a.multiply(this.getMu()).sqrt());
            FieldUnivariateDerivative2 eCE = rV2OnMu.subtract(1.0);
            FieldUnivariateDerivative2 e = eCE.multiply(eCE).add(eSE.multiply(eSE)).sqrt();
            return (T)e.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getI() {
        return (T)FieldVector3D.angle((FieldVector3D)new FieldVector3D(this.zero, this.zero, this.one), this.getPVCoordinates().getMomentum());
    }

    @Override
    public T getIDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldVector3D momentum = FieldVector3D.crossProduct(pv.getPosition(), pv.getVelocity());
            FieldUnivariateDerivative2 i = (FieldUnivariateDerivative2)FieldVector3D.angle((Vector3D)Vector3D.PLUS_K, (FieldVector3D)momentum);
            return (T)i.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getEquinoctialEx() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEx();
    }

    @Override
    public T getEquinoctialExDot() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialExDot();
    }

    @Override
    public T getEquinoctialEy() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEy();
    }

    @Override
    public T getEquinoctialEyDot() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEyDot();
    }

    @Override
    public T getHx() {
        FieldVector3D w = this.getPVCoordinates().getMomentum().normalize();
        double x = w.getX().getReal();
        double y = w.getY().getReal();
        double z = w.getZ().getReal();
        if (x * x + y * y == 0.0 && z < 0.0) {
            return (T)((CalculusFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)w.getY().negate()).divide(w.getZ().add(1.0)));
    }

    @Override
    public T getHxDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldVector3D w = FieldVector3D.crossProduct(pv.getPosition(), pv.getVelocity()).normalize();
            double x = ((FieldUnivariateDerivative2)w.getX()).getValue().getReal();
            double y = ((FieldUnivariateDerivative2)w.getY()).getValue().getReal();
            double z = ((FieldUnivariateDerivative2)w.getZ()).getValue().getReal();
            if (x * x + y * y == 0.0 && z < 0.0) {
                return (T)((CalculusFieldElement)this.zero.add(Double.NaN));
            }
            FieldUnivariateDerivative2 hx = ((FieldUnivariateDerivative2)w.getY()).negate().divide(((FieldUnivariateDerivative2)w.getZ()).add(1.0));
            return (T)hx.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getHy() {
        FieldVector3D w = this.getPVCoordinates().getMomentum().normalize();
        double x = w.getX().getReal();
        double y = w.getY().getReal();
        double z = w.getZ().getReal();
        if (x * x + y * y == 0.0 && z < 0.0) {
            return (T)((CalculusFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((CalculusFieldElement)w.getX().divide(w.getZ().add(1.0)));
    }

    @Override
    public T getHyDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldVector3D w = FieldVector3D.crossProduct(pv.getPosition(), pv.getVelocity()).normalize();
            double x = ((FieldUnivariateDerivative2)w.getX()).getValue().getReal();
            double y = ((FieldUnivariateDerivative2)w.getY()).getValue().getReal();
            double z = ((FieldUnivariateDerivative2)w.getZ()).getValue().getReal();
            if (x * x + y * y == 0.0 && z < 0.0) {
                return (T)((CalculusFieldElement)this.zero.add(Double.NaN));
            }
            FieldUnivariateDerivative2 hy = ((FieldUnivariateDerivative2)w.getX()).divide(((FieldUnivariateDerivative2)w.getZ()).add(1.0));
            return (T)hy.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getLv() {
        this.initEquinoctial();
        return this.equinoctial.getLv();
    }

    @Override
    public T getLvDot() {
        this.initEquinoctial();
        return this.equinoctial.getLvDot();
    }

    @Override
    public T getLE() {
        this.initEquinoctial();
        return this.equinoctial.getLE();
    }

    @Override
    public T getLEDot() {
        this.initEquinoctial();
        return this.equinoctial.getLEDot();
    }

    @Override
    public T getLM() {
        this.initEquinoctial();
        return this.equinoctial.getLM();
    }

    @Override
    public T getLMDot() {
        this.initEquinoctial();
        return this.equinoctial.getLMDot();
    }

    @Override
    public boolean hasDerivatives() {
        return this.hasNonKeplerianAcceleration;
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        return this.getPVCoordinates();
    }

    @Override
    public FieldCartesianOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((CalculusFieldElement)((CalculusFieldElement)this.getDate().getField().getZero()).add(dt));
    }

    @Override
    public FieldCartesianOrbit<T> shiftedBy(T dt) {
        FieldPVCoordinates<T> shiftedPV = this.getA().getReal() < 0.0 ? this.shiftPVHyperbolic(dt) : this.shiftPVElliptic(dt);
        return new FieldCartesianOrbit<T>(shiftedPV, this.getFrame(), this.getDate().shiftedBy(dt), this.getMu());
    }

    @Override
    public FieldCartesianOrbit<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldOrbit<T>> sample) {
        TimeStampedFieldPVCoordinates<T> interpolated = TimeStampedFieldPVCoordinates.interpolate(date, CartesianDerivativesFilter.USE_PVA, sample.map(orbit -> orbit.getPVCoordinates()));
        return new FieldCartesianOrbit<T>(interpolated, this.getFrame(), date, this.getMu());
    }

    private FieldPVCoordinates<T> shiftPVElliptic(T dt) {
        FieldVector3D pvP = this.getPVCoordinates().getPosition();
        FieldVector3D pvV = this.getPVCoordinates().getVelocity();
        CalculusFieldElement r2 = pvP.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement rV2OnMu = (CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)pvV.getNormSq())).divide(this.getMu());
        CalculusFieldElement a = (CalculusFieldElement)r.divide(((CalculusFieldElement)rV2OnMu.negate()).add(2.0));
        CalculusFieldElement eSE = (CalculusFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((CalculusFieldElement)a.multiply(this.getMu())).sqrt());
        CalculusFieldElement eCE = (CalculusFieldElement)rV2OnMu.subtract(1.0);
        CalculusFieldElement e2 = (CalculusFieldElement)((CalculusFieldElement)eCE.multiply((FieldElement)eCE)).add(eSE.multiply((FieldElement)eSE));
        FieldVector3D u = pvP.normalize();
        FieldVector3D v = FieldVector3D.crossProduct((FieldVector3D)FieldVector3D.crossProduct(pvP, pvV), (FieldVector3D)u).normalize();
        CalculusFieldElement ex = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eCE.subtract((FieldElement)e2)).multiply((FieldElement)a)).divide((FieldElement)r);
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)).sqrt();
        CalculusFieldElement ey = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s.negate()).multiply((FieldElement)eSE)).multiply((FieldElement)a)).divide((FieldElement)r);
        CalculusFieldElement beta = (CalculusFieldElement)((CalculusFieldElement)s.add(1.0)).reciprocal();
        CalculusFieldElement thetaE0 = (CalculusFieldElement)((CalculusFieldElement)ey.add(((CalculusFieldElement)eSE.multiply((FieldElement)beta)).multiply((FieldElement)ex))).atan2(((CalculusFieldElement)((CalculusFieldElement)r.divide((FieldElement)a)).add((FieldElement)ex)).subtract(((CalculusFieldElement)eSE.multiply((FieldElement)beta)).multiply((FieldElement)ey)));
        FieldSinCos scThetaE0 = FastMath.sinCos((CalculusFieldElement)thetaE0);
        CalculusFieldElement thetaM0 = (CalculusFieldElement)((CalculusFieldElement)thetaE0.subtract(ex.multiply((FieldElement)scThetaE0.sin()))).add(ey.multiply((FieldElement)scThetaE0.cos()));
        CalculusFieldElement sqrtMmuOA = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a.reciprocal()).multiply(this.getMu())).sqrt();
        CalculusFieldElement thetaM1 = (CalculusFieldElement)thetaM0.add(((CalculusFieldElement)sqrtMmuOA.divide((FieldElement)a)).multiply(dt));
        CalculusFieldElement thetaE1 = this.meanToEccentric(thetaM1, ex, ey);
        FieldSinCos scTE = FastMath.sinCos((CalculusFieldElement)thetaE1);
        CalculusFieldElement cTE = (CalculusFieldElement)scTE.cos();
        CalculusFieldElement sTE = (CalculusFieldElement)scTE.sin();
        CalculusFieldElement exey = (CalculusFieldElement)ex.multiply((FieldElement)ey);
        CalculusFieldElement exCeyS = (CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)cTE)).add(ey.multiply((FieldElement)sTE));
        CalculusFieldElement x = (CalculusFieldElement)a.multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)ey)).multiply((FieldElement)ey)).negate()).add(1.0)).multiply((FieldElement)cTE)).add(((CalculusFieldElement)beta.multiply((FieldElement)exey)).multiply((FieldElement)sTE))).subtract((FieldElement)ex));
        CalculusFieldElement y = (CalculusFieldElement)a.multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)ex)).multiply((FieldElement)ex)).negate()).add(1.0)).multiply((FieldElement)sTE)).add(((CalculusFieldElement)beta.multiply((FieldElement)exey)).multiply((FieldElement)cTE))).subtract((FieldElement)ey));
        CalculusFieldElement factor = (CalculusFieldElement)sqrtMmuOA.divide(((CalculusFieldElement)exCeyS.negate()).add(1.0));
        CalculusFieldElement xDot = (CalculusFieldElement)factor.multiply(((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)ey)).multiply((FieldElement)exCeyS)).subtract((FieldElement)sTE));
        CalculusFieldElement yDot = (CalculusFieldElement)factor.multiply(cTE.subtract(((CalculusFieldElement)beta.multiply((FieldElement)ex)).multiply((FieldElement)exCeyS)));
        FieldVector3D shiftedP = new FieldVector3D(x, u, y, v);
        FieldVector3D shiftedV = new FieldVector3D(xDot, u, yDot, v);
        if (this.hasNonKeplerianAcceleration) {
            FieldVector3D nonKeplerianAcceleration = new FieldVector3D(this.one, this.getPVCoordinates().getAcceleration(), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)r2)).reciprocal()).multiply(this.getMu()), pvP);
            FieldVector3D fixedP = new FieldVector3D(this.one, shiftedP, (CalculusFieldElement)((CalculusFieldElement)dt.multiply(dt)).multiply(0.5), nonKeplerianAcceleration);
            CalculusFieldElement fixedR2 = fixedP.getNormSq();
            CalculusFieldElement fixedR = (CalculusFieldElement)fixedR2.sqrt();
            FieldVector3D fixedV = new FieldVector3D(this.one, shiftedV, dt, nonKeplerianAcceleration);
            FieldVector3D fixedA = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fixedR.multiply((FieldElement)fixedR2)).reciprocal()).multiply(this.getMu().negate()), shiftedP, this.one, nonKeplerianAcceleration);
            return new FieldPVCoordinates(fixedP, fixedV, fixedA);
        }
        return new FieldPVCoordinates(shiftedP, shiftedV);
    }

    private FieldPVCoordinates<T> shiftPVHyperbolic(T dt) {
        TimeStampedFieldPVCoordinates pv = this.getPVCoordinates();
        FieldVector3D pvP = pv.getPosition();
        FieldVector3D pvV = pv.getVelocity();
        FieldVector3D pvM = pv.getMomentum();
        CalculusFieldElement r2 = pvP.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement rV2OnMu = (CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)pvV.getNormSq())).divide(this.getMu());
        T a = this.getA();
        CalculusFieldElement muA = (CalculusFieldElement)a.multiply(this.getMu());
        CalculusFieldElement e = (CalculusFieldElement)((CalculusFieldElement)this.one.subtract(FieldVector3D.dotProduct(pvM, pvM).divide((FieldElement)muA))).sqrt();
        CalculusFieldElement sqrt = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.add(1.0)).divide(e.subtract(1.0))).sqrt();
        CalculusFieldElement eSH = (CalculusFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((CalculusFieldElement)muA.negate()).sqrt());
        CalculusFieldElement eCH = (CalculusFieldElement)rV2OnMu.subtract(1.0);
        CalculusFieldElement H0 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eCH.add((FieldElement)eSH)).divide(eCH.subtract((FieldElement)eSH))).log()).divide(2.0);
        CalculusFieldElement M0 = (CalculusFieldElement)((CalculusFieldElement)e.multiply(H0.sinh())).subtract((FieldElement)H0);
        CalculusFieldElement v0 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt.multiply(((CalculusFieldElement)H0.divide(2.0)).tanh())).atan()).multiply(2);
        FieldVector3D p = new FieldRotation(pvM, v0, RotationConvention.FRAME_TRANSFORM).applyTo(pvP).normalize();
        FieldVector3D q = FieldVector3D.crossProduct(pvM, (FieldVector3D)p).normalize();
        CalculusFieldElement M1 = (CalculusFieldElement)M0.add(this.getKeplerianMeanMotion().multiply(dt));
        CalculusFieldElement H1 = this.meanToHyperbolicEccentric(M1, e);
        CalculusFieldElement cH = (CalculusFieldElement)H1.cosh();
        CalculusFieldElement sH = (CalculusFieldElement)H1.sinh();
        CalculusFieldElement sE2m1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.subtract(1.0)).multiply(e.add(1.0))).sqrt();
        CalculusFieldElement x = (CalculusFieldElement)a.multiply(cH.subtract((FieldElement)e));
        CalculusFieldElement y = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a.negate()).multiply((FieldElement)sE2m1)).multiply((FieldElement)sH);
        CalculusFieldElement factor = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getMu().divide(a.negate())).sqrt()).divide(((CalculusFieldElement)e.multiply((FieldElement)cH)).subtract(1.0));
        CalculusFieldElement xDot = (CalculusFieldElement)((CalculusFieldElement)factor.negate()).multiply((FieldElement)sH);
        CalculusFieldElement yDot = (CalculusFieldElement)((CalculusFieldElement)factor.multiply((FieldElement)sE2m1)).multiply((FieldElement)cH);
        FieldVector3D shiftedP = new FieldVector3D(x, p, y, q);
        FieldVector3D shiftedV = new FieldVector3D(xDot, p, yDot, q);
        if (this.hasNonKeplerianAcceleration) {
            FieldVector3D nonKeplerianAcceleration = new FieldVector3D(this.one, this.getPVCoordinates().getAcceleration(), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)r2)).reciprocal()).multiply(this.getMu()), pvP);
            FieldVector3D fixedP = new FieldVector3D(this.one, shiftedP, (CalculusFieldElement)((CalculusFieldElement)dt.multiply(dt)).multiply(0.5), nonKeplerianAcceleration);
            CalculusFieldElement fixedR2 = fixedP.getNormSq();
            CalculusFieldElement fixedR = (CalculusFieldElement)fixedR2.sqrt();
            FieldVector3D fixedV = new FieldVector3D(this.one, shiftedV, dt, nonKeplerianAcceleration);
            FieldVector3D fixedA = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fixedR.multiply((FieldElement)fixedR2)).reciprocal()).multiply(this.getMu().negate()), shiftedP, this.one, nonKeplerianAcceleration);
            return new FieldPVCoordinates(fixedP, fixedV, fixedA);
        }
        return new FieldPVCoordinates(shiftedP, shiftedV);
    }

    private T meanToEccentric(T thetaM, T ex, T ey) {
        Object thetaE = thetaM;
        Object thetaEMthetaM = this.zero;
        int iter = 0;
        do {
            FieldSinCos scThetaE = FastMath.sinCos(thetaE);
            CalculusFieldElement f2 = (CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)scThetaE.sin())).subtract(ey.multiply((FieldElement)scThetaE.cos()));
            CalculusFieldElement f1 = (CalculusFieldElement)((CalculusFieldElement)this.one.subtract(ex.multiply((FieldElement)scThetaE.cos()))).subtract(ey.multiply((FieldElement)scThetaE.sin()));
            CalculusFieldElement f0 = (CalculusFieldElement)thetaEMthetaM.subtract((FieldElement)f2);
            CalculusFieldElement f12 = (CalculusFieldElement)f1.multiply(2.0);
            CalculusFieldElement shift = (CalculusFieldElement)((CalculusFieldElement)f0.multiply((FieldElement)f12)).divide(((CalculusFieldElement)f1.multiply((FieldElement)f12)).subtract(f0.multiply((FieldElement)f2)));
            thetaEMthetaM = (CalculusFieldElement)thetaEMthetaM.subtract((FieldElement)shift);
            thetaE = (CalculusFieldElement)thetaM.add(thetaEMthetaM);
            if (!(FastMath.abs((double)shift.getReal()) <= 1.0E-12)) continue;
            return thetaE;
        } while (++iter < 50);
        throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.CONVERGENCE_FAILED, new Object[0]);
    }

    private T meanToHyperbolicEccentric(T M, T ecc) {
        CalculusFieldElement pi = (CalculusFieldElement)ecc.getPi();
        CalculusFieldElement H = ecc.getReal() < 1.6 ? (-pi.getReal() < M.getReal() && M.getReal() < 0.0 || M.getReal() > pi.getReal() ? (CalculusFieldElement)M.subtract(ecc) : (CalculusFieldElement)M.add(ecc)) : (ecc.getReal() < 3.6 && FastMath.abs((double)M.getReal()) > pi.getReal() ? (CalculusFieldElement)M.subtract(ecc.copySign(M)) : (CalculusFieldElement)M.divide(ecc.subtract(1.0)));
        int iter = 0;
        do {
            CalculusFieldElement f3 = (CalculusFieldElement)ecc.multiply(H.cosh());
            CalculusFieldElement f2 = (CalculusFieldElement)ecc.multiply(H.sinh());
            CalculusFieldElement f1 = (CalculusFieldElement)f3.subtract(1.0);
            CalculusFieldElement f0 = (CalculusFieldElement)((CalculusFieldElement)f2.subtract((FieldElement)H)).subtract(M);
            CalculusFieldElement f12 = (CalculusFieldElement)f1.multiply(2);
            CalculusFieldElement d = (CalculusFieldElement)f0.divide((FieldElement)f12);
            CalculusFieldElement fdf = (CalculusFieldElement)f1.subtract(d.multiply((FieldElement)f2));
            CalculusFieldElement ds = (CalculusFieldElement)f0.divide((FieldElement)fdf);
            CalculusFieldElement shift = (CalculusFieldElement)f0.divide(fdf.add(((CalculusFieldElement)ds.multiply((FieldElement)ds)).multiply(f3.divide(6.0))));
            H = (CalculusFieldElement)H.subtract((FieldElement)shift);
            if (!(FastMath.abs((double)shift.getReal()) <= 1.0E-12)) continue;
            return (T)H;
        } while (++iter < 50);
        throw new MathIllegalStateException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_HYPERBOLIC_ECCENTRIC_ANOMALY, new Object[]{iter});
    }

    private T[][] create6x6Identity() {
        CalculusFieldElement[][] identity = (CalculusFieldElement[][])MathArrays.buildArray(this.field, (int)6, (int)6);
        for (int i = 0; i < 6; ++i) {
            Arrays.fill(identity[i], this.zero);
            identity[i][i] = this.one;
        }
        return identity;
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    public void addKeplerContribution(PositionAngle type, T gm, T[] pDot) {
        TimeStampedFieldPVCoordinates pv = this.getPVCoordinates();
        FieldVector3D velocity = pv.getVelocity();
        pDot[0] = (CalculusFieldElement)pDot[0].add((FieldElement)velocity.getX());
        pDot[1] = (CalculusFieldElement)pDot[1].add((FieldElement)velocity.getY());
        pDot[2] = (CalculusFieldElement)pDot[2].add((FieldElement)velocity.getZ());
        FieldVector3D position = pv.getPosition();
        CalculusFieldElement r2 = position.getNormSq();
        CalculusFieldElement coeff = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.multiply(r2.sqrt())).reciprocal()).negate()).multiply(gm);
        pDot[3] = (CalculusFieldElement)pDot[3].add(coeff.multiply((FieldElement)position.getX()));
        pDot[4] = (CalculusFieldElement)pDot[4].add(coeff.multiply((FieldElement)position.getY()));
        pDot[5] = (CalculusFieldElement)pDot[5].add(coeff.multiply((FieldElement)position.getZ()));
    }

    public String toString() {
        String comma = ", ";
        PVCoordinates pv = this.getPVCoordinates().toPVCoordinates();
        Vector3D p = pv.getPosition();
        Vector3D v = pv.getVelocity();
        return "Cartesian parameters: {P(" + p.getX() + ", " + p.getY() + ", " + p.getZ() + "), V(" + v.getX() + ", " + v.getY() + ", " + v.getZ() + ")}";
    }

    @Override
    public CartesianOrbit toOrbit() {
        PVCoordinates pv = this.getPVCoordinates().toPVCoordinates();
        AbsoluteDate date = this.getPVCoordinates().getDate().toAbsoluteDate();
        if (this.hasDerivatives()) {
            return new CartesianOrbit(pv, this.getFrame(), date, this.getMu().getReal());
        }
        return new CartesianOrbit(new PVCoordinates(pv.getPosition(), pv.getVelocity()), this.getFrame(), date, this.getMu().getReal());
    }
}

