/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.BilinearInterpolatingFunction;
import org.hipparchus.analysis.interpolation.LinearInterpolator;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.analysis.polynomials.PolynomialSplineFunction;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.DataContext;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.InterpolationTableLoader;
import org.orekit.utils.ParameterDriver;

public class SaastamoinenModel
implements DiscreteTroposphericModel {
    public static final String DELTA_R_FILE_NAME = "^saastamoinen-correction\\.txt$";
    public static final double DEFAULT_LOW_ELEVATION_THRESHOLD = 0.05;
    private static final Pattern FIRST_DELTA_R_PATTERN = Pattern.compile("^\\^");
    private static final Pattern SECOND_DELTA_R_PATTERN = Pattern.compile("\\$$");
    private static final double[] X_VALUES_FOR_B = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0};
    private static final double[] Y_VALUES_FOR_B = new double[]{1.156, 1.079, 1.006, 0.938, 0.874, 0.813, 0.757, 0.654, 0.563};
    private static final double[] E_COEFFICIENTS = new double[]{-37.2465, 0.213166, -2.56908E-4};
    private final PolynomialSplineFunction bFunction;
    private final PolynomialFunction eFunction;
    private final BilinearInterpolatingFunction deltaRFunction;
    private double t0;
    private double p0;
    private double r0;
    private double lowElevationThreshold;

    public SaastamoinenModel(double t0, double p0, double r0) {
        this(t0, p0, r0, SaastamoinenModel.defaultDeltaR());
    }

    @DefaultDataContext
    public SaastamoinenModel(double t0, double p0, double r0, String deltaRFileName) {
        this(t0, p0, r0, deltaRFileName, DataContext.getDefault().getDataProvidersManager());
    }

    public SaastamoinenModel(double t0, double p0, double r0, String deltaRFileName, DataProvidersManager dataProvidersManager) {
        this(t0, p0, r0, deltaRFileName == null ? SaastamoinenModel.defaultDeltaR() : SaastamoinenModel.loadDeltaR(deltaRFileName, dataProvidersManager));
    }

    private SaastamoinenModel(double t0, double p0, double r0, BilinearInterpolatingFunction deltaR) {
        this.t0 = t0;
        this.p0 = p0;
        this.r0 = r0;
        this.bFunction = new LinearInterpolator().interpolate(X_VALUES_FOR_B, Y_VALUES_FOR_B);
        this.eFunction = new PolynomialFunction(E_COEFFICIENTS);
        this.deltaRFunction = deltaR;
        this.lowElevationThreshold = 0.05;
    }

    public static SaastamoinenModel getStandardModel() {
        return new SaastamoinenModel(291.16, 1013.25, 0.5);
    }

    @Override
    public double pathDelay(double elevation, GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        double fixedHeight = FastMath.min((double)FastMath.max((double)0.0, (double)point.getAltitude()), (double)5000.0);
        double T = this.t0 - 0.0065 * fixedHeight;
        double P = this.p0 * FastMath.pow((double)(1.0 - 2.26E-5 * fixedHeight), (double)5.225);
        double R = this.r0 * FastMath.exp((double)(-6.396E-4 * fixedHeight));
        double B = this.bFunction.value(fixedHeight / 1000.0);
        double e = R * FastMath.exp((double)this.eFunction.value(T));
        double z = FastMath.abs((double)(1.5707963267948966 - FastMath.max((double)elevation, (double)this.lowElevationThreshold)));
        double deltaR = this.getDeltaR(fixedHeight, z);
        double tan = FastMath.tan((double)z);
        double delta = 0.002277 / FastMath.cos((double)z) * (P + (1255.0 / T + 0.05) * e - B * tan * tan) + deltaR;
        return delta;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T pathDelay(T elevation, FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement fixedHeight = FastMath.min((CalculusFieldElement)FastMath.max((CalculusFieldElement)zero, point.getAltitude()), (CalculusFieldElement)((CalculusFieldElement)zero.add(5000.0)));
        CalculusFieldElement T = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fixedHeight.multiply(0.0065)).negate()).add(this.t0);
        CalculusFieldElement P = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fixedHeight.multiply(2.26E-5)).negate()).add(1.0)).pow(5.225)).multiply(this.p0);
        CalculusFieldElement R = (CalculusFieldElement)FastMath.exp((CalculusFieldElement)((CalculusFieldElement)fixedHeight.multiply(-6.396E-4))).multiply(this.r0);
        CalculusFieldElement B = this.bFunction.value((CalculusFieldElement)fixedHeight.divide(1000.0));
        CalculusFieldElement e = (CalculusFieldElement)R.multiply((FieldElement)FastMath.exp((CalculusFieldElement)this.eFunction.value(T)));
        CalculusFieldElement z = FastMath.abs((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.max(elevation, (CalculusFieldElement)((CalculusFieldElement)zero.add(this.lowElevationThreshold))).negate()).add(((CalculusFieldElement)zero.getPi()).multiply(0.5))));
        CalculusFieldElement deltaR = this.getDeltaR(fixedHeight, z, field);
        CalculusFieldElement tan = FastMath.tan((CalculusFieldElement)z);
        CalculusFieldElement delta = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.cos((CalculusFieldElement)z).divide(0.002277)).reciprocal()).multiply(((CalculusFieldElement)P.add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)T.divide(1255.0)).reciprocal()).add(0.05)).multiply((FieldElement)e))).subtract(((CalculusFieldElement)B.multiply((FieldElement)tan)).multiply((FieldElement)tan)))).add((FieldElement)deltaR);
        return (T)delta;
    }

    private double getDeltaR(double height, double zenith) {
        double h = FastMath.min((double)FastMath.max((double)0.0, (double)height), (double)5000.0);
        double z = FastMath.min((double)Math.abs(zenith), (double)1.5707963267948966);
        return this.deltaRFunction.value(h, z);
    }

    private <T extends CalculusFieldElement<T>> T getDeltaR(T height, T zenith, Field<T> field) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement h = FastMath.min((CalculusFieldElement)FastMath.max((CalculusFieldElement)zero, height), (CalculusFieldElement)((CalculusFieldElement)zero.add(5000.0)));
        CalculusFieldElement z = FastMath.min((CalculusFieldElement)((CalculusFieldElement)zenith.abs()), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)zero.getPi()).multiply(0.5)));
        return (T)this.deltaRFunction.value(h, z);
    }

    private static BilinearInterpolatingFunction loadDeltaR(String deltaRFileName, DataProvidersManager dataProvidersManager) {
        InterpolationTableLoader loader = new InterpolationTableLoader();
        dataProvidersManager.feed(deltaRFileName, loader);
        if (!loader.stillAcceptsData()) {
            double[] elevations = loader.getOrdinateGrid();
            for (int i = 0; i < elevations.length; ++i) {
                elevations[i] = FastMath.toRadians((double)elevations[i]);
            }
            return new BilinearInterpolatingFunction(loader.getAbscissaGrid(), elevations, loader.getValuesSamples());
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, SECOND_DELTA_R_PATTERN.matcher(FIRST_DELTA_R_PATTERN.matcher(deltaRFileName).replaceAll("")).replaceAll(""));
    }

    private static BilinearInterpolatingFunction defaultDeltaR() {
        double[] xValForR = new double[]{0.0, 500.0, 1000.0, 1500.0, 2000.0, 3000.0, 4000.0, 5000.0};
        double[] yValForR = new double[]{FastMath.toRadians((double)0.0), FastMath.toRadians((double)60.0), FastMath.toRadians((double)66.0), FastMath.toRadians((double)70.0), FastMath.toRadians((double)73.0), FastMath.toRadians((double)75.0), FastMath.toRadians((double)76.0), FastMath.toRadians((double)77.0), FastMath.toRadians((double)78.0), FastMath.toRadians((double)78.5), FastMath.toRadians((double)79.0), FastMath.toRadians((double)79.5), FastMath.toRadians((double)79.75), FastMath.toRadians((double)80.0), FastMath.toRadians((double)90.0)};
        double[][] fval = new double[][]{{0.0, 0.003, 0.006, 0.012, 0.02, 0.031, 0.039, 0.05, 0.065, 0.075, 0.087, 0.102, 0.111, 0.121, 0.121}, {0.0, 0.003, 0.006, 0.011, 0.018, 0.028, 0.035, 0.045, 0.059, 0.068, 0.079, 0.093, 0.101, 0.11, 0.11}, {0.0, 0.002, 0.005, 0.01, 0.017, 0.025, 0.032, 0.041, 0.054, 0.062, 0.072, 0.085, 0.092, 0.1, 0.1}, {0.0, 0.002, 0.005, 0.009, 0.015, 0.023, 0.029, 0.037, 0.049, 0.056, 0.065, 0.077, 0.083, 0.091, 0.091}, {0.0, 0.002, 0.004, 0.008, 0.013, 0.021, 0.026, 0.033, 0.044, 0.051, 0.059, 0.07, 0.076, 0.083, 0.083}, {0.0, 0.002, 0.003, 0.006, 0.011, 0.017, 0.021, 0.027, 0.036, 0.042, 0.049, 0.058, 0.063, 0.068, 0.068}, {0.0, 0.001, 0.003, 0.005, 0.009, 0.014, 0.017, 0.022, 0.03, 0.034, 0.04, 0.047, 0.052, 0.056, 0.056}, {0.0, 0.001, 0.002, 0.004, 0.007, 0.011, 0.014, 0.018, 0.024, 0.028, 0.033, 0.039, 0.043, 0.047, 0.047}};
        return new BilinearInterpolatingFunction(xValForR, yValForR, (double[][])fval);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    public double getLowElevationThreshold() {
        return this.lowElevationThreshold;
    }

    public void setLowElevationThreshold(double lowElevationThreshold) {
        this.lowElevationThreshold = lowElevationThreshold;
    }
}

