/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.ionosphere;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.SinCos;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeComponents;

class NeQuickParameters {
    private static final double X0 = 86.23292796211615;
    private final double nmF2;
    private final double hmF2;
    private final double hmF1;
    private final double hmE;
    private final double b2Bot;
    private final double b1Top;
    private final double b1Bot;
    private final double beTop;
    private final double beBot;
    private final double h0;
    private final double[] amplitudes;

    NeQuickParameters(DateTimeComponents dateTime, double[][][] f2, double[][][] fm3, double latitude, double longitude, double[] alpha, double[][] modipGrip) {
        double nmF1;
        double modip = this.computeMODIP(latitude, longitude, modipGrip);
        double az = this.computeAz(modip, alpha);
        double azr = FastMath.sqrt((double)(167273.0 + (az - 63.7) * 1123.6)) - 408.99;
        DateComponents date = dateTime.getDate();
        TimeComponents time = dateTime.getTime();
        double hours = time.getSecondsInUTCDay() / 3600.0;
        double xeff = this.computeEffectiveSolarAngle(date.getMonth(), hours, latitude, longitude);
        double[][] af2 = new double[76][13];
        for (int j = 0; j < 76; ++j) {
            for (int k = 0; k < 13; ++k) {
                af2[j][k] = f2[0][j][k] * (1.0 - azr * 0.01) + f2[1][j][k] * (azr * 0.01);
            }
        }
        double[][] am3 = new double[49][9];
        for (int j = 0; j < 49; ++j) {
            for (int k = 0; k < 9; ++k) {
                am3[j][k] = fm3[0][j][k] * (1.0 - azr * 0.01) + fm3[1][j][k] * (azr * 0.01);
            }
        }
        this.hmE = 120.0;
        double foE = this.computefoE(date.getMonth(), az, xeff, latitude);
        double nmE = 0.124 * foE * foE;
        double t = FastMath.toRadians((double)(15.0 * hours)) - Math.PI;
        double[] cf2 = this.computeCF2(af2, t);
        double[] cm3 = this.computeCm3(am3, t);
        double foF2 = this.computefoF2(modip, cf2, latitude, longitude);
        double mF2 = this.computeMF2(modip, cm3, latitude, longitude);
        this.nmF2 = 0.124 * foF2 * foF2;
        this.hmF2 = this.computehmF2(foE, foF2, mF2);
        double foF1 = this.computefoF1(foE, foF2);
        if (foF1 <= 0.0 && foE > 2.0) {
            double foEpopf = foE + 0.5;
            nmF1 = 0.124 * foEpopf * foEpopf;
        } else {
            nmF1 = 0.124 * foF1 * foF1;
        }
        this.hmF1 = 0.5 * (this.hmF2 + this.hmE);
        double a = 0.01 * this.clipExp(-3.467 + 0.857 * FastMath.log((double)(foF2 * foF2)) + 2.02 * FastMath.log((double)mF2));
        this.b2Bot = 0.385 * this.nmF2 / a;
        this.b1Top = 0.3 * (this.hmF2 - this.hmF1);
        this.b1Bot = 0.5 * (this.hmF1 - this.hmE);
        this.beTop = FastMath.max((double)this.b1Bot, (double)7.0);
        this.beBot = 5.0;
        this.amplitudes = this.computeLayerAmplitudes(nmE, nmF1, foF1);
        this.h0 = this.computeH0(date.getMonth(), azr);
    }

    public double getNmF2() {
        return this.nmF2;
    }

    public double getHmF2() {
        return this.hmF2;
    }

    public double getHmF1() {
        return this.hmF1;
    }

    public double getHmE() {
        return this.hmE;
    }

    public double getB2Bot() {
        return this.b2Bot;
    }

    public double getB1Top() {
        return this.b1Top;
    }

    public double getB1Bot() {
        return this.b1Bot;
    }

    public double getBEBot() {
        return this.beBot;
    }

    public double getBETop() {
        return this.beTop;
    }

    public double[] getLayerAmplitudes() {
        return (double[])this.amplitudes.clone();
    }

    public double getH0() {
        return this.h0;
    }

    private double computeMODIP(double lat, double lon, double[][] stModip) {
        double latitude = FastMath.toDegrees((double)lat);
        double longitude = FastMath.toDegrees((double)lon);
        if (latitude == 90.0 || latitude == -90.0) {
            return latitude;
        }
        int lF = (int)((longitude + 180.0) * 0.1);
        int l = lF - 2;
        if (l < 0) {
            l += 36;
        } else if (l > 33) {
            l -= 36;
        }
        double a = 0.2 * (latitude + 90.0) + 1.0;
        double aF = FastMath.floor((double)a);
        double x = a - aF;
        int i = (int)aF - 2;
        double z1 = this.interpolate(stModip[i + 1][l + 2], stModip[i + 2][l + 2], stModip[i + 3][l + 2], stModip[i + 4][l + 2], x);
        double z2 = this.interpolate(stModip[i + 1][l + 3], stModip[i + 2][l + 3], stModip[i + 3][l + 3], stModip[i + 4][l + 3], x);
        double z3 = this.interpolate(stModip[i + 1][l + 4], stModip[i + 2][l + 4], stModip[i + 3][l + 4], stModip[i + 4][l + 4], x);
        double z4 = this.interpolate(stModip[i + 1][l + 5], stModip[i + 2][l + 5], stModip[i + 3][l + 5], stModip[i + 4][l + 5], x);
        double b = (longitude + 180.0) * 0.1;
        double bF = FastMath.floor((double)b);
        double y = b - bF;
        double modip = this.interpolate(z1, z2, z3, z4, y);
        return modip;
    }

    private double computeAz(double modip, double[] alpha) {
        if (alpha[0] == 0.0 && alpha[1] == 0.0 && alpha[2] == 0.0) {
            return 63.7;
        }
        double az = alpha[0] + modip * (alpha[1] + modip * alpha[2]);
        az = FastMath.max((double)0.0, (double)az);
        az = FastMath.min((double)400.0, (double)az);
        return az;
    }

    private double computeEffectiveSolarAngle(int month, double hours, double latitude, double longitude) {
        double lt = hours + longitude / FastMath.toRadians((double)15.0);
        double dy = 30.5 * (double)month - 15.0;
        double t = dy + (18.0 - hours) / 24.0;
        double am = FastMath.toRadians((double)(0.9856 * t - 3.289));
        double al = am + FastMath.toRadians((double)(1.916 * FastMath.sin((double)am) + 0.02 * FastMath.sin((double)(2.0 * am)) + 282.634));
        double sDec = 0.39782 * FastMath.sin((double)al);
        double cDec = FastMath.sqrt((double)(1.0 - sDec * sDec));
        SinCos scLat = FastMath.sinCos((double)latitude);
        double coef = 0.2617993877991494 * (12.0 - lt);
        double cZenith = scLat.sin() * sDec + scLat.cos() * cDec * FastMath.cos((double)coef);
        double angle = FastMath.atan2((double)FastMath.sqrt((double)(1.0 - cZenith * cZenith)), (double)cZenith);
        double x = FastMath.toDegrees((double)angle);
        double xeff = this.join(90.0 - 0.24 * this.clipExp(20.0 - 0.2 * x), x, 12.0, x - 86.23292796211615);
        return FastMath.toRadians((double)xeff);
    }

    private double computefoE(int month, double az, double xeff, double latitude) {
        double lat = FastMath.toDegrees((double)latitude);
        double sqAz = FastMath.sqrt((double)az);
        int seas = month == 1 || month == 2 || month == 11 || month == 12 ? -1 : (month == 3 || month == 4 || month == 9 || month == 10 ? 0 : 1);
        double ee = this.clipExp(0.3 * lat);
        double seasp = (double)seas * ((ee - 1.0) / (ee + 1.0));
        double coef = 1.112 - 0.019 * seasp;
        double foE = FastMath.sqrt((double)(coef * coef * sqAz * FastMath.pow((double)FastMath.cos((double)xeff), (double)0.6) + 0.49));
        return foE;
    }

    private double computehmF2(double foE, double foF2, double mF2) {
        double fo = foF2 / foE;
        double ratio = this.join(fo, 1.75, 20.0, fo - 1.75);
        double deltaM = -0.012;
        if (foE >= 1.0E-30) {
            deltaM += 0.253 / (ratio - 1.215);
        }
        double mF2Sq = mF2 * mF2;
        double temp = FastMath.sqrt((double)((0.0196 * mF2Sq + 1.0) / (1.2967 * mF2Sq - 1.0)));
        double height = 1490.0 * mF2 * temp / (mF2 + deltaM) - 176.0;
        return height;
    }

    private double[] computeCF2(double[][] af2, double t) {
        double[] cf2 = new double[76];
        for (int i = 0; i < cf2.length; ++i) {
            double sum = 0.0;
            for (int k = 0; k < 6; ++k) {
                SinCos sc = FastMath.sinCos((double)((double)(k + 1) * t));
                sum += af2[i][2 * k + 1] * sc.sin() + af2[i][2 * (k + 1)] * sc.cos();
            }
            cf2[i] = af2[i][0] + sum;
        }
        return cf2;
    }

    private double[] computeCm3(double[][] am3, double t) {
        double[] cm3 = new double[49];
        for (int i = 0; i < cm3.length; ++i) {
            double sum = 0.0;
            for (int k = 0; k < 4; ++k) {
                SinCos sc = FastMath.sinCos((double)((double)(k + 1) * t));
                sum += am3[i][2 * k + 1] * sc.sin() + am3[i][2 * (k + 1)] * sc.cos();
            }
            cm3[i] = am3[i][0] + sum;
        }
        return cm3;
    }

    private double computefoF2(double modip, double[] cf2, double latitude, double longitude) {
        int[] q = new int[]{12, 12, 9, 5, 2, 1, 1, 1, 1};
        double[] g = new double[cf2.length];
        g[0] = 1.0;
        double sinMODIP = FastMath.sin((double)FastMath.toRadians((double)modip));
        double[] m = new double[12];
        m[0] = 1.0;
        for (int i = 1; i < q[0]; ++i) {
            m[i] = sinMODIP * m[i - 1];
            g[i] = m[i];
        }
        double cosLat = FastMath.cos((double)latitude);
        double[] p = new double[8];
        p[0] = cosLat;
        for (int n = 2; n < 9; ++n) {
            p[n - 1] = cosLat * p[n - 2];
        }
        int index = 12;
        for (int i = 1; i < q.length; ++i) {
            SinCos sc = FastMath.sinCos((double)((double)i * longitude));
            for (int j = 0; j < q[i]; ++j) {
                g[index++] = m[j] * p[i - 1] * sc.cos();
                g[index++] = m[j] * p[i - 1] * sc.sin();
            }
        }
        double frequency = MathArrays.linearCombination((double[])cf2, (double[])g);
        return frequency;
    }

    private double computeMF2(double modip, double[] cm3, double latitude, double longitude) {
        int[] r = new int[]{7, 8, 6, 3, 2, 1, 1};
        double[] g = new double[cm3.length];
        g[0] = 1.0;
        double sinMODIP = FastMath.sin((double)FastMath.toRadians((double)modip));
        double[] m = new double[12];
        m[0] = 1.0;
        for (int i = 1; i < 12; ++i) {
            m[i] = sinMODIP * m[i - 1];
            if (i >= 7) continue;
            g[i] = m[i];
        }
        double cosLat = FastMath.cos((double)latitude);
        double[] p = new double[8];
        p[0] = cosLat;
        for (int n = 2; n < 9; ++n) {
            p[n - 1] = cosLat * p[n - 2];
        }
        int index = 7;
        for (int i = 1; i < r.length; ++i) {
            SinCos sc = FastMath.sinCos((double)((double)i * longitude));
            for (int j = 0; j < r[i]; ++j) {
                g[index++] = m[j] * p[i - 1] * sc.cos();
                g[index++] = m[j] * p[i - 1] * sc.sin();
            }
        }
        double m3000 = MathArrays.linearCombination((double[])g, (double[])cm3);
        return m3000;
    }

    private double computefoF1(double foE, double foF2) {
        double temp = this.join(1.4 * foE, 0.0, 1000.0, foE - 2.0);
        double temp2 = this.join(0.0, temp, 1000.0, foE - temp);
        double value = this.join(temp2, 0.85 * temp2, 60.0, 0.85 * foF2 - temp2);
        if (value < 1.0E-6) {
            return 0.0;
        }
        return value;
    }

    private double[] computeLayerAmplitudes(double nmE, double nmF1, double foF1) {
        double a1;
        double[] amplitude = new double[3];
        amplitude[0] = a1 = 4.0 * this.nmF2;
        if (foF1 < 0.5) {
            amplitude[1] = 0.0;
            amplitude[2] = 4.0 * (nmE - this.epst(a1, this.hmF2, this.b2Bot, this.hmE));
        } else {
            double a2a = 0.0;
            double a3a = 4.0 * nmE;
            for (int i = 0; i < 5; ++i) {
                a2a = 4.0 * (nmF1 - this.epst(a1, this.hmF2, this.b2Bot, this.hmF1) - this.epst(a3a, this.hmE, this.beTop, this.hmF1));
                a2a = this.join(a2a, 0.8 * nmF1, 1.0, a2a - 0.8 * nmF1);
                a3a = 4.0 * (nmE - this.epst(a2a, this.hmF1, this.b1Bot, this.hmE) - this.epst(a1, this.hmF2, this.b2Bot, this.hmE));
            }
            amplitude[1] = a2a;
            amplitude[2] = this.join(a3a, 0.05, 60.0, a3a - 0.005);
        }
        return amplitude;
    }

    private double computeH0(int month, double azr) {
        double ka;
        if (month > 3 && month < 10) {
            ka = 6.705 - 0.014 * azr - 0.008 * this.hmF2;
        } else {
            double ratio = this.hmF2 / this.b2Bot;
            ka = -7.77 + 0.097 * ratio * ratio + 0.153 * this.nmF2;
        }
        double kb = this.join(ka, 2.0, 1.0, ka - 2.0);
        kb = this.join(8.0, kb, 1.0, kb - 8.0);
        double hA = kb * this.b2Bot;
        double x = 0.01 * (hA - 150.0);
        double v = (0.041163 * x - 0.183981) * x + 1.424472;
        double h = hA / v;
        return h;
    }

    private double clipExp(double power) {
        if (power > 80.0) {
            return 5.5406E34;
        }
        if (power < -80.0) {
            return 1.8049E-35;
        }
        return FastMath.exp((double)power);
    }

    private double interpolate(double z1, double z2, double z3, double z4, double x) {
        if (FastMath.abs((double)(2.0 * x)) < 1.0E-10) {
            return z2;
        }
        double delta = 2.0 * x - 1.0;
        double g1 = z3 + z2;
        double g2 = z3 - z2;
        double g3 = z4 + z1;
        double g4 = (z4 - z1) / 3.0;
        double a0 = 9.0 * g1 - g3;
        double a1 = 9.0 * g2 - g4;
        double a2 = g3 - g1;
        double a3 = g4 - g2;
        double zx = 0.0625 * (a0 + delta * (a1 + delta * (a2 + delta * a3)));
        return zx;
    }

    private double join(double dF1, double dF2, double dA, double dX) {
        double ee = this.clipExp(dA * dX);
        return (dF1 * ee + dF2) / (ee + 1.0);
    }

    private double epst(double x, double y, double z, double w) {
        double ex = this.clipExp((w - y) / z);
        double opex = 1.0 + ex;
        double epst = x * ex / (opex * opex);
        return epst;
    }
}

