/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.omm;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.odm.CartesianCovariance;
import org.orekit.files.ccsds.ndm.odm.KeplerianElements;
import org.orekit.files.ccsds.ndm.odm.KeplerianElementsKey;
import org.orekit.files.ccsds.ndm.odm.SpacecraftParameters;
import org.orekit.files.ccsds.ndm.odm.UserDefined;
import org.orekit.files.ccsds.ndm.odm.omm.OmmTle;
import org.orekit.files.ccsds.section.Data;

public class OmmData
implements Data {
    private final KeplerianElements keplerianElementsBlock;
    private final SpacecraftParameters spacecraftParameters;
    private final OmmTle tleBlock;
    private final CartesianCovariance covarianceBlock;
    private final UserDefined userDefinedBlock;
    private final double mass;

    public OmmData(KeplerianElements keplerianElementsBlock, SpacecraftParameters spacecraftParameters, OmmTle tleBlock, CartesianCovariance covarianceBlock, UserDefined userDefinedBlock, double mass) {
        this.keplerianElementsBlock = keplerianElementsBlock;
        this.spacecraftParameters = spacecraftParameters;
        this.tleBlock = tleBlock;
        this.covarianceBlock = covarianceBlock;
        this.userDefinedBlock = userDefinedBlock;
        this.mass = mass;
    }

    @Override
    public void validate(double version) {
        if (this.keplerianElementsBlock == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, new Object[]{KeplerianElementsKey.EPOCH});
        }
        this.keplerianElementsBlock.validate(version);
        if (this.spacecraftParameters != null) {
            this.spacecraftParameters.validate(version);
        }
        if (this.tleBlock == null) {
            this.keplerianElementsBlock.checkNotNaN(this.keplerianElementsBlock.getA(), KeplerianElementsKey.SEMI_MAJOR_AXIS);
        } else {
            this.keplerianElementsBlock.checkNotNaN(this.keplerianElementsBlock.getMeanMotion(), KeplerianElementsKey.MEAN_MOTION);
            this.tleBlock.validate(version);
        }
        if (this.covarianceBlock != null) {
            this.covarianceBlock.setEpoch(this.keplerianElementsBlock.getEpoch());
            this.covarianceBlock.validate(version);
        }
        if (this.userDefinedBlock != null) {
            this.userDefinedBlock.validate(version);
        }
    }

    public KeplerianElements getKeplerianElementsBlock() {
        return this.keplerianElementsBlock;
    }

    public SpacecraftParameters getSpacecraftParametersBlock() {
        return this.spacecraftParameters;
    }

    public OmmTle getTLEBlock() {
        return this.tleBlock;
    }

    public CartesianCovariance getCovarianceBlock() {
        return this.covarianceBlock;
    }

    public UserDefined getUserDefinedBlock() {
        return this.userDefinedBlock;
    }

    public double getMass() {
        return this.mass;
    }
}

