/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.ocm.Perturbations;
import org.orekit.files.ccsds.ndm.odm.ocm.ShadowModel;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.utils.units.Unit;

public enum PerturbationsKey {
    COMMENT((token, context, container) -> token.getType() == TokenType.ENTRY ? container.addComment(token.getContentAsNormalizedString()) : true),
    ATMOSPHERIC_MODEL((token, context, container) -> token.processAsNormalizedString(container::setAtmosphericModel)),
    GRAVITY_MODEL(new GravityProcessor()),
    EQUATORIAL_RADIUS((token, context, container) -> token.processAsDouble(Unit.KILOMETRE, context.getParsedUnitsBehavior(), container::setEquatorialRadius)),
    GM((token, context, container) -> token.processAsDouble(Units.KM3_PER_S2, context.getParsedUnitsBehavior(), container::setGm)),
    N_BODY_PERTURBATIONS((token, context, container) -> token.processAsCenterList(container::setNBodyPerturbations, context.getDataContext().getCelestialBodies())),
    CENTRAL_BODY_ROTATION((token, context, container) -> token.processAsDouble(Units.DEG_PER_S, context.getParsedUnitsBehavior(), container::setCentralBodyRotation)),
    OBLATE_FLATTENING((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setOblateFlattening)),
    OCEAN_TIDES_MODEL((token, context, container) -> token.processAsNormalizedString(container::setOceanTidesModel)),
    SOLID_TIDES_MODEL((token, context, container) -> token.processAsNormalizedString(container::setSolidTidesModel)),
    REDUCTION_THEORY((token, context, container) -> token.processAsNormalizedString(container::setReductionTheory)),
    ALBEDO_MODEL((token, context, container) -> token.processAsNormalizedString(container::setAlbedoModel)),
    ALBEDO_GRID_SIZE((token, context, container) -> token.processAsInteger(container::setAlbedoGridSize)),
    SHADOW_MODEL((token, context, container) -> token.processAsEnum(ShadowModel.class, container::setShadowModel)),
    SHADOW_BODIES((token, context, container) -> token.processAsCenterList(container::setShadowBodies, context.getDataContext().getCelestialBodies())),
    SRP_MODEL((token, context, container) -> token.processAsNormalizedString(container::setSrpModel)),
    SW_DATA_SOURCE((token, context, container) -> token.processAsNormalizedString(container::setSpaceWeatherSource)),
    SW_DATA_EPOCH((token, context, container) -> token.processAsDate(container::setSpaceWeatherEpoch, context)),
    SW_INTERP_METHOD((token, context, container) -> token.processAsNormalizedString(container::setInterpMethodSW)),
    FIXED_GEOMAG_KP((token, context, container) -> token.processAsDouble(Units.NANO_TESLA, context.getParsedUnitsBehavior(), container::setFixedGeomagneticKp)),
    FIXED_GEOMAG_AP((token, context, container) -> token.processAsDouble(Units.NANO_TESLA, context.getParsedUnitsBehavior(), container::setFixedGeomagneticAp)),
    FIXED_GEOMAG_DST((token, context, container) -> token.processAsDouble(Units.NANO_TESLA, context.getParsedUnitsBehavior(), container::setFixedGeomagneticDst)),
    FIXED_F10P7((token, context, container) -> token.processAsDouble(Unit.SOLAR_FLUX_UNIT, context.getParsedUnitsBehavior(), container::setFixedF10P7)),
    FIXED_F10P7_MEAN((token, context, container) -> token.processAsDouble(Unit.SOLAR_FLUX_UNIT, context.getParsedUnitsBehavior(), container::setFixedF10P7Mean)),
    FIXED_M10P7((token, context, container) -> token.processAsDouble(Unit.SOLAR_FLUX_UNIT, context.getParsedUnitsBehavior(), container::setFixedM10P7)),
    FIXED_M10P7_MEAN((token, context, container) -> token.processAsDouble(Unit.SOLAR_FLUX_UNIT, context.getParsedUnitsBehavior(), container::setFixedM10P7Mean)),
    FIXED_S10P7((token, context, container) -> token.processAsDouble(Unit.SOLAR_FLUX_UNIT, context.getParsedUnitsBehavior(), container::setFixedS10P7)),
    FIXED_S10P7_MEAN((token, context, container) -> token.processAsDouble(Unit.SOLAR_FLUX_UNIT, context.getParsedUnitsBehavior(), container::setFixedS10P7Mean)),
    FIXED_Y10P7((token, context, container) -> token.processAsDouble(Unit.SOLAR_FLUX_UNIT, context.getParsedUnitsBehavior(), container::setFixedY10P7)),
    FIXED_Y10P7_MEAN((token, context, container) -> token.processAsDouble(Unit.SOLAR_FLUX_UNIT, context.getParsedUnitsBehavior(), container::setFixedY10P7Mean));

    private final TokenProcessor processor;

    private PerturbationsKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, Perturbations container) {
        return this.processor.process(token, context, container);
    }

    private static class GravityProcessor
    implements TokenProcessor {
        private static final Pattern GRAVITY_PATTERN = Pattern.compile("^\\p{Blank}*([-_A-Za-z0-9]+)\\p{Blank}*:\\p{Blank}*([0-9]+)D\\p{Blank}*([0-9]+)O\\p{Blank}*$");

        private GravityProcessor() {
        }

        @Override
        public boolean process(ParseToken token, ContextBinding context, Perturbations container) {
            if (token.getType() == TokenType.ENTRY) {
                Matcher matcher = GRAVITY_PATTERN.matcher(token.getContentAsNormalizedString());
                if (!matcher.matches()) {
                    throw token.generateException(null);
                }
                container.setGravityModel(matcher.group(1), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            }
            return true;
        }
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, Perturbations var3);
    }
}

