/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import org.orekit.files.ccsds.ndm.odm.ocm.CovarianceIndexer;

public enum Ordering {
    LTM{

        @Override
        int nbElements(int dimension) {
            return dimension * (dimension + 1) / 2;
        }

        @Override
        void update(CovarianceIndexer indexer) {
            int i = indexer.getRow();
            int j = indexer.getColumn();
            if (j < i) {
                indexer.setColumn(j + 1);
            } else {
                indexer.setRow(i + 1);
                indexer.setColumn(0);
            }
        }
    }
    ,
    UTM{

        @Override
        int nbElements(int dimension) {
            return dimension * (dimension + 1) / 2;
        }

        @Override
        void update(CovarianceIndexer indexer) {
            int i = indexer.getRow();
            int j = indexer.getColumn();
            if (j + 1 < indexer.getDimension()) {
                indexer.setColumn(j + 1);
            } else {
                indexer.setRow(i + 1);
                indexer.setColumn(i + 1);
            }
        }
    }
    ,
    FULL{

        @Override
        int nbElements(int dimension) {
            return dimension * dimension;
        }

        @Override
        void update(CovarianceIndexer indexer) {
            int i = indexer.getRow();
            int j = indexer.getColumn();
            if (j + 1 < indexer.getDimension()) {
                indexer.setColumn(j + 1);
            } else {
                indexer.setRow(i + 1);
                indexer.setColumn(0);
            }
        }
    }
    ,
    LTMWCC{

        @Override
        int nbElements(int dimension) {
            return FULL.nbElements(dimension);
        }

        @Override
        void update(CovarianceIndexer indexer) {
            FULL.update(indexer);
            indexer.setCrossCorrelation(indexer.getColumn() > indexer.getRow());
        }
    }
    ,
    UTMWCC{

        @Override
        int nbElements(int dimension) {
            return FULL.nbElements(dimension);
        }

        @Override
        void update(CovarianceIndexer indexer) {
            FULL.update(indexer);
            indexer.setCrossCorrelation(indexer.getRow() > indexer.getColumn());
        }
    };


    abstract int nbElements(int var1);

    abstract void update(CovarianceIndexer var1);
}

