/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.aem;

import java.util.Arrays;
import org.orekit.files.ccsds.ndm.adm.AttitudeType;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadata;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedAngularCoordinates;

class AttitudeEntry {
    private final AemMetadata metadata;
    private AbsoluteDate epoch;
    private double[] components;

    AttitudeEntry(AemMetadata metadata) {
        this.metadata = metadata;
        this.components = new double[8];
        Arrays.fill(this.components, Double.NaN);
    }

    public AemMetadata getMetadata() {
        return this.metadata;
    }

    public void setEpoch(AbsoluteDate epoch) {
        this.epoch = epoch;
    }

    public void setComponent(int i, double value) {
        this.components[i] = value;
    }

    public void setAngle(char axis, double value) {
        if (this.metadata.getEulerRotSeq() != null) {
            String seq = this.metadata.getEulerRotSeq().name();
            if (seq.charAt(0) == axis && Double.isNaN(this.components[0])) {
                this.components[0] = value;
            } else if (seq.charAt(1) == axis && Double.isNaN(this.components[1])) {
                this.components[1] = value;
            } else if (seq.charAt(2) == axis && Double.isNaN(this.components[2])) {
                this.components[2] = value;
            }
        }
    }

    public void setRate(char axis, double value) {
        if (this.metadata.getEulerRotSeq() != null) {
            int first;
            String seq = this.metadata.getEulerRotSeq().name();
            int n = first = this.metadata.getAttitudeType() == AttitudeType.QUATERNION_RATE ? 4 : 3;
            if (seq.charAt(0) == axis && Double.isNaN(this.components[first])) {
                this.components[first] = value;
            } else if (seq.charAt(1) == axis && Double.isNaN(this.components[first + 1])) {
                this.components[first + 1] = value;
            } else if (seq.charAt(2) == axis && Double.isNaN(this.components[first + 2])) {
                this.components[first + 2] = value;
            }
        }
    }

    public TimeStampedAngularCoordinates getCoordinates() {
        return this.metadata.getAttitudeType().build(this.metadata.isFirst(), this.metadata.getEndpoints().isExternal2SpacecraftBody(), this.metadata.getEulerRotSeq(), this.metadata.isSpacecraftBodyRate(), this.epoch, this.components);
    }
}

