/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm;

import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.NdmConstituent;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.adm.RotationXmlTokenBuilder;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.files.ccsds.utils.lexical.XmlTokenBuilder;
import org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public abstract class AdmParser<T extends NdmConstituent<?, ?>, P extends AbstractConstituentParser<T, ?>>
extends AbstractConstituentParser<T, P> {
    private static final String ROTATION_1 = "rotation1";
    private static final String ROTATION_2 = "rotation2";
    private static final String ROTATION_3 = "rotation3";
    private final AbsoluteDate missionReferenceDate;

    protected AdmParser(String root, String formatVersionKey, IERSConventions conventions, boolean simpleEOP, DataContext dataContext, AbsoluteDate missionReferenceDate, ParsedUnitsBehavior parsedUnitsBehavior) {
        super(root, formatVersionKey, conventions, simpleEOP, dataContext, parsedUnitsBehavior);
        this.missionReferenceDate = missionReferenceDate;
    }

    @Override
    public Map<String, XmlTokenBuilder> getSpecialXmlElementsBuilders() {
        Map<String, XmlTokenBuilder> builders = super.getSpecialXmlElementsBuilders();
        builders.put(ROTATION_1, new RotationXmlTokenBuilder());
        builders.put(ROTATION_2, new RotationXmlTokenBuilder());
        builders.put(ROTATION_3, new RotationXmlTokenBuilder());
        return builders;
    }

    public AbsoluteDate getMissionReferenceDate() {
        return this.missionReferenceDate;
    }

    public static boolean processRotationOrder(ParseToken sequence, RotationOrderConsumer consumer) {
        if (sequence.getType() == TokenType.ENTRY) {
            try {
                consumer.accept(RotationOrder.valueOf((String)sequence.getContentAsUppercaseString().replace('1', 'X').replace('2', 'Y').replace('3', 'Z')));
            }
            catch (IllegalArgumentException iae) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_ROTATION_SEQUENCE, sequence.getContentAsUppercaseString(), sequence.getLineNumber(), sequence.getFileName());
            }
        }
        return true;
    }

    public static interface RotationOrderConsumer {
        public void accept(RotationOrder var1);
    }
}

