/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.definitions;

import org.hipparchus.CalculusFieldElement;
import org.orekit.bodies.CelestialBody;
import org.orekit.files.ccsds.definitions.CelestialBodyFrame;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public class ModifiedFrame
extends Frame {
    private static final long serialVersionUID = 20170619L;
    private final CelestialBodyFrame refFrame;
    private final String centerName;

    public ModifiedFrame(Frame frame, CelestialBodyFrame refFrame, CelestialBody body, String centerName) {
        super(frame, new OriginTransformProvider(body, frame), body.getName() + "/" + frame.getName(), frame.isPseudoInertial());
        this.refFrame = refFrame;
        this.centerName = centerName;
    }

    public CelestialBodyFrame getRefFrame() {
        return this.refFrame;
    }

    public String getCenterName() {
        return this.centerName;
    }

    private static class OriginTransformProvider
    implements TransformProvider {
        private static final long serialVersionUID = 20170619L;
        private final CelestialBody body;
        private final Frame frame;

        OriginTransformProvider(CelestialBody body, Frame frame) {
            this.body = body;
            this.frame = frame;
        }

        @Override
        public Transform getTransform(AbsoluteDate date) {
            return new Transform(date, this.body.getPVCoordinates(date, this.frame).negate());
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
            return new FieldTransform<T>(date, this.body.getPVCoordinates(date, this.frame).negate());
        }
    }
}

