/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.definitions;

import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.files.ccsds.definitions.CelestialBodyFrame;
import org.orekit.files.ccsds.definitions.OrbitRelativeFrame;
import org.orekit.files.ccsds.definitions.SpacecraftBodyFrame;
import org.orekit.frames.Frame;
import org.orekit.utils.IERSConventions;

public class FrameFacade {
    private final Frame frame;
    private final CelestialBodyFrame celestialBodyFrame;
    private final OrbitRelativeFrame orbitRelativeFrame;
    private final SpacecraftBodyFrame spacecraftBodyFrame;
    private final String name;

    public FrameFacade(Frame frame, CelestialBodyFrame celestialBodyFrame, OrbitRelativeFrame orbitRelativeFrame, SpacecraftBodyFrame spacecraftBodyFrame, String name) {
        this.frame = frame;
        this.celestialBodyFrame = celestialBodyFrame;
        this.orbitRelativeFrame = orbitRelativeFrame;
        this.spacecraftBodyFrame = spacecraftBodyFrame;
        this.name = name;
    }

    public Frame asFrame() {
        return this.frame;
    }

    public CelestialBodyFrame asCelestialBodyFrame() {
        return this.celestialBodyFrame;
    }

    public OrbitRelativeFrame asOrbitRelativeFrame() {
        return this.orbitRelativeFrame;
    }

    public SpacecraftBodyFrame asSpacecraftBodyFrame() {
        return this.spacecraftBodyFrame;
    }

    public String getName() {
        return this.name;
    }

    public static FrameFacade map(Frame frame) {
        CelestialBodyFrame cbf = CelestialBodyFrame.map(frame);
        return new FrameFacade(frame, cbf, null, null, cbf.name());
    }

    public static FrameFacade parse(String name, IERSConventions conventions, boolean simpleEOP, DataContext dataContext, boolean allowCelestial, boolean allowOrbit, boolean allowSpacecraft) {
        try {
            CelestialBodyFrame cbf = CelestialBodyFrame.parse(name);
            if (allowCelestial) {
                return new FrameFacade(cbf.getFrame(conventions, simpleEOP, dataContext), cbf, null, null, cbf.name());
            }
        }
        catch (IllegalArgumentException iaeC) {
            try {
                OrbitRelativeFrame orf = OrbitRelativeFrame.valueOf(name.replace(' ', '_'));
                if (allowOrbit) {
                    return new FrameFacade(null, null, orf, null, orf.name());
                }
            }
            catch (IllegalArgumentException iaeO) {
                try {
                    SpacecraftBodyFrame sbf = SpacecraftBodyFrame.parse(name.replace(' ', '_'));
                    if (allowSpacecraft) {
                        return new FrameFacade(null, null, null, sbf, sbf.toString());
                    }
                }
                catch (IllegalArgumentException | OrekitException runtimeException) {
                    // empty catch block
                }
            }
        }
        return new FrameFacade(null, null, null, null, name);
    }
}

