/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.List;
import org.orekit.estimation.sequential.AbstractKalmanModel;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanEstimator;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.propagation.integration.AbstractJacobiansMapper;
import org.orekit.propagation.semianalytical.dsst.DSSTJacobiansMapper;
import org.orekit.propagation.semianalytical.dsst.DSSTPartialDerivativesEquations;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.utils.ParameterDriversList;

public class DSSTKalmanModel
extends AbstractKalmanModel {
    public DSSTKalmanModel(List<OrbitDeterminationPropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> covarianceMatricesProviders, ParameterDriversList estimatedMeasurementParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix, PropagationType propagationType, PropagationType stateType) {
        super(propagatorBuilders, covarianceMatricesProviders, estimatedMeasurementParameters, measurementProcessNoiseMatrix, new DSSTJacobiansMapper[propagatorBuilders.size()], propagationType, stateType);
    }

    @Override
    protected void updateReferenceTrajectories(Propagator[] propagators, PropagationType pType, PropagationType sType) {
        this.setReferenceTrajectories(propagators);
        AbstractJacobiansMapper[] mappers = this.getMappers();
        for (int k = 0; k < propagators.length; ++k) {
            String equationName = KalmanEstimator.class.getName() + "-derivatives-" + k;
            DSSTPartialDerivativesEquations pde = new DSSTPartialDerivativesEquations(equationName, (DSSTPropagator)this.getReferenceTrajectories()[k], pType);
            SpacecraftState rawState = this.getReferenceTrajectories()[k].getInitialState();
            SpacecraftState stateWithDerivatives = pde.setInitialJacobians(rawState);
            ((DSSTPropagator)this.getReferenceTrajectories()[k]).setInitialState(stateWithDerivatives, sType);
            mappers[k] = pde.getMapper();
        }
        this.setMappers(mappers);
    }

    @Override
    protected void analyticalDerivativeComputations(AbstractJacobiansMapper mapper, SpacecraftState state) {
        ((DSSTJacobiansMapper)mapper).setShortPeriodJacobians(state);
    }
}

