/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.gnss.Phase;
import org.orekit.estimation.measurements.modifiers.IonosphericGradientConverter;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;

public class PhaseIonosphericDelayModifier
implements EstimationModifier<Phase> {
    private final IonosphericModel ionoModel;
    private final double frequency;

    public PhaseIonosphericDelayModifier(IonosphericModel model, double freq) {
        this.ionoModel = model;
        this.frequency = freq;
    }

    private double phaseErrorIonosphericModel(GroundStation station, SpacecraftState state) {
        TopocentricFrame baseFrame = station.getBaseFrame();
        double wavelength = 2.99792458E8 / this.frequency;
        double delay = this.ionoModel.pathDelay(state, baseFrame, this.frequency, this.ionoModel.getParameters());
        return delay / wavelength;
    }

    private <T extends CalculusFieldElement<T>> T phaseErrorIonosphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        TopocentricFrame baseFrame = station.getBaseFrame();
        double wavelength = 2.99792458E8 / this.frequency;
        CalculusFieldElement delay = this.ionoModel.pathDelay(state, baseFrame, this.frequency, (CalculusFieldElement[])parameters);
        return (T)((CalculusFieldElement)delay.divide(wavelength));
    }

    private double[][] phaseErrorJacobianState(double[] derivatives, int freeStateParameters) {
        double[][] finiteDifferencesJacobian = new double[1][6];
        for (int i = 0; i < freeStateParameters; ++i) {
            finiteDifferencesJacobian[0][i] = derivatives[i];
        }
        return finiteDifferencesJacobian;
    }

    private double phaseErrorParameterDerivative(GroundStation station, ParameterDriver driver, SpacecraftState state) {
        ParameterFunction phaseError = parameterDriver -> this.phaseErrorIonosphericModel(station, state);
        ParameterFunction phaseErrorDerivative = Differentiation.differentiate(phaseError, 3, 10.0 * driver.getScale());
        return phaseErrorDerivative.value(driver);
    }

    private double[] phaseErrorParameterDerivative(double[] derivatives, int freeStateParameters) {
        int dim = derivatives.length - freeStateParameters;
        double[] phaseError = new double[dim];
        for (int i = 0; i < dim; ++i) {
            phaseError[i] = derivatives[freeStateParameters + i];
        }
        return phaseError;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.ionoModel.getParametersDrivers();
    }

    @Override
    public void modify(EstimatedMeasurement<Phase> estimated) {
        double parameterDerivative;
        Phase measurement = estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        IonosphericGradientConverter converter = new IonosphericGradientConverter(state, 6, new InertialProvider(state.getFrame()));
        FieldSpacecraftState<Gradient> gState = converter.getState(this.ionoModel);
        Gradient[] gParameters = converter.getParameters(gState, this.ionoModel);
        Gradient gDelay = (Gradient)this.phaseErrorIonosphericModel(station, gState, (CalculusFieldElement[])gParameters);
        double[] derivatives = gDelay.getGradient();
        double[][] djac = this.phaseErrorJacobianState(derivatives, converter.getFreeStateParameters());
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                double[] dArray = stateDerivatives[irow];
                int n = jcol;
                dArray[n] = dArray[n] - djac[irow][jcol];
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int index = 0;
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            double[] dDelaydP = this.phaseErrorParameterDerivative(derivatives, converter.getFreeStateParameters());
            estimated.setParameterDerivatives(driver, parameterDerivative -= dDelaydP[index]);
            ++index;
        }
        for (ParameterDriver driver : Arrays.asList(station.getClockOffsetDriver(), station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative -= this.phaseErrorParameterDerivative(station, driver, state));
        }
        double[] newValue = (double[])oldValue.clone();
        newValue[0] = newValue[0] - gDelay.getValue();
        estimated.setEstimatedValue(newValue);
    }
}

