/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.leastsquares;

import java.util.List;
import org.orekit.estimation.leastsquares.AbstractBatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.TLEJacobiansMapper;
import org.orekit.propagation.analytical.tle.TLEPartialDerivativesEquations;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.propagation.integration.AbstractJacobiansMapper;
import org.orekit.utils.ParameterDriversList;

public class TLEBatchLSModel
extends AbstractBatchLSModel {
    public TLEBatchLSModel(OrbitDeterminationPropagatorBuilder[] propagatorBuilders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer) {
        super(propagatorBuilders, measurements, estimatedMeasurementsParameters, new TLEJacobiansMapper[propagatorBuilders.length], observer);
    }

    @Override
    protected TLEJacobiansMapper configureDerivatives(Propagator propagator) {
        String equationName = TLEBatchLSModel.class.getName() + "-derivatives";
        TLEPartialDerivativesEquations partials = new TLEPartialDerivativesEquations(equationName, (TLEPropagator)propagator);
        SpacecraftState rawState = propagator.getInitialState();
        SpacecraftState stateWithDerivatives = partials.setInitialJacobians(rawState);
        propagator.resetInitialState(stateWithDerivatives);
        return partials.getMapper();
    }

    @Override
    protected Orbit configureOrbits(AbstractJacobiansMapper mapper, Propagator propagator) {
        return propagator.getInitialState().getOrbit();
    }
}

