/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.leastsquares;

import java.util.List;
import org.orekit.estimation.leastsquares.AbstractBatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.propagation.integration.AbstractJacobiansMapper;
import org.orekit.propagation.numerical.JacobiansMapper;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.numerical.PartialDerivativesEquations;
import org.orekit.utils.ParameterDriversList;

public class BatchLSModel
extends AbstractBatchLSModel {
    public BatchLSModel(OrbitDeterminationPropagatorBuilder[] propagatorBuilders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer) {
        super(propagatorBuilders, measurements, estimatedMeasurementsParameters, new JacobiansMapper[propagatorBuilders.length], observer);
    }

    @Override
    protected JacobiansMapper configureDerivatives(Propagator propagator) {
        String equationName = BatchLSModel.class.getName() + "-derivatives";
        PartialDerivativesEquations partials = new PartialDerivativesEquations(equationName, (NumericalPropagator)propagator);
        SpacecraftState rawState = propagator.getInitialState();
        SpacecraftState stateWithDerivatives = partials.setInitialJacobians(rawState);
        propagator.resetInitialState(stateWithDerivatives);
        return partials.getMapper();
    }

    @Override
    protected Orbit configureOrbits(AbstractJacobiansMapper mapper, Propagator propagator) {
        return propagator.getInitialState().getOrbit();
    }
}

